function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) { ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } } return n; }, _extends.apply(null, arguments); }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) { o = n[r], -1 === t.indexOf(o) && {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) { if ({}.hasOwnProperty.call(r, n)) { if (-1 !== e.indexOf(n)) continue; t[n] = r[n]; } } return t; }
/*
 * SPDX-License-Identifier: Apache-2.0
 *
 * The OpenSearch Contributors require contributions made to
 * this file be licensed under the Apache-2.0 license or a
 * compatible open source license.
 *
 * Modifications Copyright OpenSearch Contributors. See
 * GitHub history for details.
 */

/*
 * Licensed to Elasticsearch B.V. under one or more contributor
 * license agreements. See the NOTICE file distributed with
 * this work for additional information regarding copyright
 * ownership. Elasticsearch B.V. licenses this file to you under
 * the Apache License, Version 2.0 (the "License"); you may
 * not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *    http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing,
 * software distributed under the License is distributed on an
 * "AS IS" BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
 * KIND, either express or implied.  See the License for the
 * specific language governing permissions and limitations
 * under the License.
 */

import React from 'react';
import PropTypes from "prop-types";
import { OuiButtonIcon } from '../button';
import { useOuiI18n } from '../i18n';
import classNames from 'classnames';
export var OuiNotificationEventReadButton = function OuiNotificationEventReadButton(_ref) {
  var id = _ref.id,
    isRead = _ref.isRead,
    onClick = _ref.onClick,
    eventName = _ref.eventName,
    rest = _objectWithoutProperties(_ref, ["id", "isRead", "onClick", "eventName"]);
  var classesReadState = classNames('ouiNotificationEventReadButton', {
    'ouiNotificationEventReadButton--isRead': isRead
  });
  var markAsReadAria = useOuiI18n('ouiNotificationEventReadButton.markAsReadAria', 'Mark {eventName} as read', {
    eventName: eventName
  });
  var markAsUnreadAria = useOuiI18n('ouiNotificationEventReadButton.markAsUnreadAria', 'Mark {eventName} as unread', {
    eventName: eventName
  });
  var markAsRead = useOuiI18n('ouiNotificationEventReadButton.markAsRead', 'Mark as read');
  var markAsUnread = useOuiI18n('ouiNotificationEventReadButton.markAsUnread', 'Mark as unread');
  var buttonAriaLabel = isRead ? markAsUnreadAria : markAsReadAria;
  var buttonTitle = isRead ? markAsUnread : markAsRead;
  return /*#__PURE__*/React.createElement(OuiButtonIcon, _extends({
    iconType: "dot",
    "aria-label": buttonAriaLabel,
    title: buttonTitle,
    className: classesReadState,
    onClick: onClick,
    "data-test-subj": "".concat(id, "-notificationEventReadButton")
  }, rest));
};

/* OUI -> EUI Aliases: Build-Time */
OuiNotificationEventReadButton.propTypes = {
  /**
     * Any of the named color palette options.
     * **`subdued` set to be DEPRECATED, use `text` instead**
     */
  color: PropTypes.oneOf(["accent", "danger", "ghost", "primary", "subdued", "success", "text", "warning"]),
  "aria-label": PropTypes.string,
  "aria-labelledby": PropTypes.string,
  /**
     * Size of the icon only.
     * This will not affect the overall size of the button
     */
  iconSize: PropTypes.oneOf(["original", "s", "m", "l", "xl", "xxl"]),
  /**
     * Sets the display style for matching other OuiButton types.
     * `base` is equivelant to a typical OuiButton
     * `fill` is equivelant to a filled OuiButton
     * `empty` (default) is equivelant to an OuiButtonEmpty
     */
  display: PropTypes.oneOf(["base", "empty", "fill"]),
  className: PropTypes.string,
  "data-test-subj": PropTypes.string,
  id: PropTypes.string.isRequired,
  /**
     * Shows an indicator of the read state of the event
     */
  isRead: PropTypes.bool.isRequired,
  /**
     * Applies an `onClick` handler to the `read` indicator.
     */
  onClick: PropTypes.func.isRequired,
  /**
     * A unique, human-friendly name for the event to be used in aria attributes (e.g. "alert-critical-01", "cloud-no-severity-12", etc..).
     */
  eventName: PropTypes.string.isRequired
};
/* OUI -> EUI Aliases: Build-Time */export { EuiNotificationEventReadButton } from '../../eui_components/notification/notification_event_read_button';