"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createReport = void 0;
var _constants = require("../utils/constants");
var _savedSearchReportHelper = require("../utils/savedSearchReportHelper");
var _saveReport = require("./saveReport");
var _lodash = _interopRequireDefault(require("lodash"));
var _helpers = require("../utils/helpers");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright OpenSearch Contributors
 * SPDX-License-Identifier: Apache-2.0
 */

const createReport = async (request, context, report, config, savedReportId) => {
  const isScheduledTask = false;
  //@ts-ignore
  const logger = context.reporting_plugin.logger;
  // @ts-ignore
  const opensearchReportsClient = context.reporting_plugin.opensearchReportsClient.asScoped(request);
  const opensearchClient = context.core.opensearch.legacy.client;
  // @ts-ignore
  const timezone = request.query.timezone;
  // @ts-ignore
  const dateFormat = request.query.dateFormat || _constants.DATA_REPORT_CONFIG.excelDateFormat;
  // @ts-ignore
  const csvSeparator = request.query.csvSeparator || ',';
  // @ts-ignore
  const allowLeadingWildcards = !!request.query.allowLeadingWildcards;
  const protocol = config.get('osd_server', 'protocol');
  const hostname = config.get('osd_server', 'hostname');
  const port = config.get('osd_server', 'port');
  const basePath = config.osdConfig.get('server', 'basePath');
  let createReportResult;
  let reportId;
  const {
    report_definition: {
      report_params: reportParams
    }
  } = report;
  const {
    report_source: reportSource
  } = reportParams;
  try {
    // create new report instance and set report state to "pending"
    if (savedReportId) {
      reportId = savedReportId;
    } else {
      const opensearchResp = await (0, _saveReport.saveReport)(report, opensearchReportsClient);
      reportId = opensearchResp.reportInstance.id;
    }
    // generate report
    if (reportSource === _constants.REPORT_TYPE.savedSearch) {
      createReportResult = await (0, _savedSearchReportHelper.createSavedSearchReport)(report, opensearchClient, dateFormat, csvSeparator, allowLeadingWildcards, isScheduledTask, logger, timezone);
    } else {
      // report source can only be one of [saved search, visualization, dashboard, notebook]
      // compose url
      const relativeUrl = report.query_url.startsWith(basePath) ? report.query_url : `${basePath}${report.query_url}`;
      const completeQueryUrl = `${protocol}://${hostname}:${port}${relativeUrl}`;
      const extraHeaders = _lodash.default.pick(request.headers, _constants.EXTRA_HEADERS);
      const {
        core_params,
        report_name: reportName,
        report_source: reportSource
      } = reportParams;
      const coreParams = core_params;
      const {
        header,
        footer,
        window_height: windowHeight,
        window_width: windowWidth,
        report_format: reportFormat
      } = coreParams;
      const curTime = new Date();
      const timeCreated = curTime.valueOf();
      const fileName = `${(0, _helpers.getFileName)(reportName, curTime)}.${reportFormat}`;
      return {
        timeCreated,
        dataUrl: '',
        fileName,
        reportId,
        queryUrl: relativeUrl
      };
    }
    // update report state to "created"
    // TODO: temporarily remove the following
    // if (!savedReportId) {
    //   await updateReportState(reportId, opensearchReportsClient, REPORT_STATE.created);
    // }
  } catch (error) {
    // update report instance with "error" state
    // TODO: save error detail and display on UI
    // TODO: temporarily disable the following, will add back
    // if (!savedReportId) {
    //   await updateReportState(reportId, opensearchReportsClient, REPORT_STATE.error);
    // }
    throw error;
  }
  return createReportResult;
};
exports.createReport = createReport;
//# sourceMappingURL=data:application/json;charset=utf-8;base64,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