/*
 * Decompiled with CFR 0.152.
 */
package com.microsoft.windowsazure.core.pipeline.apache;

import com.microsoft.windowsazure.core.pipeline.apache.FilterInterceptor;
import com.microsoft.windowsazure.core.pipeline.apache.HttpHeaderRemovalFilter;
import com.microsoft.windowsazure.core.pipeline.filter.ServiceRequestFilter;
import java.util.Map;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.socket.LayeredConnectionSocketFactory;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.HttpClientBuilder;

public class ApacheConfigSettings {
    private final String profile;
    private final Map<String, Object> properties;

    public ApacheConfigSettings(String profile, Map<String, Object> properties) {
        this.profile = profile;
        this.properties = properties;
    }

    public HttpClientBuilder applyConfig(HttpClientBuilder httpClientBuilder) {
        if (this.properties.containsKey(this.profile + "com.microsoft.windowsazure.Configuration.sslConnectionSocketFactory")) {
            httpClientBuilder.setSSLSocketFactory((LayeredConnectionSocketFactory)this.properties.get(this.profile + "com.microsoft.windowsazure.Configuration.sslConnectionSocketFactory"));
        }
        if (this.properties.containsKey(this.profile + "com.microsoft.windowsazure.Configuration.connectionManager")) {
            httpClientBuilder.setConnectionManager((HttpClientConnectionManager)this.properties.get(this.profile + "com.microsoft.windowsazure.Configuration.connectionManager"));
        }
        if (this.properties.containsKey(this.profile + "com.microsoft.windowsazure.Configuration.proxy")) {
            httpClientBuilder.setProxy(new HttpHost((String)this.properties.get(this.profile + "com.microsoft.windowsazure.Configuration.proxy")));
        }
        if (this.properties.containsKey(this.profile + "com.microsoft.windowsazure.Configuration.retryHandler")) {
            httpClientBuilder.setRetryHandler((HttpRequestRetryHandler)this.properties.get(this.profile + "com.microsoft.windowsazure.Configuration.retryHandler"));
        }
        if (this.properties.containsKey(this.profile + "com.microsoft.windowsazure.Configuration.httpClientBuilder")) {
            return (HttpClientBuilder)this.properties.get(this.profile + "com.microsoft.windowsazure.Configuration.httpClientBuilder");
        }
        if (this.properties.containsKey(this.profile + "com.microsoft.windowsazure.Configuration.redirectStrategy")) {
            httpClientBuilder.setRedirectStrategy((RedirectStrategy)((DefaultRedirectStrategy)this.properties.get(this.profile + "com.microsoft.windowsazure.Configuration.redirectStrategy")));
            httpClientBuilder.addInterceptorFirst((HttpRequestInterceptor)new HttpHeaderRemovalFilter());
        }
        if (this.properties.containsKey("AuthFilter")) {
            ServiceRequestFilter filter = (ServiceRequestFilter)this.properties.get("AuthFilter");
            httpClientBuilder.addInterceptorFirst((HttpRequestInterceptor)new FilterInterceptor(filter));
        }
        if (this.properties.containsKey(this.profile + "http.proxyHost") && this.properties.containsKey(this.profile + "http.proxyPort")) {
            String proxyHost = (String)this.properties.get(this.profile + "http.proxyHost");
            int proxyPort = Integer.parseInt((String)this.properties.get(this.profile + "http.proxyPort"));
            HttpHost proxy = this.properties.containsKey(this.profile + "http.proxyScheme") ? new HttpHost(proxyHost, proxyPort, (String)this.properties.get(this.profile + "http.proxyScheme")) : new HttpHost(proxyHost, proxyPort);
            httpClientBuilder.setProxy(proxy);
        }
        return httpClientBuilder;
    }
}

