/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Ec2Response;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessTrustProvider;
import software.amazon.awssdk.services.ec2.model.VerifiedAccessTrustProviderListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class DescribeVerifiedAccessTrustProvidersResponse
extends Ec2Response
implements ToCopyableBuilder<Builder, DescribeVerifiedAccessTrustProvidersResponse> {
    private static final SdkField<List<VerifiedAccessTrustProvider>> VERIFIED_ACCESS_TRUST_PROVIDERS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("VerifiedAccessTrustProviders").getter(DescribeVerifiedAccessTrustProvidersResponse.getter(DescribeVerifiedAccessTrustProvidersResponse::verifiedAccessTrustProviders)).setter(DescribeVerifiedAccessTrustProvidersResponse.setter(Builder::verifiedAccessTrustProviders)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VerifiedAccessTrustProviderSet").unmarshallLocationName("verifiedAccessTrustProviderSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(VerifiedAccessTrustProvider::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final SdkField<String> NEXT_TOKEN_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NextToken").getter(DescribeVerifiedAccessTrustProvidersResponse.getter(DescribeVerifiedAccessTrustProvidersResponse::nextToken)).setter(DescribeVerifiedAccessTrustProvidersResponse.setter(Builder::nextToken)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NextToken").unmarshallLocationName("nextToken").build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(VERIFIED_ACCESS_TRUST_PROVIDERS_FIELD, NEXT_TOKEN_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = DescribeVerifiedAccessTrustProvidersResponse.memberNameToFieldInitializer();
    private final List<VerifiedAccessTrustProvider> verifiedAccessTrustProviders;
    private final String nextToken;

    private DescribeVerifiedAccessTrustProvidersResponse(BuilderImpl builder) {
        super(builder);
        this.verifiedAccessTrustProviders = builder.verifiedAccessTrustProviders;
        this.nextToken = builder.nextToken;
    }

    public final boolean hasVerifiedAccessTrustProviders() {
        return this.verifiedAccessTrustProviders != null && !(this.verifiedAccessTrustProviders instanceof SdkAutoConstructList);
    }

    public final List<VerifiedAccessTrustProvider> verifiedAccessTrustProviders() {
        return this.verifiedAccessTrustProviders;
    }

    public final String nextToken() {
        return this.nextToken;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + super.hashCode();
        hashCode = 31 * hashCode + Objects.hashCode(this.hasVerifiedAccessTrustProviders() ? this.verifiedAccessTrustProviders() : null);
        hashCode = 31 * hashCode + Objects.hashCode(this.nextToken());
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return super.equals(obj) && this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof DescribeVerifiedAccessTrustProvidersResponse)) {
            return false;
        }
        DescribeVerifiedAccessTrustProvidersResponse other = (DescribeVerifiedAccessTrustProvidersResponse)((Object)obj);
        return this.hasVerifiedAccessTrustProviders() == other.hasVerifiedAccessTrustProviders() && Objects.equals(this.verifiedAccessTrustProviders(), other.verifiedAccessTrustProviders()) && Objects.equals(this.nextToken(), other.nextToken());
    }

    public final String toString() {
        return ToString.builder((String)"DescribeVerifiedAccessTrustProvidersResponse").add("VerifiedAccessTrustProviders", this.hasVerifiedAccessTrustProviders() ? this.verifiedAccessTrustProviders() : null).add("NextToken", (Object)this.nextToken()).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "VerifiedAccessTrustProviders": {
                return Optional.ofNullable(clazz.cast(this.verifiedAccessTrustProviders()));
            }
            case "NextToken": {
                return Optional.ofNullable(clazz.cast(this.nextToken()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("VerifiedAccessTrustProviderSet", VERIFIED_ACCESS_TRUST_PROVIDERS_FIELD);
        map.put("NextToken", NEXT_TOKEN_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<DescribeVerifiedAccessTrustProvidersResponse, T> g) {
        return obj -> g.apply((DescribeVerifiedAccessTrustProvidersResponse)((Object)((Object)obj)));
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    extends Ec2Response.BuilderImpl
    implements Builder {
        private List<VerifiedAccessTrustProvider> verifiedAccessTrustProviders = DefaultSdkAutoConstructList.getInstance();
        private String nextToken;

        private BuilderImpl() {
        }

        private BuilderImpl(DescribeVerifiedAccessTrustProvidersResponse model) {
            super(model);
            this.verifiedAccessTrustProviders(model.verifiedAccessTrustProviders);
            this.nextToken(model.nextToken);
        }

        public final List<VerifiedAccessTrustProvider.Builder> getVerifiedAccessTrustProviders() {
            List<VerifiedAccessTrustProvider.Builder> result = VerifiedAccessTrustProviderListCopier.copyToBuilder(this.verifiedAccessTrustProviders);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setVerifiedAccessTrustProviders(Collection<VerifiedAccessTrustProvider.BuilderImpl> verifiedAccessTrustProviders) {
            this.verifiedAccessTrustProviders = VerifiedAccessTrustProviderListCopier.copyFromBuilder(verifiedAccessTrustProviders);
        }

        @Override
        public final Builder verifiedAccessTrustProviders(Collection<VerifiedAccessTrustProvider> verifiedAccessTrustProviders) {
            this.verifiedAccessTrustProviders = VerifiedAccessTrustProviderListCopier.copy(verifiedAccessTrustProviders);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder verifiedAccessTrustProviders(VerifiedAccessTrustProvider ... verifiedAccessTrustProviders) {
            this.verifiedAccessTrustProviders(Arrays.asList(verifiedAccessTrustProviders));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder verifiedAccessTrustProviders(Consumer<VerifiedAccessTrustProvider.Builder> ... verifiedAccessTrustProviders) {
            this.verifiedAccessTrustProviders(Stream.of(verifiedAccessTrustProviders).map(c -> (VerifiedAccessTrustProvider)((VerifiedAccessTrustProvider.Builder)VerifiedAccessTrustProvider.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public final String getNextToken() {
            return this.nextToken;
        }

        public final void setNextToken(String nextToken) {
            this.nextToken = nextToken;
        }

        @Override
        public final Builder nextToken(String nextToken) {
            this.nextToken = nextToken;
            return this;
        }

        @Override
        public DescribeVerifiedAccessTrustProvidersResponse build() {
            return new DescribeVerifiedAccessTrustProvidersResponse(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends Ec2Response.Builder,
    SdkPojo,
    CopyableBuilder<Builder, DescribeVerifiedAccessTrustProvidersResponse> {
        public Builder verifiedAccessTrustProviders(Collection<VerifiedAccessTrustProvider> var1);

        public Builder verifiedAccessTrustProviders(VerifiedAccessTrustProvider ... var1);

        public Builder verifiedAccessTrustProviders(Consumer<VerifiedAccessTrustProvider.Builder> ... var1);

        public Builder nextToken(String var1);
    }
}

