/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum DnsRecordIpType {
    IPV4("ipv4"),
    DUALSTACK("dualstack"),
    IPV6("ipv6"),
    SERVICE_DEFINED("service-defined"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, DnsRecordIpType> VALUE_MAP;
    private final String value;

    private DnsRecordIpType(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static DnsRecordIpType fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<DnsRecordIpType> knownValues() {
        EnumSet<DnsRecordIpType> knownValues = EnumSet.allOf(DnsRecordIpType.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(DnsRecordIpType.class, DnsRecordIpType::toString);
    }
}

