/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.util.EnumSet;
import java.util.Map;
import java.util.Set;
import software.amazon.awssdk.utils.internal.EnumUtils;

public enum NetworkInterfacePermissionStateCode {
    PENDING("pending"),
    GRANTED("granted"),
    REVOKING("revoking"),
    REVOKED("revoked"),
    UNKNOWN_TO_SDK_VERSION(null);

    private static final Map<String, NetworkInterfacePermissionStateCode> VALUE_MAP;
    private final String value;

    private NetworkInterfacePermissionStateCode(String value) {
        this.value = value;
    }

    public String toString() {
        return String.valueOf(this.value);
    }

    public static NetworkInterfacePermissionStateCode fromValue(String value) {
        if (value == null) {
            return null;
        }
        return VALUE_MAP.getOrDefault(value, UNKNOWN_TO_SDK_VERSION);
    }

    public static Set<NetworkInterfacePermissionStateCode> knownValues() {
        EnumSet<NetworkInterfacePermissionStateCode> knownValues = EnumSet.allOf(NetworkInterfacePermissionStateCode.class);
        knownValues.remove((Object)UNKNOWN_TO_SDK_VERSION);
        return knownValues;
    }

    static {
        VALUE_MAP = EnumUtils.uniqueIndex(NetworkInterfacePermissionStateCode.class, NetworkInterfacePermissionStateCode::toString);
    }
}

