/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.model;

import java.io.Serializable;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import software.amazon.awssdk.core.SdkField;
import software.amazon.awssdk.core.SdkPojo;
import software.amazon.awssdk.core.protocol.MarshallLocation;
import software.amazon.awssdk.core.protocol.MarshallingType;
import software.amazon.awssdk.core.traits.ListTrait;
import software.amazon.awssdk.core.traits.LocationTrait;
import software.amazon.awssdk.core.traits.Trait;
import software.amazon.awssdk.core.util.DefaultSdkAutoConstructList;
import software.amazon.awssdk.core.util.SdkAutoConstructList;
import software.amazon.awssdk.services.ec2.model.Tag;
import software.amazon.awssdk.services.ec2.model.TagListCopier;
import software.amazon.awssdk.utils.ToString;
import software.amazon.awssdk.utils.builder.CopyableBuilder;
import software.amazon.awssdk.utils.builder.ToCopyableBuilder;

public final class TrafficMirrorSession
implements SdkPojo,
Serializable,
ToCopyableBuilder<Builder, TrafficMirrorSession> {
    private static final SdkField<String> TRAFFIC_MIRROR_SESSION_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficMirrorSessionId").getter(TrafficMirrorSession.getter(TrafficMirrorSession::trafficMirrorSessionId)).setter(TrafficMirrorSession.setter(Builder::trafficMirrorSessionId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorSessionId").unmarshallLocationName("trafficMirrorSessionId").build()}).build();
    private static final SdkField<String> TRAFFIC_MIRROR_TARGET_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficMirrorTargetId").getter(TrafficMirrorSession.getter(TrafficMirrorSession::trafficMirrorTargetId)).setter(TrafficMirrorSession.setter(Builder::trafficMirrorTargetId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorTargetId").unmarshallLocationName("trafficMirrorTargetId").build()}).build();
    private static final SdkField<String> TRAFFIC_MIRROR_FILTER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("TrafficMirrorFilterId").getter(TrafficMirrorSession.getter(TrafficMirrorSession::trafficMirrorFilterId)).setter(TrafficMirrorSession.setter(Builder::trafficMirrorFilterId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TrafficMirrorFilterId").unmarshallLocationName("trafficMirrorFilterId").build()}).build();
    private static final SdkField<String> NETWORK_INTERFACE_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("NetworkInterfaceId").getter(TrafficMirrorSession.getter(TrafficMirrorSession::networkInterfaceId)).setter(TrafficMirrorSession.setter(Builder::networkInterfaceId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("NetworkInterfaceId").unmarshallLocationName("networkInterfaceId").build()}).build();
    private static final SdkField<String> OWNER_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("OwnerId").getter(TrafficMirrorSession.getter(TrafficMirrorSession::ownerId)).setter(TrafficMirrorSession.setter(Builder::ownerId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("OwnerId").unmarshallLocationName("ownerId").build()}).build();
    private static final SdkField<Integer> PACKET_LENGTH_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("PacketLength").getter(TrafficMirrorSession.getter(TrafficMirrorSession::packetLength)).setter(TrafficMirrorSession.setter(Builder::packetLength)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("PacketLength").unmarshallLocationName("packetLength").build()}).build();
    private static final SdkField<Integer> SESSION_NUMBER_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("SessionNumber").getter(TrafficMirrorSession.getter(TrafficMirrorSession::sessionNumber)).setter(TrafficMirrorSession.setter(Builder::sessionNumber)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("SessionNumber").unmarshallLocationName("sessionNumber").build()}).build();
    private static final SdkField<Integer> VIRTUAL_NETWORK_ID_FIELD = SdkField.builder((MarshallingType)MarshallingType.INTEGER).memberName("VirtualNetworkId").getter(TrafficMirrorSession.getter(TrafficMirrorSession::virtualNetworkId)).setter(TrafficMirrorSession.setter(Builder::virtualNetworkId)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("VirtualNetworkId").unmarshallLocationName("virtualNetworkId").build()}).build();
    private static final SdkField<String> DESCRIPTION_FIELD = SdkField.builder((MarshallingType)MarshallingType.STRING).memberName("Description").getter(TrafficMirrorSession.getter(TrafficMirrorSession::description)).setter(TrafficMirrorSession.setter(Builder::description)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Description").unmarshallLocationName("description").build()}).build();
    private static final SdkField<List<Tag>> TAGS_FIELD = SdkField.builder((MarshallingType)MarshallingType.LIST).memberName("Tags").getter(TrafficMirrorSession.getter(TrafficMirrorSession::tags)).setter(TrafficMirrorSession.setter(Builder::tags)).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("TagSet").unmarshallLocationName("tagSet").build(), ListTrait.builder().memberLocationName("item").memberFieldInfo(SdkField.builder((MarshallingType)MarshallingType.SDK_POJO).constructor(Tag::builder).traits(new Trait[]{LocationTrait.builder().location(MarshallLocation.PAYLOAD).locationName("Item").unmarshallLocationName("item").build()}).build()).build()}).build();
    private static final List<SdkField<?>> SDK_FIELDS = Collections.unmodifiableList(Arrays.asList(TRAFFIC_MIRROR_SESSION_ID_FIELD, TRAFFIC_MIRROR_TARGET_ID_FIELD, TRAFFIC_MIRROR_FILTER_ID_FIELD, NETWORK_INTERFACE_ID_FIELD, OWNER_ID_FIELD, PACKET_LENGTH_FIELD, SESSION_NUMBER_FIELD, VIRTUAL_NETWORK_ID_FIELD, DESCRIPTION_FIELD, TAGS_FIELD));
    private static final Map<String, SdkField<?>> SDK_NAME_TO_FIELD = TrafficMirrorSession.memberNameToFieldInitializer();
    private static final long serialVersionUID = 1L;
    private final String trafficMirrorSessionId;
    private final String trafficMirrorTargetId;
    private final String trafficMirrorFilterId;
    private final String networkInterfaceId;
    private final String ownerId;
    private final Integer packetLength;
    private final Integer sessionNumber;
    private final Integer virtualNetworkId;
    private final String description;
    private final List<Tag> tags;

    private TrafficMirrorSession(BuilderImpl builder) {
        this.trafficMirrorSessionId = builder.trafficMirrorSessionId;
        this.trafficMirrorTargetId = builder.trafficMirrorTargetId;
        this.trafficMirrorFilterId = builder.trafficMirrorFilterId;
        this.networkInterfaceId = builder.networkInterfaceId;
        this.ownerId = builder.ownerId;
        this.packetLength = builder.packetLength;
        this.sessionNumber = builder.sessionNumber;
        this.virtualNetworkId = builder.virtualNetworkId;
        this.description = builder.description;
        this.tags = builder.tags;
    }

    public final String trafficMirrorSessionId() {
        return this.trafficMirrorSessionId;
    }

    public final String trafficMirrorTargetId() {
        return this.trafficMirrorTargetId;
    }

    public final String trafficMirrorFilterId() {
        return this.trafficMirrorFilterId;
    }

    public final String networkInterfaceId() {
        return this.networkInterfaceId;
    }

    public final String ownerId() {
        return this.ownerId;
    }

    public final Integer packetLength() {
        return this.packetLength;
    }

    public final Integer sessionNumber() {
        return this.sessionNumber;
    }

    public final Integer virtualNetworkId() {
        return this.virtualNetworkId;
    }

    public final String description() {
        return this.description;
    }

    public final boolean hasTags() {
        return this.tags != null && !(this.tags instanceof SdkAutoConstructList);
    }

    public final List<Tag> tags() {
        return this.tags;
    }

    public Builder toBuilder() {
        return new BuilderImpl(this);
    }

    public static Builder builder() {
        return new BuilderImpl();
    }

    public static Class<? extends Builder> serializableBuilderClass() {
        return BuilderImpl.class;
    }

    public final int hashCode() {
        int hashCode = 1;
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficMirrorSessionId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficMirrorTargetId());
        hashCode = 31 * hashCode + Objects.hashCode(this.trafficMirrorFilterId());
        hashCode = 31 * hashCode + Objects.hashCode(this.networkInterfaceId());
        hashCode = 31 * hashCode + Objects.hashCode(this.ownerId());
        hashCode = 31 * hashCode + Objects.hashCode(this.packetLength());
        hashCode = 31 * hashCode + Objects.hashCode(this.sessionNumber());
        hashCode = 31 * hashCode + Objects.hashCode(this.virtualNetworkId());
        hashCode = 31 * hashCode + Objects.hashCode(this.description());
        hashCode = 31 * hashCode + Objects.hashCode(this.hasTags() ? this.tags() : null);
        return hashCode;
    }

    public final boolean equals(Object obj) {
        return this.equalsBySdkFields(obj);
    }

    public final boolean equalsBySdkFields(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (!(obj instanceof TrafficMirrorSession)) {
            return false;
        }
        TrafficMirrorSession other = (TrafficMirrorSession)obj;
        return Objects.equals(this.trafficMirrorSessionId(), other.trafficMirrorSessionId()) && Objects.equals(this.trafficMirrorTargetId(), other.trafficMirrorTargetId()) && Objects.equals(this.trafficMirrorFilterId(), other.trafficMirrorFilterId()) && Objects.equals(this.networkInterfaceId(), other.networkInterfaceId()) && Objects.equals(this.ownerId(), other.ownerId()) && Objects.equals(this.packetLength(), other.packetLength()) && Objects.equals(this.sessionNumber(), other.sessionNumber()) && Objects.equals(this.virtualNetworkId(), other.virtualNetworkId()) && Objects.equals(this.description(), other.description()) && this.hasTags() == other.hasTags() && Objects.equals(this.tags(), other.tags());
    }

    public final String toString() {
        return ToString.builder((String)"TrafficMirrorSession").add("TrafficMirrorSessionId", (Object)this.trafficMirrorSessionId()).add("TrafficMirrorTargetId", (Object)this.trafficMirrorTargetId()).add("TrafficMirrorFilterId", (Object)this.trafficMirrorFilterId()).add("NetworkInterfaceId", (Object)this.networkInterfaceId()).add("OwnerId", (Object)this.ownerId()).add("PacketLength", (Object)this.packetLength()).add("SessionNumber", (Object)this.sessionNumber()).add("VirtualNetworkId", (Object)this.virtualNetworkId()).add("Description", (Object)this.description()).add("Tags", this.hasTags() ? this.tags() : null).build();
    }

    public final <T> Optional<T> getValueForField(String fieldName, Class<T> clazz) {
        switch (fieldName) {
            case "TrafficMirrorSessionId": {
                return Optional.ofNullable(clazz.cast(this.trafficMirrorSessionId()));
            }
            case "TrafficMirrorTargetId": {
                return Optional.ofNullable(clazz.cast(this.trafficMirrorTargetId()));
            }
            case "TrafficMirrorFilterId": {
                return Optional.ofNullable(clazz.cast(this.trafficMirrorFilterId()));
            }
            case "NetworkInterfaceId": {
                return Optional.ofNullable(clazz.cast(this.networkInterfaceId()));
            }
            case "OwnerId": {
                return Optional.ofNullable(clazz.cast(this.ownerId()));
            }
            case "PacketLength": {
                return Optional.ofNullable(clazz.cast(this.packetLength()));
            }
            case "SessionNumber": {
                return Optional.ofNullable(clazz.cast(this.sessionNumber()));
            }
            case "VirtualNetworkId": {
                return Optional.ofNullable(clazz.cast(this.virtualNetworkId()));
            }
            case "Description": {
                return Optional.ofNullable(clazz.cast(this.description()));
            }
            case "Tags": {
                return Optional.ofNullable(clazz.cast(this.tags()));
            }
        }
        return Optional.empty();
    }

    public final List<SdkField<?>> sdkFields() {
        return SDK_FIELDS;
    }

    public final Map<String, SdkField<?>> sdkFieldNameToField() {
        return SDK_NAME_TO_FIELD;
    }

    private static Map<String, SdkField<?>> memberNameToFieldInitializer() {
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("TrafficMirrorSessionId", TRAFFIC_MIRROR_SESSION_ID_FIELD);
        map.put("TrafficMirrorTargetId", TRAFFIC_MIRROR_TARGET_ID_FIELD);
        map.put("TrafficMirrorFilterId", TRAFFIC_MIRROR_FILTER_ID_FIELD);
        map.put("NetworkInterfaceId", NETWORK_INTERFACE_ID_FIELD);
        map.put("OwnerId", OWNER_ID_FIELD);
        map.put("PacketLength", PACKET_LENGTH_FIELD);
        map.put("SessionNumber", SESSION_NUMBER_FIELD);
        map.put("VirtualNetworkId", VIRTUAL_NETWORK_ID_FIELD);
        map.put("Description", DESCRIPTION_FIELD);
        map.put("TagSet", TAGS_FIELD);
        return Collections.unmodifiableMap(map);
    }

    private static <T> Function<Object, T> getter(Function<TrafficMirrorSession, T> g) {
        return obj -> g.apply((TrafficMirrorSession)obj);
    }

    private static <T> BiConsumer<Object, T> setter(BiConsumer<Builder, T> s) {
        return (obj, val) -> s.accept((Builder)obj, val);
    }

    static final class BuilderImpl
    implements Builder {
        private String trafficMirrorSessionId;
        private String trafficMirrorTargetId;
        private String trafficMirrorFilterId;
        private String networkInterfaceId;
        private String ownerId;
        private Integer packetLength;
        private Integer sessionNumber;
        private Integer virtualNetworkId;
        private String description;
        private List<Tag> tags = DefaultSdkAutoConstructList.getInstance();

        private BuilderImpl() {
        }

        private BuilderImpl(TrafficMirrorSession model) {
            this.trafficMirrorSessionId(model.trafficMirrorSessionId);
            this.trafficMirrorTargetId(model.trafficMirrorTargetId);
            this.trafficMirrorFilterId(model.trafficMirrorFilterId);
            this.networkInterfaceId(model.networkInterfaceId);
            this.ownerId(model.ownerId);
            this.packetLength(model.packetLength);
            this.sessionNumber(model.sessionNumber);
            this.virtualNetworkId(model.virtualNetworkId);
            this.description(model.description);
            this.tags(model.tags);
        }

        public final String getTrafficMirrorSessionId() {
            return this.trafficMirrorSessionId;
        }

        public final void setTrafficMirrorSessionId(String trafficMirrorSessionId) {
            this.trafficMirrorSessionId = trafficMirrorSessionId;
        }

        @Override
        public final Builder trafficMirrorSessionId(String trafficMirrorSessionId) {
            this.trafficMirrorSessionId = trafficMirrorSessionId;
            return this;
        }

        public final String getTrafficMirrorTargetId() {
            return this.trafficMirrorTargetId;
        }

        public final void setTrafficMirrorTargetId(String trafficMirrorTargetId) {
            this.trafficMirrorTargetId = trafficMirrorTargetId;
        }

        @Override
        public final Builder trafficMirrorTargetId(String trafficMirrorTargetId) {
            this.trafficMirrorTargetId = trafficMirrorTargetId;
            return this;
        }

        public final String getTrafficMirrorFilterId() {
            return this.trafficMirrorFilterId;
        }

        public final void setTrafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
        }

        @Override
        public final Builder trafficMirrorFilterId(String trafficMirrorFilterId) {
            this.trafficMirrorFilterId = trafficMirrorFilterId;
            return this;
        }

        public final String getNetworkInterfaceId() {
            return this.networkInterfaceId;
        }

        public final void setNetworkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
        }

        @Override
        public final Builder networkInterfaceId(String networkInterfaceId) {
            this.networkInterfaceId = networkInterfaceId;
            return this;
        }

        public final String getOwnerId() {
            return this.ownerId;
        }

        public final void setOwnerId(String ownerId) {
            this.ownerId = ownerId;
        }

        @Override
        public final Builder ownerId(String ownerId) {
            this.ownerId = ownerId;
            return this;
        }

        public final Integer getPacketLength() {
            return this.packetLength;
        }

        public final void setPacketLength(Integer packetLength) {
            this.packetLength = packetLength;
        }

        @Override
        public final Builder packetLength(Integer packetLength) {
            this.packetLength = packetLength;
            return this;
        }

        public final Integer getSessionNumber() {
            return this.sessionNumber;
        }

        public final void setSessionNumber(Integer sessionNumber) {
            this.sessionNumber = sessionNumber;
        }

        @Override
        public final Builder sessionNumber(Integer sessionNumber) {
            this.sessionNumber = sessionNumber;
            return this;
        }

        public final Integer getVirtualNetworkId() {
            return this.virtualNetworkId;
        }

        public final void setVirtualNetworkId(Integer virtualNetworkId) {
            this.virtualNetworkId = virtualNetworkId;
        }

        @Override
        public final Builder virtualNetworkId(Integer virtualNetworkId) {
            this.virtualNetworkId = virtualNetworkId;
            return this;
        }

        public final String getDescription() {
            return this.description;
        }

        public final void setDescription(String description) {
            this.description = description;
        }

        @Override
        public final Builder description(String description) {
            this.description = description;
            return this;
        }

        public final List<Tag.Builder> getTags() {
            List<Tag.Builder> result = TagListCopier.copyToBuilder(this.tags);
            if (result instanceof SdkAutoConstructList) {
                return null;
            }
            return result;
        }

        public final void setTags(Collection<Tag.BuilderImpl> tags) {
            this.tags = TagListCopier.copyFromBuilder(tags);
        }

        @Override
        public final Builder tags(Collection<Tag> tags) {
            this.tags = TagListCopier.copy(tags);
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Tag ... tags) {
            this.tags(Arrays.asList(tags));
            return this;
        }

        @Override
        @SafeVarargs
        public final Builder tags(Consumer<Tag.Builder> ... tags) {
            this.tags(Stream.of(tags).map(c -> (Tag)((Tag.Builder)Tag.builder().applyMutation((Consumer)c)).build()).collect(Collectors.toList()));
            return this;
        }

        public TrafficMirrorSession build() {
            return new TrafficMirrorSession(this);
        }

        public List<SdkField<?>> sdkFields() {
            return SDK_FIELDS;
        }

        public Map<String, SdkField<?>> sdkFieldNameToField() {
            return SDK_NAME_TO_FIELD;
        }
    }

    public static interface Builder
    extends SdkPojo,
    CopyableBuilder<Builder, TrafficMirrorSession> {
        public Builder trafficMirrorSessionId(String var1);

        public Builder trafficMirrorTargetId(String var1);

        public Builder trafficMirrorFilterId(String var1);

        public Builder networkInterfaceId(String var1);

        public Builder ownerId(String var1);

        public Builder packetLength(Integer var1);

        public Builder sessionNumber(Integer var1);

        public Builder virtualNetworkId(Integer var1);

        public Builder description(String var1);

        public Builder tags(Collection<Tag> var1);

        public Builder tags(Tag ... var1);

        public Builder tags(Consumer<Tag.Builder> ... var1);
    }
}

