/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.paginators;

import java.util.Collections;
import java.util.Iterator;
import java.util.concurrent.CompletableFuture;
import java.util.function.Function;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import software.amazon.awssdk.core.async.SdkPublisher;
import software.amazon.awssdk.core.pagination.async.AsyncPageFetcher;
import software.amazon.awssdk.core.pagination.async.PaginatedItemsPublisher;
import software.amazon.awssdk.core.pagination.async.ResponsesSubscription;
import software.amazon.awssdk.core.util.PaginatorUtils;
import software.amazon.awssdk.services.ec2.Ec2AsyncClient;
import software.amazon.awssdk.services.ec2.internal.UserAgentUtils;
import software.amazon.awssdk.services.ec2.model.CapacityReservationBillingRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationBillingRequestsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCapacityReservationBillingRequestsResponse;

public class DescribeCapacityReservationBillingRequestsPublisher
implements SdkPublisher<DescribeCapacityReservationBillingRequestsResponse> {
    private final Ec2AsyncClient client;
    private final DescribeCapacityReservationBillingRequestsRequest firstRequest;
    private final AsyncPageFetcher nextPageFetcher;
    private boolean isLastPage;

    public DescribeCapacityReservationBillingRequestsPublisher(Ec2AsyncClient client, DescribeCapacityReservationBillingRequestsRequest firstRequest) {
        this(client, firstRequest, false);
    }

    private DescribeCapacityReservationBillingRequestsPublisher(Ec2AsyncClient client, DescribeCapacityReservationBillingRequestsRequest firstRequest, boolean isLastPage) {
        this.client = client;
        this.firstRequest = UserAgentUtils.applyPaginatorUserAgent(firstRequest);
        this.isLastPage = isLastPage;
        this.nextPageFetcher = new DescribeCapacityReservationBillingRequestsResponseFetcher();
    }

    public void subscribe(Subscriber<? super DescribeCapacityReservationBillingRequestsResponse> subscriber) {
        subscriber.onSubscribe((Subscription)((ResponsesSubscription.Builder)((ResponsesSubscription.Builder)ResponsesSubscription.builder().subscriber(subscriber)).nextPageFetcher(this.nextPageFetcher)).build());
    }

    public final SdkPublisher<CapacityReservationBillingRequest> capacityReservationBillingRequests() {
        Function<DescribeCapacityReservationBillingRequestsResponse, Iterator> getIterator = response -> {
            if (response != null && response.capacityReservationBillingRequests() != null) {
                return response.capacityReservationBillingRequests().iterator();
            }
            return Collections.emptyIterator();
        };
        return PaginatedItemsPublisher.builder().nextPageFetcher((AsyncPageFetcher)new DescribeCapacityReservationBillingRequestsResponseFetcher()).iteratorFunction(getIterator).isLastPage(this.isLastPage).build();
    }

    private class DescribeCapacityReservationBillingRequestsResponseFetcher
    implements AsyncPageFetcher<DescribeCapacityReservationBillingRequestsResponse> {
        private DescribeCapacityReservationBillingRequestsResponseFetcher() {
        }

        public boolean hasNextPage(DescribeCapacityReservationBillingRequestsResponse previousPage) {
            return PaginatorUtils.isOutputTokenAvailable((Object)previousPage.nextToken());
        }

        public CompletableFuture<DescribeCapacityReservationBillingRequestsResponse> nextPage(DescribeCapacityReservationBillingRequestsResponse previousPage) {
            if (previousPage == null) {
                return DescribeCapacityReservationBillingRequestsPublisher.this.client.describeCapacityReservationBillingRequests(DescribeCapacityReservationBillingRequestsPublisher.this.firstRequest);
            }
            return DescribeCapacityReservationBillingRequestsPublisher.this.client.describeCapacityReservationBillingRequests((DescribeCapacityReservationBillingRequestsRequest)((Object)DescribeCapacityReservationBillingRequestsPublisher.this.firstRequest.toBuilder().nextToken(previousPage.nextToken()).build()));
        }
    }
}

