/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.services.ec2.waiters;

import java.math.BigDecimal;
import java.time.Duration;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import software.amazon.awssdk.annotations.SdkInternalApi;
import software.amazon.awssdk.annotations.ThreadSafe;
import software.amazon.awssdk.awscore.AwsRequestOverrideConfiguration;
import software.amazon.awssdk.awscore.exception.AwsServiceException;
import software.amazon.awssdk.core.ApiName;
import software.amazon.awssdk.core.internal.waiters.WaiterAttribute;
import software.amazon.awssdk.core.waiters.Waiter;
import software.amazon.awssdk.core.waiters.WaiterAcceptor;
import software.amazon.awssdk.core.waiters.WaiterOverrideConfiguration;
import software.amazon.awssdk.core.waiters.WaiterResponse;
import software.amazon.awssdk.core.waiters.WaiterState;
import software.amazon.awssdk.retries.api.BackoffStrategy;
import software.amazon.awssdk.services.ec2.Ec2Client;
import software.amazon.awssdk.services.ec2.jmespath.internal.JmesPathRuntime;
import software.amazon.awssdk.services.ec2.model.DescribeBundleTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeBundleTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeConversionTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeConversionTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeCustomerGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeExportTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeExportTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeImagesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImagesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeImportSnapshotTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstanceStatusResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInstancesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeInternetGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeKeyPairsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeKeyPairsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNatGatewaysResponse;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeNetworkInterfacesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSecurityGroupsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSnapshotsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSpotInstanceRequestsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeStoreImageTasksRequest;
import software.amazon.awssdk.services.ec2.model.DescribeStoreImageTasksResponse;
import software.amazon.awssdk.services.ec2.model.DescribeSubnetsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeSubnetsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVolumesResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcPeeringConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpcsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpcsResponse;
import software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsRequest;
import software.amazon.awssdk.services.ec2.model.DescribeVpnConnectionsResponse;
import software.amazon.awssdk.services.ec2.model.Ec2Request;
import software.amazon.awssdk.services.ec2.model.GetPasswordDataRequest;
import software.amazon.awssdk.services.ec2.model.GetPasswordDataResponse;
import software.amazon.awssdk.services.ec2.waiters.Ec2Waiter;
import software.amazon.awssdk.services.ec2.waiters.internal.WaitersRuntime;
import software.amazon.awssdk.utils.AttributeMap;
import software.amazon.awssdk.utils.SdkAutoCloseable;

@SdkInternalApi
@ThreadSafe
final class DefaultEc2Waiter
implements Ec2Waiter {
    private static final WaiterAttribute<SdkAutoCloseable> CLIENT_ATTRIBUTE = new WaiterAttribute(SdkAutoCloseable.class);
    private final Ec2Client client;
    private final AttributeMap managedResources;
    private final Waiter<DescribeInstancesResponse> instanceExistsWaiter;
    private final Waiter<DescribeBundleTasksResponse> bundleTaskCompleteWaiter;
    private final Waiter<DescribeConversionTasksResponse> conversionTaskCancelledWaiter;
    private final Waiter<DescribeConversionTasksResponse> conversionTaskCompletedWaiter;
    private final Waiter<DescribeConversionTasksResponse> conversionTaskDeletedWaiter;
    private final Waiter<DescribeCustomerGatewaysResponse> customerGatewayAvailableWaiter;
    private final Waiter<DescribeExportTasksResponse> exportTaskCancelledWaiter;
    private final Waiter<DescribeExportTasksResponse> exportTaskCompletedWaiter;
    private final Waiter<DescribeImagesResponse> imageExistsWaiter;
    private final Waiter<DescribeImagesResponse> imageAvailableWaiter;
    private final Waiter<DescribeInstancesResponse> instanceRunningWaiter;
    private final Waiter<DescribeInstanceStatusResponse> instanceStatusOkWaiter;
    private final Waiter<DescribeInstancesResponse> instanceStoppedWaiter;
    private final Waiter<DescribeInstancesResponse> instanceTerminatedWaiter;
    private final Waiter<DescribeInternetGatewaysResponse> internetGatewayExistsWaiter;
    private final Waiter<DescribeKeyPairsResponse> keyPairExistsWaiter;
    private final Waiter<DescribeNatGatewaysResponse> natGatewayAvailableWaiter;
    private final Waiter<DescribeNatGatewaysResponse> natGatewayDeletedWaiter;
    private final Waiter<DescribeNetworkInterfacesResponse> networkInterfaceAvailableWaiter;
    private final Waiter<GetPasswordDataResponse> passwordDataAvailableWaiter;
    private final Waiter<DescribeSnapshotsResponse> snapshotCompletedWaiter;
    private final Waiter<DescribeImportSnapshotTasksResponse> snapshotImportedWaiter;
    private final Waiter<DescribeSecurityGroupsResponse> securityGroupExistsWaiter;
    private final Waiter<DescribeSpotInstanceRequestsResponse> spotInstanceRequestFulfilledWaiter;
    private final Waiter<DescribeStoreImageTasksResponse> storeImageTaskCompleteWaiter;
    private final Waiter<DescribeSubnetsResponse> subnetAvailableWaiter;
    private final Waiter<DescribeInstanceStatusResponse> systemStatusOkWaiter;
    private final Waiter<DescribeVolumesResponse> volumeAvailableWaiter;
    private final Waiter<DescribeVolumesResponse> volumeDeletedWaiter;
    private final Waiter<DescribeVolumesResponse> volumeInUseWaiter;
    private final Waiter<DescribeVpcsResponse> vpcAvailableWaiter;
    private final Waiter<DescribeVpcsResponse> vpcExistsWaiter;
    private final Waiter<DescribeVpnConnectionsResponse> vpnConnectionAvailableWaiter;
    private final Waiter<DescribeVpnConnectionsResponse> vpnConnectionDeletedWaiter;
    private final Waiter<DescribeVpcPeeringConnectionsResponse> vpcPeeringConnectionExistsWaiter;
    private final Waiter<DescribeVpcPeeringConnectionsResponse> vpcPeeringConnectionDeletedWaiter;

    private DefaultEc2Waiter(DefaultBuilder builder) {
        AttributeMap.Builder attributeMapBuilder = AttributeMap.builder();
        if (builder.client == null) {
            this.client = (Ec2Client)Ec2Client.builder().build();
            attributeMapBuilder.put(CLIENT_ATTRIBUTE, (Object)this.client);
        } else {
            this.client = builder.client;
        }
        this.managedResources = attributeMapBuilder.build();
        this.instanceExistsWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeInstancesResponse.class).acceptors(DefaultEc2Waiter.instanceExistsWaiterAcceptors())).overrideConfiguration(DefaultEc2Waiter.instanceExistsWaiterConfig(builder.overrideConfiguration))).build();
        this.bundleTaskCompleteWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeBundleTasksResponse.class).acceptors(DefaultEc2Waiter.bundleTaskCompleteWaiterAcceptors())).overrideConfiguration(DefaultEc2Waiter.bundleTaskCompleteWaiterConfig(builder.overrideConfiguration))).build();
        this.conversionTaskCancelledWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeConversionTasksResponse.class).acceptors(DefaultEc2Waiter.conversionTaskCancelledWaiterAcceptors())).overrideConfiguration(DefaultEc2Waiter.conversionTaskCancelledWaiterConfig(builder.overrideConfiguration))).build();
        this.conversionTaskCompletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeConversionTasksResponse.class).acceptors(DefaultEc2Waiter.conversionTaskCompletedWaiterAcceptors())).overrideConfiguration(DefaultEc2Waiter.conversionTaskCompletedWaiterConfig(builder.overrideConfiguration))).build();
        this.conversionTaskDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeConversionTasksResponse.class).acceptors(DefaultEc2Waiter.conversionTaskDeletedWaiterAcceptors())).overrideConfiguration(DefaultEc2Waiter.conversionTaskDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.customerGatewayAvailableWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeCustomerGatewaysResponse.class).acceptors(DefaultEc2Waiter.customerGatewayAvailableWaiterAcceptors())).overrideConfiguration(DefaultEc2Waiter.customerGatewayAvailableWaiterConfig(builder.overrideConfiguration))).build();
        this.exportTaskCancelledWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeExportTasksResponse.class).acceptors(DefaultEc2Waiter.exportTaskCancelledWaiterAcceptors())).overrideConfiguration(DefaultEc2Waiter.exportTaskCancelledWaiterConfig(builder.overrideConfiguration))).build();
        this.exportTaskCompletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeExportTasksResponse.class).acceptors(DefaultEc2Waiter.exportTaskCompletedWaiterAcceptors())).overrideConfiguration(DefaultEc2Waiter.exportTaskCompletedWaiterConfig(builder.overrideConfiguration))).build();
        this.imageExistsWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeImagesResponse.class).acceptors(DefaultEc2Waiter.imageExistsWaiterAcceptors())).overrideConfiguration(DefaultEc2Waiter.imageExistsWaiterConfig(builder.overrideConfiguration))).build();
        this.imageAvailableWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeImagesResponse.class).acceptors(DefaultEc2Waiter.imageAvailableWaiterAcceptors())).overrideConfiguration(DefaultEc2Waiter.imageAvailableWaiterConfig(builder.overrideConfiguration))).build();
        this.instanceRunningWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeInstancesResponse.class).acceptors(DefaultEc2Waiter.instanceRunningWaiterAcceptors())).overrideConfiguration(DefaultEc2Waiter.instanceRunningWaiterConfig(builder.overrideConfiguration))).build();
        this.instanceStatusOkWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeInstanceStatusResponse.class).acceptors(DefaultEc2Waiter.instanceStatusOkWaiterAcceptors())).overrideConfiguration(DefaultEc2Waiter.instanceStatusOkWaiterConfig(builder.overrideConfiguration))).build();
        this.instanceStoppedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeInstancesResponse.class).acceptors(DefaultEc2Waiter.instanceStoppedWaiterAcceptors())).overrideConfiguration(DefaultEc2Waiter.instanceStoppedWaiterConfig(builder.overrideConfiguration))).build();
        this.instanceTerminatedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeInstancesResponse.class).acceptors(DefaultEc2Waiter.instanceTerminatedWaiterAcceptors())).overrideConfiguration(DefaultEc2Waiter.instanceTerminatedWaiterConfig(builder.overrideConfiguration))).build();
        this.internetGatewayExistsWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeInternetGatewaysResponse.class).acceptors(DefaultEc2Waiter.internetGatewayExistsWaiterAcceptors())).overrideConfiguration(DefaultEc2Waiter.internetGatewayExistsWaiterConfig(builder.overrideConfiguration))).build();
        this.keyPairExistsWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeKeyPairsResponse.class).acceptors(DefaultEc2Waiter.keyPairExistsWaiterAcceptors())).overrideConfiguration(DefaultEc2Waiter.keyPairExistsWaiterConfig(builder.overrideConfiguration))).build();
        this.natGatewayAvailableWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeNatGatewaysResponse.class).acceptors(DefaultEc2Waiter.natGatewayAvailableWaiterAcceptors())).overrideConfiguration(DefaultEc2Waiter.natGatewayAvailableWaiterConfig(builder.overrideConfiguration))).build();
        this.natGatewayDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeNatGatewaysResponse.class).acceptors(DefaultEc2Waiter.natGatewayDeletedWaiterAcceptors())).overrideConfiguration(DefaultEc2Waiter.natGatewayDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.networkInterfaceAvailableWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeNetworkInterfacesResponse.class).acceptors(DefaultEc2Waiter.networkInterfaceAvailableWaiterAcceptors())).overrideConfiguration(DefaultEc2Waiter.networkInterfaceAvailableWaiterConfig(builder.overrideConfiguration))).build();
        this.passwordDataAvailableWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(GetPasswordDataResponse.class).acceptors(DefaultEc2Waiter.passwordDataAvailableWaiterAcceptors())).overrideConfiguration(DefaultEc2Waiter.passwordDataAvailableWaiterConfig(builder.overrideConfiguration))).build();
        this.snapshotCompletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeSnapshotsResponse.class).acceptors(DefaultEc2Waiter.snapshotCompletedWaiterAcceptors())).overrideConfiguration(DefaultEc2Waiter.snapshotCompletedWaiterConfig(builder.overrideConfiguration))).build();
        this.snapshotImportedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeImportSnapshotTasksResponse.class).acceptors(DefaultEc2Waiter.snapshotImportedWaiterAcceptors())).overrideConfiguration(DefaultEc2Waiter.snapshotImportedWaiterConfig(builder.overrideConfiguration))).build();
        this.securityGroupExistsWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeSecurityGroupsResponse.class).acceptors(DefaultEc2Waiter.securityGroupExistsWaiterAcceptors())).overrideConfiguration(DefaultEc2Waiter.securityGroupExistsWaiterConfig(builder.overrideConfiguration))).build();
        this.spotInstanceRequestFulfilledWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeSpotInstanceRequestsResponse.class).acceptors(DefaultEc2Waiter.spotInstanceRequestFulfilledWaiterAcceptors())).overrideConfiguration(DefaultEc2Waiter.spotInstanceRequestFulfilledWaiterConfig(builder.overrideConfiguration))).build();
        this.storeImageTaskCompleteWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeStoreImageTasksResponse.class).acceptors(DefaultEc2Waiter.storeImageTaskCompleteWaiterAcceptors())).overrideConfiguration(DefaultEc2Waiter.storeImageTaskCompleteWaiterConfig(builder.overrideConfiguration))).build();
        this.subnetAvailableWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeSubnetsResponse.class).acceptors(DefaultEc2Waiter.subnetAvailableWaiterAcceptors())).overrideConfiguration(DefaultEc2Waiter.subnetAvailableWaiterConfig(builder.overrideConfiguration))).build();
        this.systemStatusOkWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeInstanceStatusResponse.class).acceptors(DefaultEc2Waiter.systemStatusOkWaiterAcceptors())).overrideConfiguration(DefaultEc2Waiter.systemStatusOkWaiterConfig(builder.overrideConfiguration))).build();
        this.volumeAvailableWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeVolumesResponse.class).acceptors(DefaultEc2Waiter.volumeAvailableWaiterAcceptors())).overrideConfiguration(DefaultEc2Waiter.volumeAvailableWaiterConfig(builder.overrideConfiguration))).build();
        this.volumeDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeVolumesResponse.class).acceptors(DefaultEc2Waiter.volumeDeletedWaiterAcceptors())).overrideConfiguration(DefaultEc2Waiter.volumeDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.volumeInUseWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeVolumesResponse.class).acceptors(DefaultEc2Waiter.volumeInUseWaiterAcceptors())).overrideConfiguration(DefaultEc2Waiter.volumeInUseWaiterConfig(builder.overrideConfiguration))).build();
        this.vpcAvailableWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeVpcsResponse.class).acceptors(DefaultEc2Waiter.vpcAvailableWaiterAcceptors())).overrideConfiguration(DefaultEc2Waiter.vpcAvailableWaiterConfig(builder.overrideConfiguration))).build();
        this.vpcExistsWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeVpcsResponse.class).acceptors(DefaultEc2Waiter.vpcExistsWaiterAcceptors())).overrideConfiguration(DefaultEc2Waiter.vpcExistsWaiterConfig(builder.overrideConfiguration))).build();
        this.vpnConnectionAvailableWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeVpnConnectionsResponse.class).acceptors(DefaultEc2Waiter.vpnConnectionAvailableWaiterAcceptors())).overrideConfiguration(DefaultEc2Waiter.vpnConnectionAvailableWaiterConfig(builder.overrideConfiguration))).build();
        this.vpnConnectionDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeVpnConnectionsResponse.class).acceptors(DefaultEc2Waiter.vpnConnectionDeletedWaiterAcceptors())).overrideConfiguration(DefaultEc2Waiter.vpnConnectionDeletedWaiterConfig(builder.overrideConfiguration))).build();
        this.vpcPeeringConnectionExistsWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeVpcPeeringConnectionsResponse.class).acceptors(DefaultEc2Waiter.vpcPeeringConnectionExistsWaiterAcceptors())).overrideConfiguration(DefaultEc2Waiter.vpcPeeringConnectionExistsWaiterConfig(builder.overrideConfiguration))).build();
        this.vpcPeeringConnectionDeletedWaiter = ((Waiter.Builder)((Waiter.Builder)Waiter.builder(DescribeVpcPeeringConnectionsResponse.class).acceptors(DefaultEc2Waiter.vpcPeeringConnectionDeletedWaiterAcceptors())).overrideConfiguration(DefaultEc2Waiter.vpcPeeringConnectionDeletedWaiterConfig(builder.overrideConfiguration))).build();
    }

    private static String errorCode(Throwable error) {
        if (error instanceof AwsServiceException) {
            return ((AwsServiceException)error).awsErrorDetails().errorCode();
        }
        return null;
    }

    @Override
    public WaiterResponse<DescribeBundleTasksResponse> waitUntilBundleTaskComplete(DescribeBundleTasksRequest describeBundleTasksRequest) {
        return this.bundleTaskCompleteWaiter.run(() -> this.client.describeBundleTasks(this.applyWaitersUserAgent(describeBundleTasksRequest)));
    }

    @Override
    public WaiterResponse<DescribeBundleTasksResponse> waitUntilBundleTaskComplete(DescribeBundleTasksRequest describeBundleTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.bundleTaskCompleteWaiter.run(() -> this.client.describeBundleTasks(this.applyWaitersUserAgent(describeBundleTasksRequest)), DefaultEc2Waiter.bundleTaskCompleteWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeConversionTasksResponse> waitUntilConversionTaskCancelled(DescribeConversionTasksRequest describeConversionTasksRequest) {
        return this.conversionTaskCancelledWaiter.run(() -> this.client.describeConversionTasks(this.applyWaitersUserAgent(describeConversionTasksRequest)));
    }

    @Override
    public WaiterResponse<DescribeConversionTasksResponse> waitUntilConversionTaskCancelled(DescribeConversionTasksRequest describeConversionTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.conversionTaskCancelledWaiter.run(() -> this.client.describeConversionTasks(this.applyWaitersUserAgent(describeConversionTasksRequest)), DefaultEc2Waiter.conversionTaskCancelledWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeConversionTasksResponse> waitUntilConversionTaskCompleted(DescribeConversionTasksRequest describeConversionTasksRequest) {
        return this.conversionTaskCompletedWaiter.run(() -> this.client.describeConversionTasks(this.applyWaitersUserAgent(describeConversionTasksRequest)));
    }

    @Override
    public WaiterResponse<DescribeConversionTasksResponse> waitUntilConversionTaskCompleted(DescribeConversionTasksRequest describeConversionTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.conversionTaskCompletedWaiter.run(() -> this.client.describeConversionTasks(this.applyWaitersUserAgent(describeConversionTasksRequest)), DefaultEc2Waiter.conversionTaskCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeConversionTasksResponse> waitUntilConversionTaskDeleted(DescribeConversionTasksRequest describeConversionTasksRequest) {
        return this.conversionTaskDeletedWaiter.run(() -> this.client.describeConversionTasks(this.applyWaitersUserAgent(describeConversionTasksRequest)));
    }

    @Override
    public WaiterResponse<DescribeConversionTasksResponse> waitUntilConversionTaskDeleted(DescribeConversionTasksRequest describeConversionTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.conversionTaskDeletedWaiter.run(() -> this.client.describeConversionTasks(this.applyWaitersUserAgent(describeConversionTasksRequest)), DefaultEc2Waiter.conversionTaskDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeCustomerGatewaysResponse> waitUntilCustomerGatewayAvailable(DescribeCustomerGatewaysRequest describeCustomerGatewaysRequest) {
        return this.customerGatewayAvailableWaiter.run(() -> this.client.describeCustomerGateways(this.applyWaitersUserAgent(describeCustomerGatewaysRequest)));
    }

    @Override
    public WaiterResponse<DescribeCustomerGatewaysResponse> waitUntilCustomerGatewayAvailable(DescribeCustomerGatewaysRequest describeCustomerGatewaysRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.customerGatewayAvailableWaiter.run(() -> this.client.describeCustomerGateways(this.applyWaitersUserAgent(describeCustomerGatewaysRequest)), DefaultEc2Waiter.customerGatewayAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeExportTasksResponse> waitUntilExportTaskCancelled(DescribeExportTasksRequest describeExportTasksRequest) {
        return this.exportTaskCancelledWaiter.run(() -> this.client.describeExportTasks(this.applyWaitersUserAgent(describeExportTasksRequest)));
    }

    @Override
    public WaiterResponse<DescribeExportTasksResponse> waitUntilExportTaskCancelled(DescribeExportTasksRequest describeExportTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.exportTaskCancelledWaiter.run(() -> this.client.describeExportTasks(this.applyWaitersUserAgent(describeExportTasksRequest)), DefaultEc2Waiter.exportTaskCancelledWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeExportTasksResponse> waitUntilExportTaskCompleted(DescribeExportTasksRequest describeExportTasksRequest) {
        return this.exportTaskCompletedWaiter.run(() -> this.client.describeExportTasks(this.applyWaitersUserAgent(describeExportTasksRequest)));
    }

    @Override
    public WaiterResponse<DescribeExportTasksResponse> waitUntilExportTaskCompleted(DescribeExportTasksRequest describeExportTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.exportTaskCompletedWaiter.run(() -> this.client.describeExportTasks(this.applyWaitersUserAgent(describeExportTasksRequest)), DefaultEc2Waiter.exportTaskCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeImagesResponse> waitUntilImageAvailable(DescribeImagesRequest describeImagesRequest) {
        return this.imageAvailableWaiter.run(() -> this.client.describeImages(this.applyWaitersUserAgent(describeImagesRequest)));
    }

    @Override
    public WaiterResponse<DescribeImagesResponse> waitUntilImageAvailable(DescribeImagesRequest describeImagesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.imageAvailableWaiter.run(() -> this.client.describeImages(this.applyWaitersUserAgent(describeImagesRequest)), DefaultEc2Waiter.imageAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeImagesResponse> waitUntilImageExists(DescribeImagesRequest describeImagesRequest) {
        return this.imageExistsWaiter.run(() -> this.client.describeImages(this.applyWaitersUserAgent(describeImagesRequest)));
    }

    @Override
    public WaiterResponse<DescribeImagesResponse> waitUntilImageExists(DescribeImagesRequest describeImagesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.imageExistsWaiter.run(() -> this.client.describeImages(this.applyWaitersUserAgent(describeImagesRequest)), DefaultEc2Waiter.imageExistsWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeInstancesResponse> waitUntilInstanceExists(DescribeInstancesRequest describeInstancesRequest) {
        return this.instanceExistsWaiter.run(() -> this.client.describeInstances(this.applyWaitersUserAgent(describeInstancesRequest)));
    }

    @Override
    public WaiterResponse<DescribeInstancesResponse> waitUntilInstanceExists(DescribeInstancesRequest describeInstancesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.instanceExistsWaiter.run(() -> this.client.describeInstances(this.applyWaitersUserAgent(describeInstancesRequest)), DefaultEc2Waiter.instanceExistsWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeInstancesResponse> waitUntilInstanceRunning(DescribeInstancesRequest describeInstancesRequest) {
        return this.instanceRunningWaiter.run(() -> this.client.describeInstances(this.applyWaitersUserAgent(describeInstancesRequest)));
    }

    @Override
    public WaiterResponse<DescribeInstancesResponse> waitUntilInstanceRunning(DescribeInstancesRequest describeInstancesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.instanceRunningWaiter.run(() -> this.client.describeInstances(this.applyWaitersUserAgent(describeInstancesRequest)), DefaultEc2Waiter.instanceRunningWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeInstanceStatusResponse> waitUntilInstanceStatusOk(DescribeInstanceStatusRequest describeInstanceStatusRequest) {
        return this.instanceStatusOkWaiter.run(() -> this.client.describeInstanceStatus(this.applyWaitersUserAgent(describeInstanceStatusRequest)));
    }

    @Override
    public WaiterResponse<DescribeInstanceStatusResponse> waitUntilInstanceStatusOk(DescribeInstanceStatusRequest describeInstanceStatusRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.instanceStatusOkWaiter.run(() -> this.client.describeInstanceStatus(this.applyWaitersUserAgent(describeInstanceStatusRequest)), DefaultEc2Waiter.instanceStatusOkWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeInstancesResponse> waitUntilInstanceStopped(DescribeInstancesRequest describeInstancesRequest) {
        return this.instanceStoppedWaiter.run(() -> this.client.describeInstances(this.applyWaitersUserAgent(describeInstancesRequest)));
    }

    @Override
    public WaiterResponse<DescribeInstancesResponse> waitUntilInstanceStopped(DescribeInstancesRequest describeInstancesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.instanceStoppedWaiter.run(() -> this.client.describeInstances(this.applyWaitersUserAgent(describeInstancesRequest)), DefaultEc2Waiter.instanceStoppedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeInstancesResponse> waitUntilInstanceTerminated(DescribeInstancesRequest describeInstancesRequest) {
        return this.instanceTerminatedWaiter.run(() -> this.client.describeInstances(this.applyWaitersUserAgent(describeInstancesRequest)));
    }

    @Override
    public WaiterResponse<DescribeInstancesResponse> waitUntilInstanceTerminated(DescribeInstancesRequest describeInstancesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.instanceTerminatedWaiter.run(() -> this.client.describeInstances(this.applyWaitersUserAgent(describeInstancesRequest)), DefaultEc2Waiter.instanceTerminatedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeInternetGatewaysResponse> waitUntilInternetGatewayExists(DescribeInternetGatewaysRequest describeInternetGatewaysRequest) {
        return this.internetGatewayExistsWaiter.run(() -> this.client.describeInternetGateways(this.applyWaitersUserAgent(describeInternetGatewaysRequest)));
    }

    @Override
    public WaiterResponse<DescribeInternetGatewaysResponse> waitUntilInternetGatewayExists(DescribeInternetGatewaysRequest describeInternetGatewaysRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.internetGatewayExistsWaiter.run(() -> this.client.describeInternetGateways(this.applyWaitersUserAgent(describeInternetGatewaysRequest)), DefaultEc2Waiter.internetGatewayExistsWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeKeyPairsResponse> waitUntilKeyPairExists(DescribeKeyPairsRequest describeKeyPairsRequest) {
        return this.keyPairExistsWaiter.run(() -> this.client.describeKeyPairs(this.applyWaitersUserAgent(describeKeyPairsRequest)));
    }

    @Override
    public WaiterResponse<DescribeKeyPairsResponse> waitUntilKeyPairExists(DescribeKeyPairsRequest describeKeyPairsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.keyPairExistsWaiter.run(() -> this.client.describeKeyPairs(this.applyWaitersUserAgent(describeKeyPairsRequest)), DefaultEc2Waiter.keyPairExistsWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeNatGatewaysResponse> waitUntilNatGatewayAvailable(DescribeNatGatewaysRequest describeNatGatewaysRequest) {
        return this.natGatewayAvailableWaiter.run(() -> this.client.describeNatGateways(this.applyWaitersUserAgent(describeNatGatewaysRequest)));
    }

    @Override
    public WaiterResponse<DescribeNatGatewaysResponse> waitUntilNatGatewayAvailable(DescribeNatGatewaysRequest describeNatGatewaysRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.natGatewayAvailableWaiter.run(() -> this.client.describeNatGateways(this.applyWaitersUserAgent(describeNatGatewaysRequest)), DefaultEc2Waiter.natGatewayAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeNatGatewaysResponse> waitUntilNatGatewayDeleted(DescribeNatGatewaysRequest describeNatGatewaysRequest) {
        return this.natGatewayDeletedWaiter.run(() -> this.client.describeNatGateways(this.applyWaitersUserAgent(describeNatGatewaysRequest)));
    }

    @Override
    public WaiterResponse<DescribeNatGatewaysResponse> waitUntilNatGatewayDeleted(DescribeNatGatewaysRequest describeNatGatewaysRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.natGatewayDeletedWaiter.run(() -> this.client.describeNatGateways(this.applyWaitersUserAgent(describeNatGatewaysRequest)), DefaultEc2Waiter.natGatewayDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeNetworkInterfacesResponse> waitUntilNetworkInterfaceAvailable(DescribeNetworkInterfacesRequest describeNetworkInterfacesRequest) {
        return this.networkInterfaceAvailableWaiter.run(() -> this.client.describeNetworkInterfaces(this.applyWaitersUserAgent(describeNetworkInterfacesRequest)));
    }

    @Override
    public WaiterResponse<DescribeNetworkInterfacesResponse> waitUntilNetworkInterfaceAvailable(DescribeNetworkInterfacesRequest describeNetworkInterfacesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.networkInterfaceAvailableWaiter.run(() -> this.client.describeNetworkInterfaces(this.applyWaitersUserAgent(describeNetworkInterfacesRequest)), DefaultEc2Waiter.networkInterfaceAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<GetPasswordDataResponse> waitUntilPasswordDataAvailable(GetPasswordDataRequest getPasswordDataRequest) {
        return this.passwordDataAvailableWaiter.run(() -> this.client.getPasswordData(this.applyWaitersUserAgent(getPasswordDataRequest)));
    }

    @Override
    public WaiterResponse<GetPasswordDataResponse> waitUntilPasswordDataAvailable(GetPasswordDataRequest getPasswordDataRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.passwordDataAvailableWaiter.run(() -> this.client.getPasswordData(this.applyWaitersUserAgent(getPasswordDataRequest)), DefaultEc2Waiter.passwordDataAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeSecurityGroupsResponse> waitUntilSecurityGroupExists(DescribeSecurityGroupsRequest describeSecurityGroupsRequest) {
        return this.securityGroupExistsWaiter.run(() -> this.client.describeSecurityGroups(this.applyWaitersUserAgent(describeSecurityGroupsRequest)));
    }

    @Override
    public WaiterResponse<DescribeSecurityGroupsResponse> waitUntilSecurityGroupExists(DescribeSecurityGroupsRequest describeSecurityGroupsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.securityGroupExistsWaiter.run(() -> this.client.describeSecurityGroups(this.applyWaitersUserAgent(describeSecurityGroupsRequest)), DefaultEc2Waiter.securityGroupExistsWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeSnapshotsResponse> waitUntilSnapshotCompleted(DescribeSnapshotsRequest describeSnapshotsRequest) {
        return this.snapshotCompletedWaiter.run(() -> this.client.describeSnapshots(this.applyWaitersUserAgent(describeSnapshotsRequest)));
    }

    @Override
    public WaiterResponse<DescribeSnapshotsResponse> waitUntilSnapshotCompleted(DescribeSnapshotsRequest describeSnapshotsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.snapshotCompletedWaiter.run(() -> this.client.describeSnapshots(this.applyWaitersUserAgent(describeSnapshotsRequest)), DefaultEc2Waiter.snapshotCompletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeImportSnapshotTasksResponse> waitUntilSnapshotImported(DescribeImportSnapshotTasksRequest describeImportSnapshotTasksRequest) {
        return this.snapshotImportedWaiter.run(() -> this.client.describeImportSnapshotTasks(this.applyWaitersUserAgent(describeImportSnapshotTasksRequest)));
    }

    @Override
    public WaiterResponse<DescribeImportSnapshotTasksResponse> waitUntilSnapshotImported(DescribeImportSnapshotTasksRequest describeImportSnapshotTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.snapshotImportedWaiter.run(() -> this.client.describeImportSnapshotTasks(this.applyWaitersUserAgent(describeImportSnapshotTasksRequest)), DefaultEc2Waiter.snapshotImportedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeSpotInstanceRequestsResponse> waitUntilSpotInstanceRequestFulfilled(DescribeSpotInstanceRequestsRequest describeSpotInstanceRequestsRequest) {
        return this.spotInstanceRequestFulfilledWaiter.run(() -> this.client.describeSpotInstanceRequests(this.applyWaitersUserAgent(describeSpotInstanceRequestsRequest)));
    }

    @Override
    public WaiterResponse<DescribeSpotInstanceRequestsResponse> waitUntilSpotInstanceRequestFulfilled(DescribeSpotInstanceRequestsRequest describeSpotInstanceRequestsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.spotInstanceRequestFulfilledWaiter.run(() -> this.client.describeSpotInstanceRequests(this.applyWaitersUserAgent(describeSpotInstanceRequestsRequest)), DefaultEc2Waiter.spotInstanceRequestFulfilledWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeStoreImageTasksResponse> waitUntilStoreImageTaskComplete(DescribeStoreImageTasksRequest describeStoreImageTasksRequest) {
        return this.storeImageTaskCompleteWaiter.run(() -> this.client.describeStoreImageTasks(this.applyWaitersUserAgent(describeStoreImageTasksRequest)));
    }

    @Override
    public WaiterResponse<DescribeStoreImageTasksResponse> waitUntilStoreImageTaskComplete(DescribeStoreImageTasksRequest describeStoreImageTasksRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.storeImageTaskCompleteWaiter.run(() -> this.client.describeStoreImageTasks(this.applyWaitersUserAgent(describeStoreImageTasksRequest)), DefaultEc2Waiter.storeImageTaskCompleteWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeSubnetsResponse> waitUntilSubnetAvailable(DescribeSubnetsRequest describeSubnetsRequest) {
        return this.subnetAvailableWaiter.run(() -> this.client.describeSubnets(this.applyWaitersUserAgent(describeSubnetsRequest)));
    }

    @Override
    public WaiterResponse<DescribeSubnetsResponse> waitUntilSubnetAvailable(DescribeSubnetsRequest describeSubnetsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.subnetAvailableWaiter.run(() -> this.client.describeSubnets(this.applyWaitersUserAgent(describeSubnetsRequest)), DefaultEc2Waiter.subnetAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeInstanceStatusResponse> waitUntilSystemStatusOk(DescribeInstanceStatusRequest describeInstanceStatusRequest) {
        return this.systemStatusOkWaiter.run(() -> this.client.describeInstanceStatus(this.applyWaitersUserAgent(describeInstanceStatusRequest)));
    }

    @Override
    public WaiterResponse<DescribeInstanceStatusResponse> waitUntilSystemStatusOk(DescribeInstanceStatusRequest describeInstanceStatusRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.systemStatusOkWaiter.run(() -> this.client.describeInstanceStatus(this.applyWaitersUserAgent(describeInstanceStatusRequest)), DefaultEc2Waiter.systemStatusOkWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeVolumesResponse> waitUntilVolumeAvailable(DescribeVolumesRequest describeVolumesRequest) {
        return this.volumeAvailableWaiter.run(() -> this.client.describeVolumes(this.applyWaitersUserAgent(describeVolumesRequest)));
    }

    @Override
    public WaiterResponse<DescribeVolumesResponse> waitUntilVolumeAvailable(DescribeVolumesRequest describeVolumesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.volumeAvailableWaiter.run(() -> this.client.describeVolumes(this.applyWaitersUserAgent(describeVolumesRequest)), DefaultEc2Waiter.volumeAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeVolumesResponse> waitUntilVolumeDeleted(DescribeVolumesRequest describeVolumesRequest) {
        return this.volumeDeletedWaiter.run(() -> this.client.describeVolumes(this.applyWaitersUserAgent(describeVolumesRequest)));
    }

    @Override
    public WaiterResponse<DescribeVolumesResponse> waitUntilVolumeDeleted(DescribeVolumesRequest describeVolumesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.volumeDeletedWaiter.run(() -> this.client.describeVolumes(this.applyWaitersUserAgent(describeVolumesRequest)), DefaultEc2Waiter.volumeDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeVolumesResponse> waitUntilVolumeInUse(DescribeVolumesRequest describeVolumesRequest) {
        return this.volumeInUseWaiter.run(() -> this.client.describeVolumes(this.applyWaitersUserAgent(describeVolumesRequest)));
    }

    @Override
    public WaiterResponse<DescribeVolumesResponse> waitUntilVolumeInUse(DescribeVolumesRequest describeVolumesRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.volumeInUseWaiter.run(() -> this.client.describeVolumes(this.applyWaitersUserAgent(describeVolumesRequest)), DefaultEc2Waiter.volumeInUseWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeVpcsResponse> waitUntilVpcAvailable(DescribeVpcsRequest describeVpcsRequest) {
        return this.vpcAvailableWaiter.run(() -> this.client.describeVpcs(this.applyWaitersUserAgent(describeVpcsRequest)));
    }

    @Override
    public WaiterResponse<DescribeVpcsResponse> waitUntilVpcAvailable(DescribeVpcsRequest describeVpcsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.vpcAvailableWaiter.run(() -> this.client.describeVpcs(this.applyWaitersUserAgent(describeVpcsRequest)), DefaultEc2Waiter.vpcAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeVpcsResponse> waitUntilVpcExists(DescribeVpcsRequest describeVpcsRequest) {
        return this.vpcExistsWaiter.run(() -> this.client.describeVpcs(this.applyWaitersUserAgent(describeVpcsRequest)));
    }

    @Override
    public WaiterResponse<DescribeVpcsResponse> waitUntilVpcExists(DescribeVpcsRequest describeVpcsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.vpcExistsWaiter.run(() -> this.client.describeVpcs(this.applyWaitersUserAgent(describeVpcsRequest)), DefaultEc2Waiter.vpcExistsWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeVpcPeeringConnectionsResponse> waitUntilVpcPeeringConnectionDeleted(DescribeVpcPeeringConnectionsRequest describeVpcPeeringConnectionsRequest) {
        return this.vpcPeeringConnectionDeletedWaiter.run(() -> this.client.describeVpcPeeringConnections(this.applyWaitersUserAgent(describeVpcPeeringConnectionsRequest)));
    }

    @Override
    public WaiterResponse<DescribeVpcPeeringConnectionsResponse> waitUntilVpcPeeringConnectionDeleted(DescribeVpcPeeringConnectionsRequest describeVpcPeeringConnectionsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.vpcPeeringConnectionDeletedWaiter.run(() -> this.client.describeVpcPeeringConnections(this.applyWaitersUserAgent(describeVpcPeeringConnectionsRequest)), DefaultEc2Waiter.vpcPeeringConnectionDeletedWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeVpcPeeringConnectionsResponse> waitUntilVpcPeeringConnectionExists(DescribeVpcPeeringConnectionsRequest describeVpcPeeringConnectionsRequest) {
        return this.vpcPeeringConnectionExistsWaiter.run(() -> this.client.describeVpcPeeringConnections(this.applyWaitersUserAgent(describeVpcPeeringConnectionsRequest)));
    }

    @Override
    public WaiterResponse<DescribeVpcPeeringConnectionsResponse> waitUntilVpcPeeringConnectionExists(DescribeVpcPeeringConnectionsRequest describeVpcPeeringConnectionsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.vpcPeeringConnectionExistsWaiter.run(() -> this.client.describeVpcPeeringConnections(this.applyWaitersUserAgent(describeVpcPeeringConnectionsRequest)), DefaultEc2Waiter.vpcPeeringConnectionExistsWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeVpnConnectionsResponse> waitUntilVpnConnectionAvailable(DescribeVpnConnectionsRequest describeVpnConnectionsRequest) {
        return this.vpnConnectionAvailableWaiter.run(() -> this.client.describeVpnConnections(this.applyWaitersUserAgent(describeVpnConnectionsRequest)));
    }

    @Override
    public WaiterResponse<DescribeVpnConnectionsResponse> waitUntilVpnConnectionAvailable(DescribeVpnConnectionsRequest describeVpnConnectionsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.vpnConnectionAvailableWaiter.run(() -> this.client.describeVpnConnections(this.applyWaitersUserAgent(describeVpnConnectionsRequest)), DefaultEc2Waiter.vpnConnectionAvailableWaiterConfig(overrideConfig));
    }

    @Override
    public WaiterResponse<DescribeVpnConnectionsResponse> waitUntilVpnConnectionDeleted(DescribeVpnConnectionsRequest describeVpnConnectionsRequest) {
        return this.vpnConnectionDeletedWaiter.run(() -> this.client.describeVpnConnections(this.applyWaitersUserAgent(describeVpnConnectionsRequest)));
    }

    @Override
    public WaiterResponse<DescribeVpnConnectionsResponse> waitUntilVpnConnectionDeleted(DescribeVpnConnectionsRequest describeVpnConnectionsRequest, WaiterOverrideConfiguration overrideConfig) {
        return this.vpnConnectionDeletedWaiter.run(() -> this.client.describeVpnConnections(this.applyWaitersUserAgent(describeVpnConnectionsRequest)), DefaultEc2Waiter.vpnConnectionDeletedWaiterConfig(overrideConfig));
    }

    private static List<WaiterAcceptor<? super DescribeInstancesResponse>> instanceExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeInstancesResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeInstancesResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Reservations").flatten().length().compare(">", input.constant(new BigDecimal("0"))).value(), true);
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultEc2Waiter.errorCode(error), "InvalidInstanceID.NotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeBundleTasksResponse>> bundleTaskCompleteWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeBundleTasksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeBundleTasksResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("BundleTasks").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "complete"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("BundleTasks").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "failed"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (BundleTasks[].State=failed) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeConversionTasksResponse>> conversionTaskCancelledWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeConversionTasksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeConversionTasksResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ConversionTasks").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "cancelled"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeConversionTasksResponse>> conversionTaskCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeConversionTasksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeConversionTasksResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ConversionTasks").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "completed"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ConversionTasks").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "cancelled"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ConversionTasks[].State=cancelled) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ConversionTasks").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "cancelling"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ConversionTasks[].State=cancelling) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeConversionTasksResponse>> conversionTaskDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeConversionTasksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeConversionTasksResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ConversionTasks").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "deleted"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeCustomerGatewaysResponse>> customerGatewayAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeCustomerGatewaysResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeCustomerGatewaysResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("CustomerGateways").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("CustomerGateways").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleted"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (CustomerGateways[].State=deleted) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("CustomerGateways").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleting"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (CustomerGateways[].State=deleting) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeExportTasksResponse>> exportTaskCancelledWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeExportTasksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeExportTasksResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ExportTasks").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "cancelled"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeExportTasksResponse>> exportTaskCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeExportTasksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeExportTasksResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ExportTasks").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "completed"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeImagesResponse>> imageExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeImagesResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeImagesResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("Images").flatten().length().compare(">", input.constant(new BigDecimal("0"))).value(), true);
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultEc2Waiter.errorCode(error), "InvalidAMIID.NotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeImagesResponse>> imageAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeImagesResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeImagesResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Images").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Images").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "failed"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Images[].State=failed) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeInstancesResponse>> instanceRunningWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeInstancesResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeInstancesResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Reservations").flatten().field("Instances").flatten().field("State").field("Name").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "running"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Reservations").flatten().field("Instances").flatten().field("State").field("Name").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "shutting-down"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Reservations[].Instances[].State.Name=shutting-down) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Reservations").flatten().field("Instances").flatten().field("State").field("Name").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "terminated"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Reservations[].Instances[].State.Name=terminated) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Reservations").flatten().field("Instances").flatten().field("State").field("Name").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "stopping"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Reservations[].Instances[].State.Name=stopping) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultEc2Waiter.errorCode(error), "InvalidInstanceID.NotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeInstanceStatusResponse>> instanceStatusOkWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeInstanceStatusResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeInstanceStatusResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("InstanceStatuses").flatten().field("InstanceStatus").field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "ok"));
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultEc2Waiter.errorCode(error), "InvalidInstanceID.NotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeInstancesResponse>> instanceStoppedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeInstancesResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeInstancesResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Reservations").flatten().field("Instances").flatten().field("State").field("Name").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "stopped"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Reservations").flatten().field("Instances").flatten().field("State").field("Name").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "pending"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Reservations[].Instances[].State.Name=pending) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Reservations").flatten().field("Instances").flatten().field("State").field("Name").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "terminated"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Reservations[].Instances[].State.Name=terminated) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeInstancesResponse>> instanceTerminatedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeInstancesResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeInstancesResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Reservations").flatten().field("Instances").flatten().field("State").field("Name").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "terminated"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Reservations").flatten().field("Instances").flatten().field("State").field("Name").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "pending"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Reservations[].Instances[].State.Name=pending) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Reservations").flatten().field("Instances").flatten().field("State").field("Name").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "stopping"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Reservations[].Instances[].State.Name=stopping) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeInternetGatewaysResponse>> internetGatewayExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeInternetGatewaysResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeInternetGatewaysResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("InternetGateways").flatten().field("InternetGatewayId").length().compare(">", input.constant(new BigDecimal("0"))).value(), true);
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultEc2Waiter.errorCode(error), "InvalidInternetGateway.NotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeKeyPairsResponse>> keyPairExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeKeyPairsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeKeyPairsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("KeyPairs").flatten().field("KeyName").length().compare(">", input.constant(new BigDecimal("0"))).value(), true);
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultEc2Waiter.errorCode(error), "InvalidKeyPair.NotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeNatGatewaysResponse>> natGatewayAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeNatGatewaysResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeNatGatewaysResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("NatGateways").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("NatGateways").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "failed"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (NatGateways[].State=failed) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("NatGateways").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleting"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (NatGateways[].State=deleting) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("NatGateways").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleted"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (NatGateways[].State=deleted) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultEc2Waiter.errorCode(error), "NatGatewayNotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeNatGatewaysResponse>> natGatewayDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeNatGatewaysResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeNatGatewaysResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("NatGateways").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "deleted"));
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultEc2Waiter.errorCode(error), "NatGatewayNotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeNetworkInterfacesResponse>> networkInterfaceAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeNetworkInterfacesResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeNetworkInterfacesResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("NetworkInterfaces").flatten().field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnExceptionAcceptor(error -> Objects.equals(DefaultEc2Waiter.errorCode(error), "InvalidNetworkInterfaceID.NotFound"), (String)"A waiter acceptor was matched on error condition (InvalidNetworkInterfaceID.NotFound) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super GetPasswordDataResponse>> passwordDataAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super GetPasswordDataResponse>> result = new ArrayList<WaiterAcceptor<? super GetPasswordDataResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("PasswordData").length().compare(">", input.constant(new BigDecimal("0"))).value(), true);
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeSnapshotsResponse>> snapshotCompletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeSnapshotsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeSnapshotsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Snapshots").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "completed"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Snapshots").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "error"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Snapshots[].State=error) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeImportSnapshotTasksResponse>> snapshotImportedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeImportSnapshotTasksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeImportSnapshotTasksResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ImportSnapshotTasks").flatten().field("SnapshotTaskDetail").field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "completed"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("ImportSnapshotTasks").flatten().field("SnapshotTaskDetail").field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "error"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (ImportSnapshotTasks[].SnapshotTaskDetail.Status=error) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeSecurityGroupsResponse>> securityGroupExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeSecurityGroupsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeSecurityGroupsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            return Objects.equals(input.field("SecurityGroups").flatten().field("GroupId").length().compare(">", input.constant(new BigDecimal("0"))).value(), true);
        }));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultEc2Waiter.errorCode(error), "InvalidGroup.NotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeSpotInstanceRequestsResponse>> spotInstanceRequestFulfilledWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeSpotInstanceRequestsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeSpotInstanceRequestsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("SpotInstanceRequests").flatten().field("Status").field("Code").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "fulfilled"));
        }));
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("SpotInstanceRequests").flatten().field("Status").field("Code").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "request-canceled-and-instance-running"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("SpotInstanceRequests").flatten().field("Status").field("Code").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "schedule-expired"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (SpotInstanceRequests[].Status.Code=schedule-expired) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("SpotInstanceRequests").flatten().field("Status").field("Code").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "canceled-before-fulfillment"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (SpotInstanceRequests[].Status.Code=canceled-before-fulfillment) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("SpotInstanceRequests").flatten().field("Status").field("Code").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "bad-parameters"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (SpotInstanceRequests[].Status.Code=bad-parameters) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("SpotInstanceRequests").flatten().field("Status").field("Code").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "system-error"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (SpotInstanceRequests[].Status.Code=system-error) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultEc2Waiter.errorCode(error), "InvalidSpotInstanceRequestID.NotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeStoreImageTasksResponse>> storeImageTaskCompleteWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeStoreImageTasksResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeStoreImageTasksResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("StoreImageTaskResults").flatten().field("StoreTaskState").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "Completed"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("StoreImageTaskResults").flatten().field("StoreTaskState").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "Failed"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (StoreImageTaskResults[].StoreTaskState=Failed) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.retryOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("StoreImageTaskResults").flatten().field("StoreTaskState").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "InProgress"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeSubnetsResponse>> subnetAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeSubnetsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeSubnetsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Subnets").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeInstanceStatusResponse>> systemStatusOkWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeInstanceStatusResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeInstanceStatusResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("InstanceStatuses").flatten().field("SystemStatus").field("Status").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "ok"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeVolumesResponse>> volumeAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeVolumesResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeVolumesResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Volumes").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Volumes").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleted"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Volumes[].State=deleted) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeVolumesResponse>> volumeDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeVolumesResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeVolumesResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Volumes").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "deleted"));
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultEc2Waiter.errorCode(error), "InvalidVolume.NotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeVolumesResponse>> volumeInUseWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeVolumesResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeVolumesResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Volumes").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "in-use"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Volumes").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleted"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (Volumes[].State=deleted) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeVpcsResponse>> vpcAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeVpcsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeVpcsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("Vpcs").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeVpcsResponse>> vpcExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeVpcsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeVpcsResponse>>();
        result.add(new WaitersRuntime.ResponseStatusAcceptor(200, WaiterState.SUCCESS));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultEc2Waiter.errorCode(error), "InvalidVpcID.NotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeVpnConnectionsResponse>> vpnConnectionAvailableWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeVpnConnectionsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeVpnConnectionsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("VpnConnections").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "available"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("VpnConnections").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleting"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (VpnConnections[].State=deleting) and transitioned the waiter to failure state"));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("VpnConnections").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "deleted"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (VpnConnections[].State=deleted) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeVpnConnectionsResponse>> vpnConnectionDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeVpnConnectionsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeVpnConnectionsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("VpnConnections").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "deleted"));
        }));
        result.add(WaiterAcceptor.errorOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("VpnConnections").flatten().field("State").values();
            return !resultValues.isEmpty() && resultValues.stream().anyMatch(v -> Objects.equals(v, "pending"));
        }, (String)"A waiter acceptor with the matcher (pathAny) was matched on parameter (VpnConnections[].State=pending) and transitioned the waiter to failure state"));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeVpcPeeringConnectionsResponse>> vpcPeeringConnectionExistsWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeVpcPeeringConnectionsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeVpcPeeringConnectionsResponse>>();
        result.add(new WaitersRuntime.ResponseStatusAcceptor(200, WaiterState.SUCCESS));
        result.add(WaiterAcceptor.retryOnExceptionAcceptor(error -> Objects.equals(DefaultEc2Waiter.errorCode(error), "InvalidVpcPeeringConnectionID.NotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static List<WaiterAcceptor<? super DescribeVpcPeeringConnectionsResponse>> vpcPeeringConnectionDeletedWaiterAcceptors() {
        ArrayList<WaiterAcceptor<? super DescribeVpcPeeringConnectionsResponse>> result = new ArrayList<WaiterAcceptor<? super DescribeVpcPeeringConnectionsResponse>>();
        result.add(WaiterAcceptor.successOnResponseAcceptor(response -> {
            JmesPathRuntime.Value input = new JmesPathRuntime.Value(response);
            List<Object> resultValues = input.field("VpcPeeringConnections").flatten().field("Status").field("Code").values();
            return !resultValues.isEmpty() && resultValues.stream().allMatch(v -> Objects.equals(v, "deleted"));
        }));
        result.add(WaiterAcceptor.successOnExceptionAcceptor(error -> Objects.equals(DefaultEc2Waiter.errorCode(error), "InvalidVpcPeeringConnectionID.NotFound")));
        result.addAll(WaitersRuntime.DEFAULT_ACCEPTORS);
        return result;
    }

    private static WaiterOverrideConfiguration instanceExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration bundleTaskCompleteWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration conversionTaskCancelledWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration conversionTaskCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration conversionTaskDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration customerGatewayAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration exportTaskCancelledWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration exportTaskCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration imageExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration imageAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration instanceRunningWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration instanceStatusOkWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration instanceStoppedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration instanceTerminatedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration internetGatewayExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(6);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration keyPairExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(6);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration natGatewayAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration natGatewayDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration networkInterfaceAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(10);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(20L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration passwordDataAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration snapshotCompletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration snapshotImportedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration securityGroupExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(6);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration spotInstanceRequestFulfilledWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration storeImageTaskCompleteWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(5L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration subnetAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration systemStatusOkWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration volumeAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration volumeDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration volumeInUseWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration vpcAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration vpcExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(5);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(1L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration vpnConnectionAvailableWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration vpnConnectionDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration vpcPeeringConnectionExistsWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    private static WaiterOverrideConfiguration vpcPeeringConnectionDeletedWaiterConfig(WaiterOverrideConfiguration overrideConfig) {
        Optional<WaiterOverrideConfiguration> optionalOverrideConfig = Optional.ofNullable(overrideConfig);
        int maxAttempts = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::maxAttempts).orElse(40);
        BackoffStrategy backoffStrategy = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::backoffStrategyV2).orElse(BackoffStrategy.fixedDelayWithoutJitter((Duration)Duration.ofSeconds(15L)));
        Duration waitTimeout = optionalOverrideConfig.flatMap(WaiterOverrideConfiguration::waitTimeout).orElse(null);
        return WaiterOverrideConfiguration.builder().maxAttempts(Integer.valueOf(maxAttempts)).backoffStrategyV2(backoffStrategy).waitTimeout(waitTimeout).build();
    }

    public void close() {
        this.managedResources.close();
    }

    public static Ec2Waiter.Builder builder() {
        return new DefaultBuilder();
    }

    private <T extends Ec2Request> T applyWaitersUserAgent(T request) {
        Consumer<AwsRequestOverrideConfiguration.Builder> userAgentApplier = b -> b.addApiName(ApiName.builder().name("sdk-metrics").version("B").build());
        AwsRequestOverrideConfiguration overrideConfiguration = request.overrideConfiguration().map(c -> ((AwsRequestOverrideConfiguration.Builder)c.toBuilder().applyMutation(userAgentApplier)).build()).orElse(((AwsRequestOverrideConfiguration.Builder)AwsRequestOverrideConfiguration.builder().applyMutation(userAgentApplier)).build());
        return (T)((Object)((Ec2Request)request.toBuilder().overrideConfiguration(overrideConfiguration).build()));
    }

    public static final class DefaultBuilder
    implements Ec2Waiter.Builder {
        private Ec2Client client;
        private WaiterOverrideConfiguration overrideConfiguration;

        private DefaultBuilder() {
        }

        @Override
        public Ec2Waiter.Builder overrideConfiguration(WaiterOverrideConfiguration overrideConfiguration) {
            this.overrideConfiguration = overrideConfiguration;
            return this;
        }

        @Override
        public Ec2Waiter.Builder client(Ec2Client client) {
            this.client = client;
            return this;
        }

        @Override
        public Ec2Waiter build() {
            return new DefaultEc2Waiter(this);
        }
    }
}

