/*
 * Decompiled with CFR 0.152.
 */
package org.opensearch.client.opensearch.cluster;

import jakarta.json.stream.JsonGenerator;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.opensearch.client.json.JsonData;
import org.opensearch.client.json.JsonpDeserializable;
import org.opensearch.client.json.JsonpDeserializer;
import org.opensearch.client.json.JsonpMapper;
import org.opensearch.client.json.JsonpSerializable;
import org.opensearch.client.json.ObjectBuilderDeserializer;
import org.opensearch.client.json.ObjectDeserializer;
import org.opensearch.client.json.PlainJsonSerializable;
import org.opensearch.client.opensearch._types.mapping.TypeMapping;
import org.opensearch.client.opensearch.indices.AliasDefinition;
import org.opensearch.client.opensearch.indices.IndexSettings;
import org.opensearch.client.util.ApiTypeHelper;
import org.opensearch.client.util.CopyableBuilder;
import org.opensearch.client.util.ObjectBuilder;
import org.opensearch.client.util.ObjectBuilderBase;
import org.opensearch.client.util.ToCopyableBuilder;

@JsonpDeserializable
public class ComponentTemplateSummary
implements PlainJsonSerializable,
ToCopyableBuilder<Builder, ComponentTemplateSummary> {
    @Nonnull
    private final Map<String, AliasDefinition> aliases;
    @Nullable
    private final TypeMapping mappings;
    @Nonnull
    private final Map<String, JsonData> meta;
    @Nonnull
    private final Map<String, IndexSettings> settings;
    @Nullable
    private final Long version;
    public static final JsonpDeserializer<ComponentTemplateSummary> _DESERIALIZER = ObjectBuilderDeserializer.lazy(Builder::new, ComponentTemplateSummary::setupComponentTemplateSummaryDeserializer);

    private ComponentTemplateSummary(Builder builder) {
        this.aliases = ApiTypeHelper.unmodifiable(builder.aliases);
        this.mappings = builder.mappings;
        this.meta = ApiTypeHelper.unmodifiable(builder.meta);
        this.settings = ApiTypeHelper.unmodifiable(builder.settings);
        this.version = builder.version;
    }

    public static ComponentTemplateSummary of(Function<Builder, ObjectBuilder<ComponentTemplateSummary>> fn) {
        return fn.apply(new Builder()).build();
    }

    @Nonnull
    public final Map<String, AliasDefinition> aliases() {
        return this.aliases;
    }

    @Nullable
    public final TypeMapping mappings() {
        return this.mappings;
    }

    @Nonnull
    public final Map<String, JsonData> meta() {
        return this.meta;
    }

    @Nonnull
    public final Map<String, IndexSettings> settings() {
        return this.settings;
    }

    @Nullable
    public final Long version() {
        return this.version;
    }

    @Override
    public void serialize(JsonGenerator generator, JsonpMapper mapper) {
        generator.writeStartObject();
        this.serializeInternal(generator, mapper);
        generator.writeEnd();
    }

    protected void serializeInternal(JsonGenerator generator, JsonpMapper mapper) {
        if (ApiTypeHelper.isDefined(this.aliases)) {
            generator.writeKey("aliases");
            generator.writeStartObject();
            for (Map.Entry<String, AliasDefinition> entry : this.aliases.entrySet()) {
                generator.writeKey(entry.getKey());
                entry.getValue().serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.mappings != null) {
            generator.writeKey("mappings");
            this.mappings.serialize(generator, mapper);
        }
        if (ApiTypeHelper.isDefined(this.meta)) {
            generator.writeKey("_meta");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.meta.entrySet()) {
                generator.writeKey(entry.getKey());
                ((JsonData)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (ApiTypeHelper.isDefined(this.settings)) {
            generator.writeKey("settings");
            generator.writeStartObject();
            for (Map.Entry<String, JsonpSerializable> entry : this.settings.entrySet()) {
                generator.writeKey(entry.getKey());
                ((IndexSettings)entry.getValue()).serialize(generator, mapper);
            }
            generator.writeEnd();
        }
        if (this.version != null) {
            generator.writeKey("version");
            generator.write(this.version.longValue());
        }
    }

    @Override
    @Nonnull
    public Builder toBuilder() {
        return new Builder(this);
    }

    @Nonnull
    public static Builder builder() {
        return new Builder();
    }

    protected static void setupComponentTemplateSummaryDeserializer(ObjectDeserializer<Builder> op) {
        op.add(Builder::aliases, JsonpDeserializer.stringMapDeserializer(AliasDefinition._DESERIALIZER), "aliases");
        op.add(Builder::mappings, TypeMapping._DESERIALIZER, "mappings");
        op.add(Builder::meta, JsonpDeserializer.stringMapDeserializer(JsonData._DESERIALIZER), "_meta");
        op.add(Builder::settings, JsonpDeserializer.stringMapDeserializer(IndexSettings._DESERIALIZER), "settings");
        op.add(Builder::version, JsonpDeserializer.longDeserializer(), "version");
    }

    public int hashCode() {
        int result = 17;
        result = 31 * result + Objects.hashCode(this.aliases);
        result = 31 * result + Objects.hashCode(this.mappings);
        result = 31 * result + Objects.hashCode(this.meta);
        result = 31 * result + Objects.hashCode(this.settings);
        result = 31 * result + Objects.hashCode(this.version);
        return result;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ComponentTemplateSummary other = (ComponentTemplateSummary)o;
        return Objects.equals(this.aliases, other.aliases) && Objects.equals(this.mappings, other.mappings) && Objects.equals(this.meta, other.meta) && Objects.equals(this.settings, other.settings) && Objects.equals(this.version, other.version);
    }

    public static class Builder
    extends ObjectBuilderBase
    implements CopyableBuilder<Builder, ComponentTemplateSummary> {
        @Nullable
        private Map<String, AliasDefinition> aliases;
        @Nullable
        private TypeMapping mappings;
        @Nullable
        private Map<String, JsonData> meta;
        @Nullable
        private Map<String, IndexSettings> settings;
        @Nullable
        private Long version;

        public Builder() {
        }

        private Builder(ComponentTemplateSummary o) {
            this.aliases = Builder._mapCopy(o.aliases);
            this.mappings = o.mappings;
            this.meta = Builder._mapCopy(o.meta);
            this.settings = Builder._mapCopy(o.settings);
            this.version = o.version;
        }

        private Builder(Builder o) {
            this.aliases = Builder._mapCopy(o.aliases);
            this.mappings = o.mappings;
            this.meta = Builder._mapCopy(o.meta);
            this.settings = Builder._mapCopy(o.settings);
            this.version = o.version;
        }

        @Override
        @Nonnull
        public Builder copy() {
            return new Builder(this);
        }

        @Nonnull
        public final Builder aliases(Map<String, AliasDefinition> map) {
            this.aliases = Builder._mapPutAll(this.aliases, map);
            return this;
        }

        @Nonnull
        public final Builder aliases(String key, AliasDefinition value) {
            this.aliases = Builder._mapPut(this.aliases, key, value);
            return this;
        }

        @Nonnull
        public final Builder aliases(String key, Function<AliasDefinition.Builder, ObjectBuilder<AliasDefinition>> fn) {
            return this.aliases(key, fn.apply(new AliasDefinition.Builder()).build());
        }

        @Nonnull
        public final Builder mappings(@Nullable TypeMapping value) {
            this.mappings = value;
            return this;
        }

        @Nonnull
        public final Builder mappings(Function<TypeMapping.Builder, ObjectBuilder<TypeMapping>> fn) {
            return this.mappings(fn.apply(new TypeMapping.Builder()).build());
        }

        @Nonnull
        public final Builder meta(Map<String, JsonData> map) {
            this.meta = Builder._mapPutAll(this.meta, map);
            return this;
        }

        @Nonnull
        public final Builder meta(String key, JsonData value) {
            this.meta = Builder._mapPut(this.meta, key, value);
            return this;
        }

        @Nonnull
        public final Builder settings(Map<String, IndexSettings> map) {
            this.settings = Builder._mapPutAll(this.settings, map);
            return this;
        }

        @Nonnull
        public final Builder settings(String key, IndexSettings value) {
            this.settings = Builder._mapPut(this.settings, key, value);
            return this;
        }

        @Nonnull
        public final Builder settings(String key, Function<IndexSettings.Builder, ObjectBuilder<IndexSettings>> fn) {
            return this.settings(key, fn.apply(new IndexSettings.Builder()).build());
        }

        @Nonnull
        public final Builder version(@Nullable Long value) {
            this.version = value;
            return this;
        }

        @Override
        @Nonnull
        public ComponentTemplateSummary build() {
            this._checkSingleUse();
            return new ComponentTemplateSummary(this);
        }
    }
}

