/*
 * Decompiled with CFR 0.152.
 */
package software.amazon.awssdk.crt.mqtt;

import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import java.util.stream.Stream;

public enum QualityOfService {
    AT_MOST_ONCE(0),
    AT_LEAST_ONCE(1),
    EXACTLY_ONCE(2);

    private int qos;
    private static Map<Integer, QualityOfService> enumMapping;

    private QualityOfService(int value) {
        this.qos = value;
    }

    public int getValue() {
        return this.qos;
    }

    public static QualityOfService getEnumValueFromInteger(int value) {
        QualityOfService enumValue = enumMapping.get(value);
        if (enumValue != null) {
            return enumValue;
        }
        throw new RuntimeException("Illegal QualityOfService");
    }

    private static Map<Integer, QualityOfService> buildEnumMapping() {
        return Stream.of(QualityOfService.values()).collect(Collectors.toMap(QualityOfService::getValue, Function.identity()));
    }

    static {
        enumMapping = QualityOfService.buildEnumMapping();
    }
}

