/*
 * Decompiled with CFR 0.152.
 */
package org.passay;

import java.util.MissingResourceException;
import java.util.ResourceBundle;
import org.passay.AbstractMessageResolver;

public class ResourceBundleMessageResolver
extends AbstractMessageResolver {
    private final ResourceBundle resourceBundle;

    public ResourceBundleMessageResolver() {
        this(ResourceBundleMessageResolver.getDefaultBundle());
    }

    public ResourceBundleMessageResolver(ResourceBundle bundle) {
        if (bundle == null) {
            throw new IllegalArgumentException("Bundle cannot be null.");
        }
        this.resourceBundle = bundle;
    }

    @Override
    protected String getMessage(String key) {
        try {
            return this.resourceBundle.getString(key);
        }
        catch (MissingResourceException e) {
            return null;
        }
    }

    public static ResourceBundle getDefaultBundle() {
        return ResourceBundle.getBundle("passay");
    }
}

