/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.activitydiagram3;

import java.util.Collections;
import java.util.Set;
import net.sourceforge.plantuml.activitydiagram3.AbstractInstruction;
import net.sourceforge.plantuml.activitydiagram3.Instruction;
import net.sourceforge.plantuml.activitydiagram3.InstructionCollection;
import net.sourceforge.plantuml.activitydiagram3.InstructionList;
import net.sourceforge.plantuml.activitydiagram3.LinkRendering;
import net.sourceforge.plantuml.activitydiagram3.PositionedNote;
import net.sourceforge.plantuml.activitydiagram3.ftile.Ftile;
import net.sourceforge.plantuml.activitydiagram3.ftile.FtileFactory;
import net.sourceforge.plantuml.activitydiagram3.ftile.Swimlane;
import net.sourceforge.plantuml.activitydiagram3.ftile.vcompact.FtileWithNotes;
import net.sourceforge.plantuml.activitydiagram3.gtile.Gtile;
import net.sourceforge.plantuml.activitydiagram3.gtile.GtileGroup;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.decoration.symbol.USymbol;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.VerticalAlignment;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.NoteType;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.Style;

public class InstructionGroup
extends AbstractInstruction
implements Instruction,
InstructionCollection {
    private final InstructionList list;
    private final Instruction parent;
    private final HColor backColor;
    private final LinkRendering linkRendering;
    private final USymbol type;
    private final Display title;
    private PositionedNote note = null;
    private final Style style;

    @Override
    public boolean containsBreak() {
        return this.list.containsBreak();
    }

    public InstructionGroup(Instruction parent, Display title, HColor backColor, Swimlane swimlane, LinkRendering linkRendering, USymbol type, Style style) {
        this.list = new InstructionList(swimlane);
        this.type = type;
        this.linkRendering = linkRendering;
        this.parent = parent;
        this.title = title;
        this.style = style;
        this.backColor = backColor;
    }

    @Override
    public CommandExecutionResult add(Instruction ins) {
        return this.list.add(ins);
    }

    @Override
    public Gtile createGtile(ISkinParam skinParam, StringBounder stringBounder) {
        Gtile tmp = this.list.createGtile(skinParam, stringBounder);
        return new GtileGroup(tmp, this.title, null, HColors.BLUE, this.backColor, tmp.skinParam(), this.type, this.style);
    }

    @Override
    public Ftile createFtile(FtileFactory factory) {
        Ftile tmp = this.list.createFtile(factory);
        if (this.note != null) {
            tmp = new FtileWithNotes(tmp, Collections.singleton(this.note), VerticalAlignment.CENTER);
        }
        return factory.createGroup(tmp, this.title, this.backColor, null, this.type, this.style);
    }

    public Instruction getParent() {
        return this.parent;
    }

    @Override
    public final boolean kill() {
        return this.list.kill();
    }

    @Override
    public LinkRendering getInLinkRendering() {
        return this.linkRendering;
    }

    @Override
    public boolean addNote(Display note, NotePosition position, NoteType type, Colors colors, Swimlane swimlaneNote, Stereotype stereotype) {
        if (this.list.isEmpty()) {
            this.note = new PositionedNote(note, position, type, swimlaneNote, colors, stereotype);
            return true;
        }
        return this.list.addNote(note, position, type, colors, swimlaneNote, stereotype);
    }

    @Override
    public Set<Swimlane> getSwimlanes() {
        return this.list.getSwimlanes();
    }

    @Override
    public Swimlane getSwimlaneIn() {
        return this.list.getSwimlaneIn();
    }

    @Override
    public Swimlane getSwimlaneOut() {
        return this.list.getSwimlaneOut();
    }

    @Override
    public Instruction getLast() {
        return this.list.getLast();
    }
}

