/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.code;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import net.sourceforge.plantuml.FileUtils;
import net.sourceforge.plantuml.brotli.BrotliInputStream;
import net.sourceforge.plantuml.code.ByteArray;
import net.sourceforge.plantuml.code.Compression;
import net.sourceforge.plantuml.code.NoPlantumlCompressionException;
import net.sourceforge.plantuml.log.Logme;

public class CompressionBrotli
implements Compression {
    @Override
    public byte[] compress(byte[] in) {
        throw new UnsupportedOperationException();
    }

    /*
     * Enabled aggressive exception aggregation
     */
    @Override
    public ByteArray decompress(byte[] in) throws NoPlantumlCompressionException {
        try (BrotliInputStream brotli = new BrotliInputStream(new ByteArrayInputStream(in));){
            ByteArray byteArray;
            try (ByteArrayOutputStream result = new ByteArrayOutputStream();){
                FileUtils.copyToStream(brotli, (OutputStream)result);
                byteArray = ByteArray.from(result.toByteArray());
            }
            return byteArray;
        }
        catch (IOException e) {
            Logme.error(e);
            throw new NoPlantumlCompressionException(e);
        }
    }
}

