/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.command;

import net.sourceforge.plantuml.Lazy;
import net.sourceforge.plantuml.TitledDiagram;
import net.sourceforge.plantuml.abel.DisplayPositioned;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.Trim;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.VerticalAlignment;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.Pattern2;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexOptional;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.utils.BlocLines;
import net.sourceforge.plantuml.utils.LineLocation;

public class CommandMultilinesLegend
extends CommandMultilines2<TitledDiagram> {
    private static final Lazy<Pattern2> END = new Lazy<Pattern2>(() -> Pattern2.cmpile("^end[%s]?legend$"));
    public static final CommandMultilinesLegend ME = new CommandMultilinesLegend();

    private CommandMultilinesLegend() {
        super(CommandMultilinesLegend.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE, Trim.BOTH, END);
    }

    private static IRegex getRegexConcat() {
        return RegexConcat.build(CommandMultilinesLegend.class.getName(), RegexLeaf.start(), new RegexLeaf("legend"), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "VALIGN", "(top|bottom)"))), new RegexOptional((IRegex)new RegexConcat(RegexLeaf.spaceOneOrMore(), new RegexLeaf(1, "ALIGN", "(left|right|center)"))), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeNow(TitledDiagram diagram, BlocLines lines, ParserPass currentPass) throws NoSuchColorException {
        LineLocation location = lines.getLocation();
        lines = lines.trimSmart(1);
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        String align = line0.get("ALIGN", 0);
        String valign = line0.get("VALIGN", 0);
        lines = lines.subExtract(1, 1);
        Display strings = (lines = lines.removeEmptyColumns()).toDisplay();
        if (strings.size() > 0) {
            VerticalAlignment valignment = VerticalAlignment.fromString(valign);
            HorizontalAlignment alignment = HorizontalAlignment.fromString(align);
            if (alignment == null) {
                alignment = HorizontalAlignment.CENTER;
            }
            diagram.setLegend(DisplayPositioned.single(location, strings.replaceBackslashT(), alignment, valignment));
            return CommandExecutionResult.ok();
        }
        return CommandExecutionResult.error("No legend defined");
    }
}

