/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.decoration;

import net.sourceforge.plantuml.klimt.UStroke;

public class LinkStyle {
    private final Type type;
    private final Double thickness;

    private LinkStyle(Type type, Double thickness) {
        this.type = type;
        this.thickness = thickness;
    }

    public String toString() {
        return this.type.toString() + "(" + this.thickness + ")";
    }

    public boolean isNormal() {
        return this.type == Type.NORMAL;
    }

    public boolean isInvisible() {
        return this.type == Type.INVISIBLE;
    }

    public static LinkStyle NORMAL() {
        return new LinkStyle(Type.NORMAL, null);
    }

    public static LinkStyle INVISIBLE() {
        return new LinkStyle(Type.INVISIBLE, null);
    }

    public static LinkStyle BOLD() {
        return new LinkStyle(Type.BOLD, null);
    }

    public static LinkStyle DOTTED() {
        return new LinkStyle(Type.DOTTED, null);
    }

    public static LinkStyle DASHED() {
        return new LinkStyle(Type.DASHED, null);
    }

    public LinkStyle goThickness(double thickness) {
        return new LinkStyle(this.type, thickness);
    }

    public UStroke getStroke3() {
        if (this.type == Type.DASHED) {
            return new UStroke(7.0, 7.0, this.nonZeroThickness());
        }
        if (this.type == Type.DOTTED) {
            return new UStroke(1.0, 3.0, this.nonZeroThickness());
        }
        if (this.type == Type.BOLD) {
            return UStroke.withThickness(2.0);
        }
        return UStroke.withThickness(this.nonZeroThickness());
    }

    public UStroke muteStroke(UStroke stroke) {
        if (this.type == Type.DASHED || this.type == Type.DOTTED || this.type == Type.BOLD) {
            return this.getStroke3();
        }
        return stroke;
    }

    private double nonZeroThickness() {
        if (this.thickness == null) {
            return 1.0;
        }
        return this.thickness;
    }

    public static LinkStyle fromString1(String s) {
        LinkStyle result = LinkStyle.fromString2(s);
        if (result == null) {
            return LinkStyle.NORMAL();
        }
        return result;
    }

    public static LinkStyle fromString2(String s) {
        if ("dashed".equalsIgnoreCase(s)) {
            return LinkStyle.DASHED();
        }
        if ("dotted".equalsIgnoreCase(s)) {
            return LinkStyle.DOTTED();
        }
        if ("bold".equalsIgnoreCase(s)) {
            return LinkStyle.BOLD();
        }
        if ("hidden".equalsIgnoreCase(s)) {
            return LinkStyle.INVISIBLE();
        }
        return null;
    }

    public boolean isThicknessOverrided() {
        return this.thickness != null;
    }

    static enum Type {
        NORMAL,
        DASHED,
        DOTTED,
        BOLD,
        INVISIBLE;

    }
}

