/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.decoration.symbol;

import net.sourceforge.plantuml.decoration.symbol.USymbol;
import net.sourceforge.plantuml.klimt.Fashion;
import net.sourceforge.plantuml.klimt.UPath;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColors;
import net.sourceforge.plantuml.klimt.creole.Stencil;
import net.sourceforge.plantuml.klimt.drawing.AbstractUGraphicHorizontalLine;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.HorizontalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlockUtils;
import net.sourceforge.plantuml.klimt.shape.UHorizontalLine;
import net.sourceforge.plantuml.style.SName;

class USymbolQueue
extends USymbol {
    private final double dx = 5.0;

    USymbolQueue() {
    }

    @Override
    public SName[] getSNames() {
        return new SName[]{SName.queue};
    }

    private void drawQueue(UGraphic ug, double width, double height, double shadowing) {
        UPath shape = UPath.none();
        shape.setDeltaShadow(shadowing);
        shape.moveTo(5.0, 0.0);
        shape.lineTo(width - 5.0, 0.0);
        shape.cubicTo(width, 0.0, width, height / 2.0, width, height / 2.0);
        shape.cubicTo(width, height / 2.0, width, height, width - 5.0, height);
        shape.lineTo(5.0, height);
        shape.cubicTo(0.0, height, 0.0, height / 2.0, 0.0, height / 2.0);
        shape.cubicTo(0.0, height / 2.0, 0.0, 0.0, 5.0, 0.0);
        ug.draw(shape);
        UPath closing = this.getClosingPath(width, height);
        ug.apply(HColors.none().bg()).draw(closing);
    }

    private UPath getClosingPath(double width, double height) {
        UPath closing = UPath.none();
        closing.moveTo(width - 5.0, 0.0);
        closing.cubicTo(width - 10.0, 0.0, width - 10.0, height / 2.0, width - 10.0, height / 2.0);
        closing.cubicTo(width - 10.0, height, width - 5.0, height, width - 5.0, height);
        return closing;
    }

    private USymbol.Margin getMargin() {
        return new USymbol.Margin(5.0, 15.0, 5.0, 5.0);
    }

    @Override
    public TextBlock asSmall(TextBlock name, final TextBlock label, final TextBlock stereotype, final Fashion symbolContext, HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(this){
            final /* synthetic */ USymbolQueue this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void drawU(UGraphic ug) {
                XDimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = symbolContext.apply(ug);
                this.this$0.drawQueue(ug, dim.getWidth(), dim.getHeight(), symbolContext.getDeltaShadow());
                USymbol.Margin margin = this.this$0.getMargin();
                TextBlock tb = TextBlockUtils.mergeTB(stereotype, label, HorizontalAlignment.CENTER);
                MyUGraphicQueue ug2 = this.this$0.new MyUGraphicQueue(ug, dim.getWidth() - 10.0, dim.getWidth() - 5.0, dim.getHeight());
                tb.drawU(ug2.apply(new UTranslate(margin.getX1(), margin.getY1())));
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                XDimension2D dimLabel = label.calculateDimension(stringBounder);
                XDimension2D dimStereo = stereotype.calculateDimension(stringBounder);
                return this.this$0.getMargin().addDimension(dimStereo.mergeTB(dimLabel));
            }
        };
    }

    @Override
    public TextBlock asBig(final TextBlock title, HorizontalAlignment labelAlignment, final TextBlock stereotype, final double width, final double height, final Fashion symbolContext, HorizontalAlignment stereoAlignment) {
        return new AbstractTextBlock(this){
            final /* synthetic */ USymbolQueue this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void drawU(UGraphic ug) {
                XDimension2D dim = this.calculateDimension(ug.getStringBounder());
                ug = symbolContext.apply(ug);
                this.this$0.drawQueue(ug, dim.getWidth(), dim.getHeight(), symbolContext.getDeltaShadow());
                XDimension2D dimStereo = stereotype.calculateDimension(ug.getStringBounder());
                double posStereo = (width - dimStereo.getWidth()) / 2.0;
                stereotype.drawU(ug.apply(new UTranslate(posStereo, 2.0)));
                XDimension2D dimTitle = title.calculateDimension(ug.getStringBounder());
                double posTitle = (width - dimTitle.getWidth()) / 2.0;
                title.drawU(ug.apply(new UTranslate(posTitle, 2.0 + dimStereo.getHeight())));
            }

            @Override
            public XDimension2D calculateDimension(StringBounder stringBounder) {
                return new XDimension2D(width, height);
            }
        };
    }

    class MyUGraphicQueue
    extends AbstractUGraphicHorizontalLine
    implements Stencil {
        private final double x1;
        private final double x2;
        private final double fullHeight;

        @Override
        protected AbstractUGraphicHorizontalLine copy(UGraphic ug) {
            return new MyUGraphicQueue(ug, this.x1, this.x2, this.fullHeight);
        }

        public MyUGraphicQueue(UGraphic ug, double x1, double x2, double fullHeight) {
            super(ug);
            this.x1 = x1;
            this.x2 = x2;
            this.fullHeight = fullHeight;
        }

        @Override
        protected void drawHline(UGraphic ug, UHorizontalLine line, UTranslate translate) {
            line.drawLineInternal(ug, this, translate.getDy(), line.getStroke());
        }

        @Override
        public double getStartingX(StringBounder stringBounder, double y) {
            return 0.0;
        }

        @Override
        public double getEndingX(StringBounder stringBounder, double y) {
            double halfHeight = this.fullHeight / 2.0;
            double factor2 = y <= halfHeight ? 1.0 - y / halfHeight : (y - halfHeight) / halfHeight;
            return (this.x2 - this.x1) * factor2 + this.x1;
        }
    }
}

