/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.ebnf;

import net.sourceforge.plantuml.Lazy;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.CommandMultilines2;
import net.sourceforge.plantuml.command.MultilinesStrategy;
import net.sourceforge.plantuml.command.ParserPass;
import net.sourceforge.plantuml.command.Trim;
import net.sourceforge.plantuml.ebnf.PSystemEbnf;
import net.sourceforge.plantuml.klimt.color.ColorParser;
import net.sourceforge.plantuml.klimt.color.ColorType;
import net.sourceforge.plantuml.klimt.color.Colors;
import net.sourceforge.plantuml.klimt.color.NoSuchColorException;
import net.sourceforge.plantuml.klimt.creole.Display;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.Pattern2;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;
import net.sourceforge.plantuml.utils.BlocLines;

public class CommandNoteMultilines
extends CommandMultilines2<PSystemEbnf> {
    private static final Lazy<Pattern2> END = new Lazy<Pattern2>(() -> Pattern2.cmpile("^end[%s]?note$"));

    public CommandNoteMultilines() {
        super(CommandNoteMultilines.getRegexConcat(), MultilinesStrategy.REMOVE_STARTING_QUOTE, Trim.BOTH, END);
    }

    private static ColorParser color() {
        return ColorParser.simpleColor(ColorType.BACK);
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandNoteMultilines.class.getName(), RegexLeaf.start(), new RegexLeaf("note"), RegexLeaf.spaceZeroOrMore(), CommandNoteMultilines.color().getRegex(), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeNow(PSystemEbnf diagram, BlocLines lines, ParserPass currentPass) throws NoSuchColorException {
        RegexResult line0 = this.getStartingPattern().matcher(lines.getFirst().getTrimmed().getString());
        lines = lines.subExtract(1, 1);
        lines = lines.removeEmptyColumns();
        Display note = lines.toDisplay();
        Colors colors = CommandNoteMultilines.color().getColor(line0, diagram.getSkinParam().getIHtmlColorSet());
        return diagram.addNote(note, colors);
    }
}

