/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.klimt.shape;

import java.util.ArrayList;
import java.util.List;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.VerticalAlignment;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.TextBlock;

public class TextBlockHorizontal
extends AbstractTextBlock
implements TextBlock {
    private final List<TextBlock> blocks = new ArrayList<TextBlock>();
    private final VerticalAlignment alignment;

    TextBlockHorizontal(TextBlock b1, TextBlock b2, VerticalAlignment alignment) {
        this.blocks.add(b1);
        this.blocks.add(b2);
        this.alignment = alignment;
    }

    public TextBlockHorizontal(List<TextBlock> all, VerticalAlignment alignment) {
        if (all.size() < 2) {
            throw new IllegalArgumentException();
        }
        this.blocks.addAll(all);
        this.alignment = alignment;
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D dim = this.blocks.get(0).calculateDimension(stringBounder);
        for (int i = 1; i < this.blocks.size(); ++i) {
            dim = dim.mergeLR(this.blocks.get(i).calculateDimension(stringBounder));
        }
        return dim;
    }

    @Override
    public void drawU(UGraphic ug) {
        double x = 0.0;
        XDimension2D dimtotal = this.calculateDimension(ug.getStringBounder());
        for (TextBlock block : this.blocks) {
            XDimension2D dimb = block.calculateDimension(ug.getStringBounder());
            if (this.alignment == VerticalAlignment.CENTER) {
                double dy = (dimtotal.getHeight() - dimb.getHeight()) / 2.0;
                block.drawU(ug.apply(new UTranslate(x, dy)));
            } else {
                block.drawU(ug.apply(UTranslate.dx(x)));
            }
            x += dimb.getWidth();
        }
    }
}

