/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.project.lang;

import net.sourceforge.plantuml.core.Diagram;
import net.sourceforge.plantuml.project.Failable;
import net.sourceforge.plantuml.project.lang.Something;
import net.sourceforge.plantuml.regex.IRegex;
import net.sourceforge.plantuml.regex.RegexConcat;
import net.sourceforge.plantuml.regex.RegexLeaf;
import net.sourceforge.plantuml.regex.RegexResult;

public class PairOfSomething<D extends Diagram>
implements Something<D> {
    private final Something<D> complement1;
    private final Something<D> complement2;

    public PairOfSomething(Something<D> complement1, Something<D> complement2) {
        this.complement1 = complement1;
        this.complement2 = complement2;
    }

    @Override
    public Failable<? extends Object> getMe(D diagram, RegexResult arg, String suffix) {
        Failable<Object> r1 = this.complement1.getMe(diagram, arg, "A" + suffix);
        Failable<Object> r2 = this.complement2.getMe(diagram, arg, "B" + suffix);
        if (r1.isFail()) {
            return r1;
        }
        if (r2.isFail()) {
            return r2;
        }
        Object[] result = new Object[]{r1.get(), r2.get()};
        return Failable.ok(result);
    }

    @Override
    public IRegex toRegex(String suffix) {
        IRegex pattern1 = this.complement1.toRegex("A" + suffix);
        IRegex pattern2 = this.complement2.toRegex("B" + suffix);
        return new RegexConcat(pattern1, new RegexLeaf("[%s]+"), pattern2);
    }
}

