/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.stats;

import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import net.sourceforge.plantuml.stats.HumanDuration;
import net.sourceforge.plantuml.stats.api.Stats;
import net.sourceforge.plantuml.stats.api.StatsColumn;
import net.sourceforge.plantuml.stats.api.StatsLine;
import net.sourceforge.plantuml.stats.api.StatsTable;

public class CreoleConverter {
    private final DateFormat formatter = DateFormat.getDateTimeInstance(3, 2);
    private final Stats stats;

    public CreoleConverter(Stats stats) {
        this.stats = stats;
    }

    public List<String> toCreole() {
        ArrayList<String> result = new ArrayList<String>();
        result.add("<b><size:16>Statistics</b>");
        this.printTableCreole(result, this.stats.getLastSessions());
        result.add(" ");
        result.add("<b><size:16>Current session statistics</b>");
        this.printTableCreole(result, this.stats.getCurrentSessionByDiagramType());
        result.add(" ");
        this.printTableCreole(result, this.stats.getCurrentSessionByFormat());
        result.add(" ");
        result.add("<b><size:16>General statistics since ever</b>");
        this.printTableCreole(result, this.stats.getAllByDiagramType());
        result.add(" ");
        this.printTableCreole(result, this.stats.getAllByFormat());
        return result;
    }

    private void printTableCreole(List<String> strings, StatsTable table) {
        Collection<StatsColumn> headers = table.getColumnHeaders();
        strings.add(this.getCreoleHeader(headers));
        List<StatsLine> lines = table.getLines();
        for (int i = 0; i < lines.size(); ++i) {
            StatsLine line = lines.get(i);
            boolean bold = i == lines.size() - 1;
            strings.add(this.getCreoleLine(headers, line, bold));
        }
    }

    private String getCreoleLine(Collection<StatsColumn> headers, StatsLine line, boolean bold) {
        StringBuilder result = new StringBuilder();
        for (StatsColumn col : headers) {
            Object v = line.getValue(col);
            result.append("|");
            if (v instanceof Long || v instanceof HumanDuration) {
                result.append("<r> ");
            } else {
                result.append(" ");
            }
            if (bold) {
                result.append("<b>");
            }
            if (v instanceof Long) {
                result.append(String.format("%,d", v));
            } else if (v instanceof Date) {
                result.append(this.formatter.format(v));
            } else if (v == null || v.toString().length() == 0) {
                result.append(" ");
            } else {
                result.append(v.toString());
            }
            if (bold) {
                result.append("</b>");
            }
            result.append(" ");
        }
        result.append("|");
        return result.toString();
    }

    private String getCreoleHeader(Collection<StatsColumn> headers) {
        StringBuilder sb = new StringBuilder();
        for (StatsColumn col : headers) {
            sb.append("| ");
            sb.append(col.getTitle());
            sb.append(" ");
        }
        sb.append("|");
        return sb.toString();
    }
}

