/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.util.List;
import net.sourceforge.plantuml.klimt.UStroke;
import net.sourceforge.plantuml.klimt.UTranslate;
import net.sourceforge.plantuml.klimt.color.HColor;
import net.sourceforge.plantuml.klimt.drawing.UGraphic;
import net.sourceforge.plantuml.klimt.font.StringBounder;
import net.sourceforge.plantuml.klimt.geom.XDimension2D;
import net.sourceforge.plantuml.klimt.shape.AbstractTextBlock;
import net.sourceforge.plantuml.klimt.shape.ULine;
import net.sourceforge.plantuml.stereo.Stereotype;
import net.sourceforge.plantuml.style.ISkinParam;
import net.sourceforge.plantuml.style.PName;
import net.sourceforge.plantuml.style.SName;
import net.sourceforge.plantuml.style.Style;
import net.sourceforge.plantuml.style.StyleSignatureBasic;
import net.sourceforge.plantuml.svek.IEntityImage;
import net.sourceforge.plantuml.svek.Margins;
import net.sourceforge.plantuml.svek.ShapeType;

public final class ConcurrentStates
extends AbstractTextBlock
implements IEntityImage {
    private final List<IEntityImage> inners;
    private final Separator separator;
    private final ISkinParam skinParam;
    private final Stereotype stereotype;

    public ConcurrentStates(List<IEntityImage> inners, char concurrentSeparator, ISkinParam skinParam, Stereotype stereotype) {
        this.separator = Separator.fromChar(concurrentSeparator);
        this.skinParam = skinParam;
        this.stereotype = stereotype;
        this.inners = inners;
    }

    private Style getStyle() {
        return this.getStyleSignature().getMergedStyle(this.skinParam.getCurrentStyleBuilder());
    }

    private StyleSignatureBasic getStyleSignature() {
        return StyleSignatureBasic.of(SName.root, SName.element, SName.stateDiagram, SName.state);
    }

    @Override
    public void drawU(UGraphic ug) {
        HColor borderColor = this.getStyle().value(PName.LineColor).asColor(this.skinParam.getIHtmlColorSet());
        StringBounder stringBounder = ug.getStringBounder();
        XDimension2D dimTotal = this.calculateDimension(stringBounder);
        for (int i = 0; i < this.inners.size(); ++i) {
            IEntityImage inner = this.inners.get(i);
            inner.drawU(ug);
            XDimension2D dim = inner.calculateDimension(stringBounder);
            ug = ug.apply(this.separator.move(dim));
            if (i >= this.inners.size() - 1) continue;
            this.separator.drawSeparator(ug.apply(borderColor), dimTotal);
        }
    }

    @Override
    public XDimension2D calculateDimension(StringBounder stringBounder) {
        XDimension2D result = new XDimension2D(0.0, 0.0);
        for (IEntityImage inner : this.inners) {
            XDimension2D dim = inner.calculateDimension(stringBounder);
            result = this.separator.add(result, dim);
        }
        return result;
    }

    @Override
    public HColor getBackcolor() {
        return this.skinParam.getBackgroundColor();
    }

    @Override
    public double getOverscanX(StringBounder stringBounder) {
        return 0.0;
    }

    @Override
    public boolean isHidden() {
        return false;
    }

    @Override
    public Margins getShield(StringBounder stringBounder) {
        return Margins.NONE;
    }

    @Override
    public ShapeType getShapeType() {
        return ShapeType.RECTANGLE;
    }

    static enum Separator {
        VERTICAL,
        HORIZONTAL;


        static Separator fromChar(char sep) {
            if (sep == '|') {
                return VERTICAL;
            }
            if (sep == '-') {
                return HORIZONTAL;
            }
            throw new IllegalArgumentException();
        }

        UTranslate move(XDimension2D dim) {
            if (this == VERTICAL) {
                return UTranslate.dx(dim.getWidth());
            }
            return UTranslate.dy(dim.getHeight());
        }

        XDimension2D add(XDimension2D orig, XDimension2D other) {
            if (this == VERTICAL) {
                return new XDimension2D(orig.getWidth() + other.getWidth(), Math.max(orig.getHeight(), other.getHeight()));
            }
            return new XDimension2D(Math.max(orig.getWidth(), other.getWidth()), orig.getHeight() + other.getHeight());
        }

        void drawSeparator(UGraphic ug, XDimension2D dimTotal) {
            double THICKNESS_BORDER = 1.5;
            int DASH = 8;
            ug = ug.apply(new UStroke(8.0, 10.0, 1.5));
            if (this == VERTICAL) {
                ug.draw(ULine.vline(dimTotal.getHeight() + 8.0));
            } else {
                ug.draw(ULine.hline(dimTotal.getWidth() + 8.0));
            }
        }
    }
}

