/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.svek;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.StringTokenizer;
import net.sourceforge.plantuml.StringUtils;
import net.sourceforge.plantuml.klimt.geom.XCubicCurve2D;
import net.sourceforge.plantuml.klimt.geom.XPoint2D;
import net.sourceforge.plantuml.klimt.shape.DotPath;
import net.sourceforge.plantuml.svek.Point2DFunction;
import net.sourceforge.plantuml.svek.PointListIterator;
import net.sourceforge.plantuml.svek.PointListIteratorImpl;

public class SvgResult {
    public static final String D_EQUALS = "d=\"";
    public static final String POINTS_EQUALS = "points=\"";
    private final String svg;
    private final Point2DFunction function;

    public SvgResult(String svg, Point2DFunction function) {
        this.svg = svg;
        this.function = function;
    }

    public PointListIterator getPointsWithThisColor(int lineColor) {
        return PointListIteratorImpl.create(this, lineColor);
    }

    public List<XPoint2D> extractList(String searched) {
        int p2 = this.indexOf(searched, 0);
        if (p2 == -1) {
            return Collections.emptyList();
        }
        int p3 = this.indexOf("\"", p2 + searched.length());
        if (p3 == -1) {
            return Collections.emptyList();
        }
        return this.substring(p2 + searched.length(), p3).getPoints(" MC");
    }

    public int getIndexFromColor(int color) {
        String s = "stroke=\"" + StringUtils.goLowerCase(StringUtils.sharp000000(color)) + "\"";
        int idx = this.svg.indexOf(s);
        if (idx != -1) {
            return idx;
        }
        s = ";stroke:" + StringUtils.goLowerCase(StringUtils.sharp000000(color)) + ";";
        idx = this.svg.indexOf(s);
        if (idx != -1) {
            return idx;
        }
        s = "fill=\"" + StringUtils.goLowerCase(StringUtils.sharp000000(color)) + "\"";
        idx = this.svg.indexOf(s);
        if (idx != -1) {
            return idx;
        }
        return -1;
    }

    public List<XPoint2D> getPoints(String separator) {
        try {
            StringTokenizer st = new StringTokenizer(this.svg, separator);
            ArrayList<XPoint2D> result = new ArrayList<XPoint2D>();
            while (st.hasMoreTokens()) {
                result.add(this.getFirstPoint(st.nextToken()));
            }
            return result;
        }
        catch (NumberFormatException e) {
            return Collections.emptyList();
        }
    }

    public XPoint2D getNextPoint() {
        return this.getFirstPoint(this.svg);
    }

    private XPoint2D getFirstPoint(String tmp) {
        StringTokenizer st = new StringTokenizer(tmp, ",");
        double startX = Double.parseDouble(st.nextToken());
        double startY = Double.parseDouble(st.nextToken());
        return this.function.apply(new XPoint2D(startX, startY));
    }

    public int indexOf(String s, int pos) {
        return this.svg.indexOf(s, pos);
    }

    public SvgResult substring(int pos) {
        return new SvgResult(this.svg.substring(pos), this.function);
    }

    public SvgResult substring(int start, int end) {
        return new SvgResult(this.svg.substring(start, end), this.function);
    }

    public final String getSvg() {
        return this.svg;
    }

    public DotPath toDotPath() {
        if (!this.isPathConsistent()) {
            throw new IllegalArgumentException();
        }
        ArrayList<XCubicCurve2D> beziers = new ArrayList<XCubicCurve2D>();
        int posC = this.indexOf("C", 0);
        if (posC == -1) {
            throw new IllegalArgumentException();
        }
        XPoint2D start = this.substring(1, posC).getNextPoint();
        ArrayList<DotPath.TriPoints> triPoints = new ArrayList<DotPath.TriPoints>();
        Iterator<XPoint2D> it = this.substring(posC + 1).getPoints(" ").iterator();
        while (it.hasNext()) {
            XPoint2D p1 = it.next();
            XPoint2D p2 = it.next();
            XPoint2D p = it.next();
            triPoints.add(new DotPath.TriPoints(p1, p2, p));
        }
        double x = start.getX();
        double y = start.getY();
        for (DotPath.TriPoints p : triPoints) {
            XCubicCurve2D bezier = new XCubicCurve2D(x, y, p.x1, p.y1, p.x2, p.y2, p.x, p.y);
            beziers.add(bezier);
            x = p.x;
            y = p.y;
        }
        return DotPath.fromBeziers(beziers);
    }

    public boolean isPathConsistent() {
        return this.getSvg().startsWith("M");
    }
}

