/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.xmi;

import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Stack;
import net.sourceforge.plantuml.sequencediagram.AbstractMessage;
import net.sourceforge.plantuml.sequencediagram.Event;
import net.sourceforge.plantuml.sequencediagram.Grouping;
import net.sourceforge.plantuml.sequencediagram.GroupingType;
import net.sourceforge.plantuml.sequencediagram.LifeEvent;
import net.sourceforge.plantuml.sequencediagram.LifeEventType;
import net.sourceforge.plantuml.sequencediagram.Message;
import net.sourceforge.plantuml.sequencediagram.MessageExo;
import net.sourceforge.plantuml.sequencediagram.Note;
import net.sourceforge.plantuml.sequencediagram.NotePosition;
import net.sourceforge.plantuml.sequencediagram.Participant;
import net.sourceforge.plantuml.sequencediagram.SequenceDiagram;
import net.sourceforge.plantuml.xmi.XmiSequenceDiagram;
import org.w3c.dom.Attr;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public class XmiSequenceDiagramStandard
extends XmiSequenceDiagram {
    private Stack<HashSet<String>> covered = new Stack();
    private HashMap<Participant, Stack<Element>> activeParticipants;

    public XmiSequenceDiagramStandard(SequenceDiagram diagram, Document document) {
        super(diagram, document);
        this.covered.push(new HashSet());
        this.activeParticipants = new HashMap();
    }

    @Override
    public void build() {
        Node packagedElement = this.document.appendChild(this.createElement("uml:Model", new String[][]{{"xmlns:uml", "http://www.omg.org/spec/UML/20110701"}, {"xmlns:xmi", "http://schema.omg.org/spec/XMI/2.1"}, {"xmi:version", "2.1"}, {"xmi:id", this.getXmiId("uml:Model", this.diagram)}})).appendChild(this.createUmlElement(this.diagram, "packagedElement", "Interaction"));
        packagedElement.appendChild(this.createUmlElement(this.diagram, "nestedClassifier", "Collaboration"));
        for (Participant participant : this.diagram.participants()) {
            packagedElement.appendChild(this.createElement(participant, "lifeline", new String[][]{{"name", this.getDisplayString(participant.getDisplay(false))}}));
        }
        Node currentFragment = packagedElement;
        for (Event event : this.diagram.events()) {
            if (event instanceof Note) {
                this.buildNoteEvent(packagedElement, (Note)event);
                continue;
            }
            if (event instanceof LifeEvent) {
                this.buildLifeEvent(packagedElement, (LifeEvent)event);
                continue;
            }
            if (event instanceof AbstractMessage) {
                this.buildMessage(packagedElement, currentFragment, (AbstractMessage)event);
                continue;
            }
            if (!(event instanceof Grouping)) continue;
            currentFragment = this.buildGrouping(currentFragment, (Grouping)event);
        }
    }

    private void buildLifeEvent(Node packagedElement, LifeEvent event) {
        if (event.getType() == LifeEventType.ACTIVATE) {
            Element execution = this.createUmlElement(event, "fragment", "BehaviorExecutionSpecification");
            execution.setAttribute("covered", this.getXmiId("lifeline", event.getParticipant()));
            execution.setAttribute("start", this.getLifeEventOccurrenceId(event));
            packagedElement.appendChild(execution);
            this.activeParticipants.putIfAbsent(event.getParticipant(), new Stack());
            this.activeParticipants.get(event.getParticipant()).push(execution);
        } else if (event.getType() == LifeEventType.DEACTIVATE) {
            this.activeParticipants.get(event.getParticipant()).pop().setAttribute("finish", this.getLifeEventOccurrenceId(event));
        }
    }

    private Participant getReceiver(AbstractMessage message) {
        MessageExo exo;
        if (message instanceof Message) {
            return message.getParticipant2();
        }
        if (message instanceof MessageExo && (exo = (MessageExo)message).getType().toString().startsWith("FROM_")) {
            return message.getParticipant1();
        }
        return null;
    }

    private String getLifeEventOccurrenceId(LifeEvent event) {
        if (event.getParticipant() == this.getReceiver(event.getMessage())) {
            return this.getXmiId("receiveEvent", event.getMessage());
        }
        return this.getXmiId("sendEvent", event.getMessage());
    }

    private void buildMessage(Node packagedElement, Node currentFragment, AbstractMessage message) {
        if (message instanceof Message) {
            this.buildMessage(packagedElement, currentFragment, (Message)message);
        } else if (message instanceof MessageExo) {
            this.buildMessageExo(packagedElement, currentFragment, (MessageExo)message);
        }
        if (message.getParticipant1() != null) {
            this.covered.peek().add(this.getXmiId("lifeline", message.getParticipant1()));
        }
        if (message.getParticipant2() != null) {
            this.covered.peek().add(this.getXmiId("lifeline", message.getParticipant2()));
        }
    }

    private void buildNoteEvent(Node packagedElement, Note note) {
        HashSet<String> annotated = new HashSet<String>();
        if (note.getParticipant() != null) {
            annotated.add(this.getXmiId("lifeline", note.getParticipant()));
        }
        if (note.getParticipant2() != null) {
            annotated.add(this.getXmiId("lifeline", note.getParticipant2()));
        }
        this.buildNote(packagedElement, note, annotated);
    }

    private HashSet<String> getAnnotatedElements(Note note, Message message) {
        int p2;
        NotePosition senderPosition;
        HashSet<String> annotated = new HashSet<String>();
        int p1 = this.getParticipantNumber(message.getParticipant1());
        NotePosition notePosition = senderPosition = p1 < (p2 = this.getParticipantNumber(message.getParticipant2())) ? NotePosition.LEFT : NotePosition.RIGHT;
        if (note.getPosition() == senderPosition) {
            annotated.add(this.getXmiId("sendEvent", message));
            annotated.add(this.getXmiId("lifeline", message.getParticipant1()));
        } else {
            annotated.add(this.getXmiId("receiveEvent", message));
            annotated.add(this.getXmiId("lifeline", message.getParticipant2()));
        }
        return annotated;
    }

    private void buildNote(Node packagedElement, Note note, HashSet<String> annotated) {
        Element comment = this.createUmlElement(note, "ownedComment", "Comment");
        if (!annotated.isEmpty()) {
            comment.setAttribute("annotatedElement", String.join((CharSequence)" ", annotated));
        }
        comment.appendChild(this.document.createElement("body")).appendChild(this.document.createTextNode(this.getDisplayString(note.getDisplay())));
        packagedElement.appendChild(comment);
    }

    private int getParticipantNumber(Participant participant) {
        return Arrays.asList(this.diagram.participants().toArray()).indexOf(participant);
    }

    private void buildMessageExo(Node packagedElement, Node currentFragment, MessageExo message) {
        String messageEvent = message.getType().toString().startsWith("TO_") ? "sendEvent" : "receiveEvent";
        String messageEventId = this.getXmiId(messageEvent, message);
        currentFragment.appendChild(this.createMessageOccurrence(message, messageEvent, message.getParticipant1()));
        packagedElement.appendChild(this.setAttributes(this.createUmlElement(message, "message", "Message"), new String[][]{{"name", this.getDisplayString(message.getLabel())}, {messageEvent, messageEventId}}));
        HashSet<String> annotated = new HashSet<String>();
        annotated.add(messageEventId);
        annotated.add(this.getXmiId("lifeline", message.getParticipant1()));
        for (Note note : message.getNoteOnMessages()) {
            this.buildNote(packagedElement, note, annotated);
        }
    }

    private void buildMessage(Node packagedElement, Node currentFragment, Message message) {
        currentFragment.appendChild(this.createMessageOccurrence(message, "sendEvent", message.getParticipant1()));
        currentFragment.appendChild(this.createMessageOccurrence(message, "receiveEvent", message.getParticipant2()));
        packagedElement.appendChild(this.setAttributes(this.createUmlElement(message, "message", "Message"), new String[][]{{"name", this.getDisplayString(message.getLabel())}, {"receiveEvent", this.getXmiId("receiveEvent", message)}, {"sendEvent", this.getXmiId("sendEvent", message)}}));
        for (Note note : message.getNoteOnMessages()) {
            this.buildNote(packagedElement, note, this.getAnnotatedElements(note, message));
        }
    }

    private Node buildGrouping(Node currentFragment, Grouping grouping) {
        if (grouping.getType() == GroupingType.START) {
            Element group = this.createUmlElement(grouping, "fragment", "CombinedFragment");
            group.setAttribute("interactionOperator", grouping.getTitle());
            currentFragment.appendChild(group);
            currentFragment = group.appendChild(this.createElement(grouping, "operand"));
            currentFragment.appendChild(this.createGuardElement(grouping));
            this.covered.push(new HashSet());
        } else if (grouping.getType() == GroupingType.ELSE) {
            currentFragment = currentFragment.getParentNode().appendChild(this.createElement(grouping, "operand"));
            currentFragment.appendChild(this.createGuardElement(grouping));
        } else if (grouping.getType() == GroupingType.END) {
            Attr coveredAttr = this.document.createAttribute("covered");
            HashSet<String> topCovered = this.covered.pop();
            coveredAttr.setTextContent(String.join((CharSequence)" ", topCovered));
            currentFragment.getParentNode().getAttributes().setNamedItem(coveredAttr);
            this.covered.peek().addAll(topCovered);
            currentFragment = currentFragment.getParentNode().getParentNode();
        }
        return currentFragment;
    }

    private Node createGuardElement(Grouping grouping) {
        Element guard = this.createElement(grouping, "guard");
        guard.appendChild(this.setAttribute(this.createUmlElement(grouping, "specification", "LiteralString"), "value", grouping.getComment()));
        return guard;
    }

    private Element createElement(Object object, String tag) {
        return this.createElement(tag, new String[][]{{"xmi:id", this.getXmiId(tag, object)}});
    }

    private Element createElement(Object object, String tag, String[][] attributes) {
        return this.setAttributes(this.createElement(tag, new String[][]{{"xmi:id", this.getXmiId(tag, object)}}), attributes);
    }

    private Element createUmlElement(Object object, String tag, String type) {
        return this.createElement(tag, new String[][]{{"xmi:type", "uml:" + type}, {"xmi:id", this.getXmiId(type, object)}});
    }

    private Node createMessageOccurrence(Object event, String type, Participant participant) {
        return this.setAttributes(this.createUmlElement(event, "fragment", "MessageOccurrenceSpecification"), new String[][]{{"xmi:id", this.getXmiId(type, event)}, {"covered", this.getXmiId("lifeline", participant)}, {"message", this.getXmiId("Message", event)}});
    }
}

