/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.zopfli;

import net.sourceforge.plantuml.zopfli.Cookie;
import net.sourceforge.plantuml.zopfli.Deflate;
import net.sourceforge.plantuml.zopfli.LzStore;

class BlockSplitter {
    BlockSplitter() {
    }

    static int split(Cookie cookie, byte[] input, int from, int to) {
        LzStore store = cookie.store1;
        store.reset();
        Deflate.greedy(cookie, null, input, from, to, store);
        int nPoints = BlockSplitter.splitLz(cookie, store.litLens, store.dists, store.size);
        int pos = from;
        char[] dists = store.dists;
        char[] litLens = store.litLens;
        int[] points = cookie.splitPoints;
        points[0] = pos;
        int i = 0;
        for (int j = 1; j <= nPoints; ++j) {
            int pj = points[j];
            while (i < pj) {
                pos += dists[i] == '\u0000' ? 1 : litLens[i];
                ++i;
            }
            points[j] = pos;
        }
        return nPoints;
    }

    static int splitLz(Cookie cookie, char[] litLens, char[] dists, int llSize) {
        int[] splitPoints = cookie.splitPoints;
        int[] splitSize = cookie.splitSize;
        splitPoints[0] = 0;
        splitSize[0] = Deflate.calculateBlockSize(cookie, litLens, dists, 0, llSize);
        splitPoints[1] = llSize;
        splitSize[1] = -1;
        int numBlocks = 1;
        int maxBlocks = cookie.blockSplittingMax;
        if (llSize < 10) {
            return numBlocks;
        }
        int lStart = 0;
        int lEnd = llSize;
        int blockN = 0;
        while (numBlocks < maxBlocks) {
            int splitR;
            int llPos = BlockSplitter.findMinimum(cookie, litLens, dists, lStart, lEnd);
            int splitL = Deflate.calculateBlockSize(cookie, litLens, dists, lStart, llPos);
            if (splitL + (splitR = Deflate.calculateBlockSize(cookie, litLens, dists, llPos, lEnd)) > splitSize[blockN] || llPos == lStart + 1 || llPos == lEnd) {
                splitSize[blockN] = -1;
            } else {
                splitSize[blockN] = splitL;
                System.arraycopy(splitPoints, ++blockN, splitPoints, blockN + 1, ++numBlocks - blockN);
                System.arraycopy(splitSize, blockN, splitSize, blockN + 1, numBlocks - blockN);
                splitPoints[blockN] = llPos;
                splitSize[blockN] = splitR;
            }
            int longest = 0;
            boolean found = false;
            for (int i = 0; i < numBlocks; ++i) {
                int start = splitPoints[i];
                int end = splitPoints[i + 1];
                if (splitSize[i] == -1 || end - start <= longest) continue;
                lStart = start;
                lEnd = end;
                found = true;
                longest = end - start;
                blockN = i;
            }
            if (found && lEnd - lStart >= 10) continue;
            break;
        }
        return numBlocks;
    }

    private static int findMinimum(Cookie cookie, char[] litLens, char[] dists, int from, int to) {
        int end = to;
        int start = from + 1;
        if (end - start < 1024) {
            int best = Integer.MAX_VALUE;
            int result = start;
            for (int i = start; i < end; ++i) {
                int v = Deflate.calculateBlockSize(cookie, litLens, dists, from, i) + Deflate.calculateBlockSize(cookie, litLens, dists, i, to);
                if (v >= best) continue;
                best = v;
                result = i;
            }
            return result;
        }
        int n = 9;
        int[] p = cookie.p;
        int[] vp = cookie.vp;
        int lastBest = Integer.MAX_VALUE;
        int pos = start;
        while (end - start > n) {
            for (int i = 0; i < n; ++i) {
                p[i] = start + (i + 1) * ((end - start) / (n + 1));
                vp[i] = Deflate.calculateBlockSize(cookie, litLens, dists, from, p[i]) + Deflate.calculateBlockSize(cookie, litLens, dists, p[i], to);
            }
            int bestI = 0;
            int best = vp[0];
            for (int i = 1; i < n; ++i) {
                if (vp[i] >= best) continue;
                best = vp[i];
                bestI = i;
            }
            if (best > lastBest) break;
            start = bestI == 0 ? start : p[bestI - 1];
            end = bestI == n - 1 ? end : p[bestI + 1];
            pos = p[bestI];
            lastBest = best;
        }
        return pos;
    }
}

