/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.common.nodespacing.internal.algorithm;

import org.eclipse.elk.alg.common.nodespacing.cellsystem.StripContainerCell;
import org.eclipse.elk.alg.common.nodespacing.internal.NodeContext;
import org.eclipse.elk.core.math.ElkRectangle;
import org.eclipse.elk.core.math.KVector;
import org.eclipse.elk.core.options.PortSide;
import org.eclipse.elk.core.options.SizeOptions;

public final class LabelPlacer {
    private LabelPlacer() {
    }

    public static void placeLabels(NodeContext nodeContext) {
        LabelPlacer.placeOuterNodeLabelContainers(nodeContext);
        nodeContext.nodeLabelCells.values().stream().forEach(labelCell -> labelCell.applyLabelLayout());
        nodeContext.portContexts.values().stream().filter(portContext -> portContext.portLabelCell != null).forEach(portContext -> portContext.portLabelCell.applyLabelLayout());
    }

    private static void placeOuterNodeLabelContainers(NodeContext nodeContext) {
        boolean outerNodeLabelsOverhang = nodeContext.sizeOptions.contains((Object)SizeOptions.OUTSIDE_NODE_LABELS_OVERHANG);
        LabelPlacer.placeHorizontalOuterNodeLabelContainer(nodeContext, outerNodeLabelsOverhang, PortSide.NORTH);
        LabelPlacer.placeHorizontalOuterNodeLabelContainer(nodeContext, outerNodeLabelsOverhang, PortSide.SOUTH);
        LabelPlacer.placeVerticalOuterNodeLabelContainer(nodeContext, outerNodeLabelsOverhang, PortSide.EAST);
        LabelPlacer.placeVerticalOuterNodeLabelContainer(nodeContext, outerNodeLabelsOverhang, PortSide.WEST);
    }

    private static void placeHorizontalOuterNodeLabelContainer(NodeContext nodeContext, boolean outerNodeLabelsOverhang, PortSide portSide) {
        KVector nodeSize = nodeContext.nodeSize;
        StripContainerCell nodeLabelContainer = nodeContext.outsideNodeLabelContainers.get((Object)portSide);
        ElkRectangle nodeLabelContainerRect = nodeLabelContainer.getCellRectangle();
        nodeLabelContainerRect.width = nodeLabelContainer.getMinimumWidth();
        nodeLabelContainerRect.height = nodeLabelContainer.getMinimumHeight();
        nodeLabelContainerRect.width = Math.max(nodeLabelContainerRect.width, nodeSize.x);
        if (nodeLabelContainerRect.width > nodeSize.x && !outerNodeLabelsOverhang) {
            nodeLabelContainerRect.width = nodeSize.x;
        }
        nodeLabelContainerRect.x = -(nodeLabelContainerRect.width - nodeSize.x) / 2.0;
        switch (portSide) {
            case NORTH: {
                nodeLabelContainerRect.y = -nodeLabelContainerRect.height;
                break;
            }
            case SOUTH: {
                nodeLabelContainerRect.y = nodeSize.y;
            }
        }
        nodeLabelContainer.layoutChildrenHorizontally();
        nodeLabelContainer.layoutChildrenVertically();
    }

    private static void placeVerticalOuterNodeLabelContainer(NodeContext nodeContext, boolean outerNodeLabelsOverhang, PortSide portSide) {
        KVector nodeSize = nodeContext.nodeSize;
        StripContainerCell nodeLabelContainer = nodeContext.outsideNodeLabelContainers.get((Object)portSide);
        ElkRectangle nodeLabelContainerRect = nodeLabelContainer.getCellRectangle();
        nodeLabelContainerRect.width = nodeLabelContainer.getMinimumWidth();
        nodeLabelContainerRect.height = nodeLabelContainer.getMinimumHeight();
        nodeLabelContainerRect.height = Math.max(nodeLabelContainerRect.height, nodeSize.y);
        if (nodeLabelContainerRect.height > nodeSize.y && !outerNodeLabelsOverhang) {
            nodeLabelContainerRect.height = nodeSize.y;
        }
        nodeLabelContainerRect.y = -(nodeLabelContainerRect.height - nodeSize.y) / 2.0;
        switch (portSide) {
            case WEST: {
                nodeLabelContainerRect.x = -nodeLabelContainerRect.width;
                break;
            }
            case EAST: {
                nodeLabelContainerRect.x = nodeSize.x;
            }
        }
        nodeLabelContainer.layoutChildrenHorizontally();
        nodeLabelContainer.layoutChildrenVertically();
    }
}

