/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.components;

import com.google.common.collect.ArrayListMultimap;
import com.google.common.collect.HashMultimap;
import com.google.common.collect.Multimap;
import java.util.Collection;
import java.util.Set;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.core.options.PortSide;

public class ComponentGroup {
    protected static final Multimap<Set<PortSide>, Set<PortSide>> CONSTRAINTS = HashMultimap.create();
    protected Multimap<Set<PortSide>, LGraph> components = ArrayListMultimap.create();

    static {
        CONSTRAINTS.put(PortSide.SIDES_NONE, PortSide.SIDES_NORTH_EAST_SOUTH_WEST);
        CONSTRAINTS.put(PortSide.SIDES_WEST, PortSide.SIDES_NORTH_EAST_SOUTH_WEST);
        CONSTRAINTS.put(PortSide.SIDES_WEST, PortSide.SIDES_NORTH_SOUTH_WEST);
        CONSTRAINTS.put(PortSide.SIDES_EAST, PortSide.SIDES_NORTH_EAST_SOUTH);
        CONSTRAINTS.put(PortSide.SIDES_EAST, PortSide.SIDES_NORTH_EAST_SOUTH_WEST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH, PortSide.SIDES_NORTH_EAST_SOUTH_WEST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH, PortSide.SIDES_NORTH_EAST_WEST);
        CONSTRAINTS.put(PortSide.SIDES_SOUTH, PortSide.SIDES_EAST_SOUTH_WEST);
        CONSTRAINTS.put(PortSide.SIDES_SOUTH, PortSide.SIDES_NORTH_EAST_SOUTH_WEST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_SOUTH, PortSide.SIDES_EAST_WEST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_SOUTH, PortSide.SIDES_NORTH_EAST_SOUTH_WEST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_SOUTH, PortSide.SIDES_NORTH_EAST_WEST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_SOUTH, PortSide.SIDES_EAST_SOUTH_WEST);
        CONSTRAINTS.put(PortSide.SIDES_EAST_WEST, PortSide.SIDES_NORTH_SOUTH);
        CONSTRAINTS.put(PortSide.SIDES_EAST_WEST, PortSide.SIDES_NORTH_SOUTH_WEST);
        CONSTRAINTS.put(PortSide.SIDES_EAST_WEST, PortSide.SIDES_NORTH_EAST_SOUTH);
        CONSTRAINTS.put(PortSide.SIDES_EAST_WEST, PortSide.SIDES_NORTH_EAST_SOUTH_WEST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_WEST, PortSide.SIDES_NORTH_WEST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_WEST, PortSide.SIDES_NORTH_EAST_WEST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_WEST, PortSide.SIDES_NORTH_SOUTH_WEST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST, PortSide.SIDES_NORTH_EAST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST, PortSide.SIDES_NORTH_EAST_WEST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST, PortSide.SIDES_NORTH_EAST_SOUTH);
        CONSTRAINTS.put(PortSide.SIDES_SOUTH_WEST, PortSide.SIDES_SOUTH_WEST);
        CONSTRAINTS.put(PortSide.SIDES_SOUTH_WEST, PortSide.SIDES_EAST_SOUTH_WEST);
        CONSTRAINTS.put(PortSide.SIDES_SOUTH_WEST, PortSide.SIDES_NORTH_SOUTH_WEST);
        CONSTRAINTS.put(PortSide.SIDES_EAST_SOUTH, PortSide.SIDES_EAST_SOUTH);
        CONSTRAINTS.put(PortSide.SIDES_EAST_SOUTH, PortSide.SIDES_EAST_SOUTH_WEST);
        CONSTRAINTS.put(PortSide.SIDES_EAST_SOUTH, PortSide.SIDES_NORTH_EAST_SOUTH);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_WEST, PortSide.SIDES_NORTH);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_WEST, PortSide.SIDES_NORTH_SOUTH);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_WEST, PortSide.SIDES_NORTH_WEST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_WEST, PortSide.SIDES_NORTH_EAST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_WEST, PortSide.SIDES_NORTH_EAST_SOUTH_WEST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_WEST, PortSide.SIDES_NORTH_EAST_WEST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_WEST, PortSide.SIDES_NORTH_SOUTH_WEST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_WEST, PortSide.SIDES_NORTH_EAST_SOUTH);
        CONSTRAINTS.put(PortSide.SIDES_EAST_SOUTH_WEST, PortSide.SIDES_SOUTH);
        CONSTRAINTS.put(PortSide.SIDES_EAST_SOUTH_WEST, PortSide.SIDES_NORTH_SOUTH);
        CONSTRAINTS.put(PortSide.SIDES_EAST_SOUTH_WEST, PortSide.SIDES_SOUTH_WEST);
        CONSTRAINTS.put(PortSide.SIDES_EAST_SOUTH_WEST, PortSide.SIDES_EAST_SOUTH);
        CONSTRAINTS.put(PortSide.SIDES_EAST_SOUTH_WEST, PortSide.SIDES_EAST_SOUTH_WEST);
        CONSTRAINTS.put(PortSide.SIDES_EAST_SOUTH_WEST, PortSide.SIDES_NORTH_SOUTH_WEST);
        CONSTRAINTS.put(PortSide.SIDES_EAST_SOUTH_WEST, PortSide.SIDES_NORTH_EAST_SOUTH);
        CONSTRAINTS.put(PortSide.SIDES_EAST_SOUTH_WEST, PortSide.SIDES_NORTH_EAST_SOUTH_WEST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_SOUTH_WEST, PortSide.SIDES_WEST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_SOUTH_WEST, PortSide.SIDES_EAST_WEST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_SOUTH_WEST, PortSide.SIDES_NORTH_WEST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_SOUTH_WEST, PortSide.SIDES_SOUTH_WEST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_SOUTH_WEST, PortSide.SIDES_NORTH_EAST_WEST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_SOUTH_WEST, PortSide.SIDES_EAST_SOUTH_WEST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_SOUTH_WEST, PortSide.SIDES_NORTH_SOUTH_WEST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_SOUTH_WEST, PortSide.SIDES_NORTH_EAST_SOUTH_WEST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_SOUTH, PortSide.SIDES_EAST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_SOUTH, PortSide.SIDES_EAST_WEST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_SOUTH, PortSide.SIDES_NORTH_EAST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_SOUTH, PortSide.SIDES_EAST_SOUTH);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_SOUTH, PortSide.SIDES_NORTH_EAST_WEST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_SOUTH, PortSide.SIDES_EAST_SOUTH_WEST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_SOUTH, PortSide.SIDES_NORTH_EAST_SOUTH);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_SOUTH, PortSide.SIDES_NORTH_EAST_SOUTH_WEST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_SOUTH_WEST, PortSide.SIDES_NONE);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_SOUTH_WEST, PortSide.SIDES_WEST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_SOUTH_WEST, PortSide.SIDES_EAST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_SOUTH_WEST, PortSide.SIDES_NORTH);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_SOUTH_WEST, PortSide.SIDES_SOUTH);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_SOUTH_WEST, PortSide.SIDES_NORTH_SOUTH);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_SOUTH_WEST, PortSide.SIDES_EAST_WEST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_SOUTH_WEST, PortSide.SIDES_NORTH_EAST_WEST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_SOUTH_WEST, PortSide.SIDES_EAST_SOUTH_WEST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_SOUTH_WEST, PortSide.SIDES_NORTH_SOUTH_WEST);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_SOUTH_WEST, PortSide.SIDES_NORTH_EAST_SOUTH);
        CONSTRAINTS.put(PortSide.SIDES_NORTH_EAST_SOUTH_WEST, PortSide.SIDES_NORTH_EAST_SOUTH_WEST);
    }

    public ComponentGroup() {
    }

    public ComponentGroup(LGraph component) {
        this.add(component);
    }

    public boolean add(LGraph component) {
        if (this.canAdd(component)) {
            this.components.put(component.getProperty(InternalProperties.EXT_PORT_CONNECTIONS), component);
            return true;
        }
        return false;
    }

    protected boolean canAdd(LGraph component) {
        Set<PortSide> candidateSides = component.getProperty(InternalProperties.EXT_PORT_CONNECTIONS);
        Collection<Set<PortSide>> constraints = CONSTRAINTS.get(candidateSides);
        for (Set<PortSide> constraint : constraints) {
            if (this.components.get(constraint).isEmpty()) continue;
            return false;
        }
        return true;
    }

    public Collection<Set<PortSide>> getPortSides() {
        return this.components.keys();
    }

    public Collection<LGraph> getComponents() {
        return this.components.values();
    }

    public Collection<LGraph> getComponents(Set<PortSide> connections) {
        return this.components.get(connections);
    }
}

