/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate;

import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.intermediate.loops.SelfLoopHolder;
import org.eclipse.elk.alg.layered.intermediate.loops.ordering.PortRestorer;
import org.eclipse.elk.alg.layered.intermediate.loops.ordering.PortSideAssigner;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class SelfLoopPortRestorer
implements ILayoutProcessor<LGraph> {
    private final PortSideAssigner portSideAssigner = new PortSideAssigner();
    private final PortRestorer portRestorer = new PortRestorer();

    @Override
    public void process(LGraph graph, IElkProgressMonitor progressMonitor) {
        progressMonitor.begin("Self-Loop ordering", 1.0f);
        graph.getLayers().stream().flatMap(layer -> layer.getNodes().stream()).filter(lNode -> lNode.getType() == LNode.NodeType.NORMAL).filter(lNode -> lNode.hasProperty(InternalProperties.SELF_LOOP_HOLDER)).map(lNode -> lNode.getProperty(InternalProperties.SELF_LOOP_HOLDER)).forEach(slHolder -> this.processNode((SelfLoopHolder)slHolder, progressMonitor));
        progressMonitor.done();
    }

    private void processNode(SelfLoopHolder slHolder, IElkProgressMonitor monitor) {
        block6: {
            block5: {
                if (!slHolder.arePortsHidden()) break block5;
                switch (slHolder.getLNode().getProperty(InternalProperties.ORIGINAL_PORT_CONSTRAINTS)) {
                    case UNDEFINED: 
                    case FREE: {
                        this.portSideAssigner.assignPortSides(slHolder);
                    }
                    case FIXED_SIDE: {
                        this.computeSelfLoopTypes(slHolder);
                        this.portRestorer.restorePorts(slHolder, monitor);
                        break block6;
                    }
                    default: {
                        assert (false);
                        break block6;
                    }
                }
            }
            this.computeSelfLoopTypes(slHolder);
        }
    }

    private void computeSelfLoopTypes(SelfLoopHolder slHolder) {
        slHolder.getSLHyperLoops().stream().forEach(slLoop -> slLoop.computePortsPerSide());
    }
}

