/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.intermediate.compaction;

import java.util.Collections;
import org.eclipse.elk.alg.common.compaction.oned.CNode;
import org.eclipse.elk.alg.common.compaction.oned.ICompactionAlgorithm;
import org.eclipse.elk.alg.common.compaction.oned.ISpacingsHandler;
import org.eclipse.elk.alg.common.compaction.oned.OneDimensionalCompactor;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.intermediate.compaction.EdgeAwareScanlineConstraintCalculation;
import org.eclipse.elk.alg.layered.intermediate.compaction.LGraphToCGraphTransformer;
import org.eclipse.elk.alg.layered.intermediate.compaction.NetworkSimplexCompaction;
import org.eclipse.elk.alg.layered.intermediate.compaction.VerticalSegment;
import org.eclipse.elk.alg.layered.options.GraphCompactionStrategy;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.alg.layered.options.Spacings;
import org.eclipse.elk.core.alg.ILayoutProcessor;
import org.eclipse.elk.core.options.Direction;
import org.eclipse.elk.core.util.IElkProgressMonitor;

public class HorizontalGraphCompactor
implements ILayoutProcessor<LGraph> {
    public static final ICompactionAlgorithm NETWORK_SIMPLEX_COMPACTION = new NetworkSimplexCompaction();
    private LGraph lGraph;
    private final ISpacingsHandler specialSpacingsHandler = new ISpacingsHandler(){

        @Override
        public double getHorizontalSpacing(CNode cNode1, CNode cNode2) {
            if (HorizontalGraphCompactor.isVerticalSegmentsOfSameEdge(cNode1, cNode2)) {
                return 0.0;
            }
            LNode node1 = HorizontalGraphCompactor.getLNodeOrNull(cNode1);
            LNode node2 = HorizontalGraphCompactor.getLNodeOrNull(cNode2);
            if (node1 != null && node1.getType() == LNode.NodeType.EXTERNAL_PORT || node2 != null && node2.getType() == LNode.NodeType.EXTERNAL_PORT) {
                return 0.0;
            }
            Spacings spacings = HorizontalGraphCompactor.this.lGraph.getProperty(InternalProperties.SPACINGS);
            return spacings.getHorizontalSpacing(node1 != null ? node1.getType() : LNode.NodeType.LONG_EDGE, node2 != null ? node2.getType() : LNode.NodeType.LONG_EDGE);
        }

        @Override
        public double getVerticalSpacing(CNode cNode1, CNode cNode2) {
            if (HorizontalGraphCompactor.isVerticalSegmentsOfSameEdge(cNode1, cNode2)) {
                return 1.0;
            }
            LNode node1 = HorizontalGraphCompactor.getLNodeOrNull(cNode1);
            LNode node2 = HorizontalGraphCompactor.getLNodeOrNull(cNode2);
            Spacings spacings = HorizontalGraphCompactor.this.lGraph.getProperty(InternalProperties.SPACINGS);
            return spacings.getVerticalSpacing(node1 != null ? node1.getType() : LNode.NodeType.LONG_EDGE, node2 != null ? node2.getType() : LNode.NodeType.LONG_EDGE);
        }
    };

    @Override
    public void process(LGraph layeredGraph, IElkProgressMonitor progressMonitor) {
        GraphCompactionStrategy strategy = layeredGraph.getProperty(LayeredOptions.COMPACTION_POST_COMPACTION_STRATEGY);
        if (strategy == GraphCompactionStrategy.NONE) {
            return;
        }
        progressMonitor.begin("Horizontal Compaction", 1.0f);
        this.lGraph = layeredGraph;
        LGraphToCGraphTransformer transformer = new LGraphToCGraphTransformer();
        OneDimensionalCompactor odc = new OneDimensionalCompactor(transformer.transform(layeredGraph));
        odc.setSpacingsHandler(this.specialSpacingsHandler);
        switch (layeredGraph.getProperty(LayeredOptions.COMPACTION_POST_COMPACTION_CONSTRAINTS)) {
            case SCANLINE: {
                odc.setConstraintAlgorithm(new EdgeAwareScanlineConstraintCalculation(this.lGraph));
                break;
            }
            default: {
                odc.setConstraintAlgorithm(OneDimensionalCompactor.QUADRATIC_CONSTRAINTS);
            }
        }
        switch (strategy) {
            case LEFT: {
                odc.compact();
                break;
            }
            case RIGHT: {
                odc.changeDirection(Direction.RIGHT).compact();
                break;
            }
            case LEFT_RIGHT_CONSTRAINT_LOCKING: {
                odc.compact().changeDirection(Direction.RIGHT).setLockFunction((node, dir) -> node.cGroup.outDegreeReal == 0).compact();
                break;
            }
            case LEFT_RIGHT_CONNECTION_LOCKING: {
                odc.compact().changeDirection(Direction.RIGHT).setLockFunction((node, dir) -> transformer.getLockMap().get(node).get(dir)).compact();
                break;
            }
            case EDGE_LENGTH: {
                odc.setCompactionAlgorithm(NETWORK_SIMPLEX_COMPACTION).compact();
                break;
            }
        }
        odc.finish();
        transformer.applyLayout();
        progressMonitor.done();
    }

    public static boolean isVerticalSegmentsOfSameEdge(CNode cNode1, CNode cNode2) {
        VerticalSegment v1 = HorizontalGraphCompactor.getVerticalSegmentOrNull(cNode1);
        VerticalSegment v2 = HorizontalGraphCompactor.getVerticalSegmentOrNull(cNode2);
        return v1 != null && v2 != null && !Collections.disjoint(v1.representedLEdges, v2.representedLEdges);
    }

    public static LNode getLNodeOrNull(CNode cNode) {
        if (cNode.origin instanceof LNode) {
            return (LNode)cNode.origin;
        }
        return null;
    }

    public static VerticalSegment getVerticalSegmentOrNull(CNode cNode) {
        if (cNode.origin instanceof VerticalSegment) {
            return (VerticalSegment)cNode.origin;
        }
        return null;
    }
}

