/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.elk.alg.layered.p3order;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.eclipse.elk.alg.layered.graph.LGraph;
import org.eclipse.elk.alg.layered.graph.LNode;
import org.eclipse.elk.alg.layered.graph.LPort;
import org.eclipse.elk.alg.layered.graph.Layer;
import org.eclipse.elk.alg.layered.intermediate.PortListSorter;
import org.eclipse.elk.alg.layered.options.InternalProperties;
import org.eclipse.elk.alg.layered.options.LayeredOptions;
import org.eclipse.elk.core.options.PortConstraints;
import org.eclipse.elk.core.options.PortSide;

class SweepCopy {
    private final LNode[][] nodeOrder;
    private final List<List<List<LPort>>> portOrders;

    SweepCopy(LNode[][] nodeOrderIn) {
        this.nodeOrder = this.deepCopy(nodeOrderIn);
        this.portOrders = new ArrayList<List<List<LPort>>>();
        LNode[][] lNodeArray = nodeOrderIn;
        int n = nodeOrderIn.length;
        int n2 = 0;
        while (n2 < n) {
            LNode[] lNodes = lNodeArray[n2];
            ArrayList<ArrayList<LPort>> layer = new ArrayList<ArrayList<LPort>>();
            this.portOrders.add(layer);
            LNode[] lNodeArray2 = lNodes;
            int n3 = lNodes.length;
            int n4 = 0;
            while (n4 < n3) {
                LNode node = lNodeArray2[n4];
                layer.add(new ArrayList<LPort>(node.getPorts()));
                ++n4;
            }
            ++n2;
        }
    }

    SweepCopy(SweepCopy sc) {
        this.nodeOrder = this.deepCopy(sc.nodeOrder);
        this.portOrders = new ArrayList<List<List<LPort>>>(sc.portOrders);
    }

    private LNode[][] deepCopy(LNode[][] currentlyBestNodeOrder) {
        if (currentlyBestNodeOrder == null) {
            return null;
        }
        LNode[][] result = new LNode[currentlyBestNodeOrder.length][];
        int i = 0;
        while (i < result.length) {
            result[i] = Arrays.copyOf(currentlyBestNodeOrder[i], currentlyBestNodeOrder[i].length);
            ++i;
        }
        return result;
    }

    public LNode[][] nodes() {
        return this.nodeOrder;
    }

    public void transferNodeAndPortOrdersToGraph(LGraph lGraph, boolean setPortContstraints) {
        ArrayList<LNode> northSouthPortDummies = Lists.newArrayList();
        HashSet<LNode> updatePortOrder = Sets.newHashSet();
        List<Layer> layers = lGraph.getLayers();
        int i = 0;
        while (i < layers.size()) {
            List<LNode> nodes = layers.get(i).getNodes();
            northSouthPortDummies.clear();
            int j = 0;
            while (j < nodes.size()) {
                LNode node = this.nodeOrder[i][j];
                node.id = j;
                if (node.getType() == LNode.NodeType.NORTH_SOUTH_PORT) {
                    northSouthPortDummies.add(node);
                }
                lGraph.getLayers().get(i).getNodes().set(j, node);
                node.getPorts().clear();
                node.getPorts().addAll((Collection<LPort>)this.portOrders.get(i).get(j));
                if (setPortContstraints && !node.getProperty(LayeredOptions.PORT_CONSTRAINTS).isOrderFixed()) {
                    node.setProperty(LayeredOptions.PORT_CONSTRAINTS, (Object)PortConstraints.FIXED_ORDER);
                }
                ++j;
            }
            for (LNode dummy : northSouthPortDummies) {
                LNode origin = this.assertCorrectPortSides(dummy);
                updatePortOrder.add(origin);
                updatePortOrder.add(dummy);
            }
            ++i;
        }
        for (LNode node : updatePortOrder) {
            Collections.sort(node.getPorts(), PortListSorter.CMP_COMBINED);
            node.cachePortSides();
        }
    }

    private LNode assertCorrectPortSides(LNode dummy) {
        assert (dummy.getType() == LNode.NodeType.NORTH_SOUTH_PORT);
        LNode origin = dummy.getProperty(InternalProperties.IN_LAYER_LAYOUT_UNIT);
        List<LPort> dummyPorts = dummy.getPorts();
        LPort dummyPort = dummyPorts.get(0);
        for (LPort port : origin.getPorts()) {
            if (!port.equals(dummyPort.getProperty(InternalProperties.ORIGIN))) continue;
            if (port.getSide() == PortSide.NORTH && dummy.id > origin.id) {
                port.setSide(PortSide.SOUTH);
                if (!port.isExplicitlySuppliedPortAnchor()) break;
                double portHeight = port.getSize().y;
                double anchorY = port.getAnchor().y;
                port.getAnchor().y = portHeight - anchorY;
                break;
            }
            if (port.getSide() != PortSide.SOUTH || origin.id <= dummy.id) break;
            port.setSide(PortSide.NORTH);
            if (!port.isExplicitlySuppliedPortAnchor()) break;
            double portHeight = port.getSize().y;
            double anchorY = port.getAnchor().y;
            port.getAnchor().y = -(portHeight - anchorY);
            break;
        }
        return origin;
    }
}

