
# 13 "parsing/g_prim.mlg"
 

open Names
open Libnames

open Procq.Prim

let local_make_qualid loc l id = make_qualid ~loc (DirPath.make l) id

let my_int_of_string ?loc s =
  try
    int_of_string s
  with Failure _ ->
    CErrors.user_err ?loc (Pp.str "This number is too large.")

let my_to_nat_string ?loc s =
  match NumTok.Unsigned.to_nat s with
  | Some n -> n
  | None ->
    CErrors.user_err ?loc Pp.(str "This number is not an integer.")

let test_pipe_closedcurly =
  let open Procq.Lookahead in
  to_entry "test_pipe_closedcurly" begin
    lk_kw "|" >> lk_kw "}" >> check_no_space
  end

let test_minus_nat =
  let open Procq.Lookahead in
  to_entry "test_minus_nat" begin
    lk_kw "-" >> lk_nat >> check_no_space
  end


# 38 "parsing/g_prim.ml"

let _ = let field = Procq.Entry.make "field"
        in
        let () =
  assert (Procq.Entry.is_empty preident) in
  let () =
  Procq.grammar_extend preident
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (None)))))
                            (fun s loc -> 
# 55 "parsing/g_prim.mlg"
                       s 
# 54 "parsing/g_prim.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty ident) in
  let () =
  Procq.grammar_extend ident
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (None)))))
                            (fun s loc -> 
# 58 "parsing/g_prim.mlg"
                       Id.of_string s 
# 67 "parsing/g_prim.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty pattern_ident) in
  let () =
  Procq.grammar_extend pattern_ident
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.token (Tok.PLEFTQMARK))))
                             ((Procq.Symbol.nterm ident)))
                            (fun id _ loc -> 
# 61 "parsing/g_prim.mlg"
                                   CAst.make ~loc id 
# 82 "parsing/g_prim.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty identref) in
  let () =
  Procq.grammar_extend identref
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm ident)))
                            (fun id loc -> 
# 64 "parsing/g_prim.mlg"
                        CAst.make ~loc id 
# 95 "parsing/g_prim.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty hyp) in
  let () =
  Procq.grammar_extend hyp
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm identref)))
                            (fun id loc -> 
# 67 "parsing/g_prim.mlg"
                           id 
# 108 "parsing/g_prim.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty field) in
  let () =
  Procq.grammar_extend field
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PFIELD (None)))))
                            (fun s loc -> 
# 70 "parsing/g_prim.mlg"
                       Id.of_string s 
# 121 "parsing/g_prim.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty fields) in
  let () =
  Procq.grammar_extend fields
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm field)))
                            (fun id loc -> 
# 74 "parsing/g_prim.mlg"
                        ([],id) 
# 134 "parsing/g_prim.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm field)))
                            ((Procq.Symbol.nterm fields)))
                           (fun f id loc -> 
# 73 "parsing/g_prim.mlg"
                                    let (l,id') = f in (l@[id],id') 
# 144 "parsing/g_prim.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty fullyqualid) in
  let () =
  Procq.grammar_extend fullyqualid
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm ident)))
                            (fun id loc -> 
# 79 "parsing/g_prim.mlg"
                        CAst.make ~loc [id] 
# 157 "parsing/g_prim.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm ident)))
                            ((Procq.Symbol.nterm fields)))
                           (fun f id loc -> 
# 78 "parsing/g_prim.mlg"
                                  let (l,id') = f in CAst.make ~loc @@ id::List.rev (id'::l) 
# 167 "parsing/g_prim.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty name) in
  let () =
  Procq.grammar_extend name
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm ident)))
                            (fun id loc -> 
# 84 "parsing/g_prim.mlg"
                        CAst.make ~loc @@ Name id 
# 180 "parsing/g_prim.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some ("_"))))))
                           (fun _ loc -> 
# 83 "parsing/g_prim.mlg"
                        CAst.make ~loc Anonymous 
# 188 "parsing/g_prim.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty reference) in
  let () =
  Procq.grammar_extend reference
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm ident)))
                            (fun id loc -> 
# 90 "parsing/g_prim.mlg"
                        qualid_of_ident ~loc id 
# 201 "parsing/g_prim.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm ident)))
                            ((Procq.Symbol.nterm fields)))
                           (fun f id loc -> 
# 87 "parsing/g_prim.mlg"
                                   
        let (l,id') = f in
        local_make_qualid loc (l@[id]) id' 
# 213 "parsing/g_prim.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty qualid) in
  let () =
  Procq.grammar_extend qualid
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm reference)))
                            (fun qid loc -> 
# 94 "parsing/g_prim.mlg"
                             qid 
# 226 "parsing/g_prim.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty by_notation) in
  let () =
  Procq.grammar_extend by_notation
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm ne_string)))
                             ((Procq.Symbol.opt (Procq.Symbol.rules [Procq.Rules.make 
                                                                    (
                                                                    Procq.Rule.next_norec
                                                                    (
                                                                    Procq.Rule.next_norec
                                                                    (Procq.Rule.stop)
                                                                    ((Procq.Symbol.token (Tok.PKEYWORD ("%")))))
                                                                    ((Procq.Symbol.token (Tok.PIDENT (None)))))
                                                                    (fun key
                                                                    _ loc ->
                                                                    
# 97 "parsing/g_prim.mlg"
                                                       key 
# 250 "parsing/g_prim.ml"
)]))))
                            (fun sc s loc -> 
# 97 "parsing/g_prim.mlg"
                                                                    (s, sc) 
# 255 "parsing/g_prim.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty smart_global) in
  let () =
  Procq.grammar_extend smart_global
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm by_notation)))
                            (fun ntn loc -> 
# 101 "parsing/g_prim.mlg"
                               CAst.make ~loc @@ Constrexpr.ByNotation ntn 
# 268 "parsing/g_prim.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm reference)))
                           (fun c loc -> 
# 100 "parsing/g_prim.mlg"
                           CAst.make ~loc @@ Constrexpr.AN c 
# 276 "parsing/g_prim.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty ne_string) in
  let () =
  Procq.grammar_extend ne_string
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PSTRING (None)))))
                            (fun s loc -> 
# 105 "parsing/g_prim.mlg"
          if s="" then CErrors.user_err ~loc (Pp.str"Empty string."); s 
# 289 "parsing/g_prim.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty ne_lstring) in
  let () =
  Procq.grammar_extend ne_lstring
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm ne_string)))
                            (fun s loc -> 
# 109 "parsing/g_prim.mlg"
                           CAst.make ~loc s 
# 302 "parsing/g_prim.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty dirpath) in
  let () =
  Procq.grammar_extend dirpath
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next (Procq.Rule.stop)
                              ((Procq.Symbol.nterm ident)))
                             ((Procq.Symbol.list0 (Procq.Symbol.nterm field))))
                            (fun l id loc -> 
# 113 "parsing/g_prim.mlg"
          DirPath.make (List.rev (id::l)) 
# 317 "parsing/g_prim.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty string) in
  let () =
  Procq.grammar_extend string
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PSTRING (None)))))
                            (fun s loc -> 
# 116 "parsing/g_prim.mlg"
                        s 
# 330 "parsing/g_prim.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty lstring) in
  let () =
  Procq.grammar_extend lstring
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm string)))
                            (fun s loc -> 
# 119 "parsing/g_prim.mlg"
                        CAst.make ~loc s 
# 343 "parsing/g_prim.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty integer) in
  let () =
  Procq.grammar_extend integer
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm bigint)))
                            (fun i loc -> 
# 122 "parsing/g_prim.mlg"
                        my_int_of_string ~loc i 
# 356 "parsing/g_prim.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty natural) in
  let () =
  Procq.grammar_extend natural
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.nterm bignat)))
                            (fun i loc -> 
# 125 "parsing/g_prim.mlg"
                        my_int_of_string ~loc i 
# 369 "parsing/g_prim.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty bigint) in
  let () =
  Procq.grammar_extend bigint
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.nterm test_minus_nat)))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("-")))))
                             ((Procq.Symbol.nterm bignat)))
                            (fun i _ _ loc -> 
# 129 "parsing/g_prim.mlg"
                                             "-" ^ i 
# 386 "parsing/g_prim.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm bignat)))
                           (fun i loc -> 
# 128 "parsing/g_prim.mlg"
                        i 
# 394 "parsing/g_prim.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty bignat) in
  let () =
  Procq.grammar_extend bignat
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PNUMBER None))))
                            (fun i loc -> 
# 132 "parsing/g_prim.mlg"
                        my_to_nat_string ~loc i 
# 407 "parsing/g_prim.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty bar_cbrace) in
  let () =
  Procq.grammar_extend bar_cbrace
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next
                             (Procq.Rule.next
                              (Procq.Rule.next (Procq.Rule.stop)
                               ((Procq.Symbol.nterm test_pipe_closedcurly)))
                              ((Procq.Symbol.token (Tok.PKEYWORD ("|")))))
                             ((Procq.Symbol.token (Tok.PKEYWORD ("}")))))
                            (fun _ _ _ loc -> 
# 135 "parsing/g_prim.mlg"
                                             () 
# 424 "parsing/g_prim.ml"
)])]))
  in let () = assert (Procq.Entry.is_empty strategy_level) in
  let () =
  Procq.grammar_extend strategy_level
  (Procq.Fresh
  (Gramlib.Gramext.First, [(None, None,
                           [Procq.Production.make
                            (Procq.Rule.next (Procq.Rule.stop)
                             ((Procq.Symbol.token (Tok.PIDENT (Some
                             ("transparent"))))))
                            (fun _ loc -> 
# 141 "parsing/g_prim.mlg"
                                 Conv_oracle.transparent 
# 438 "parsing/g_prim.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.nterm integer)))
                           (fun n loc -> 
# 140 "parsing/g_prim.mlg"
                       Conv_oracle.Level n 
# 446 "parsing/g_prim.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("opaque"))))))
                           (fun _ loc -> 
# 139 "parsing/g_prim.mlg"
                            Conv_oracle.Opaque 
# 455 "parsing/g_prim.ml"
);
                           Procq.Production.make
                           (Procq.Rule.next (Procq.Rule.stop)
                            ((Procq.Symbol.token (Tok.PIDENT (Some
                            ("expand"))))))
                           (fun _ loc -> 
# 138 "parsing/g_prim.mlg"
                            Conv_oracle.Expand 
# 464 "parsing/g_prim.ml"
)])]))
  in ()

