/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot.internal.shaded.coursier.cache;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.FilenameFilter;
import java.io.InputStream;
import java.io.Serializable;
import java.math.BigInteger;
import java.nio.file.AccessDeniedException;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.NoSuchFileException;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.StandardCopyOption;
import java.security.MessageDigest;
import java.time.Clock;
import java.util.Locale;
import scala.$less$colon$less$;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.PartialFunction;
import scala.Predef$;
import scala.collection.ArrayOps$;
import scala.collection.StringOps$;
import scala.collection.immutable.Nil$;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ObjectRef;
import scala.util.Properties$;
import xsbt.boot.internal.shaded.coursier.cache.CacheDefaults$;
import xsbt.boot.internal.shaded.coursier.cache.CacheLogger$;
import xsbt.boot.internal.shaded.coursier.cache.FileCache;
import xsbt.boot.internal.shaded.coursier.cache.internal.FileUtil;
import xsbt.boot.internal.shaded.coursier.cache.internal.FileUtil$;
import xsbt.boot.internal.shaded.coursier.cache.internal.Retry;
import xsbt.boot.internal.shaded.coursier.paths.CachePath;
import xsbt.boot.internal.shaded.coursier.util.Sync;
import xsbt.boot.internal.shaded.coursier.util.Task;
import xsbt.boot.internal.shaded.coursier.util.Task$;

public final class FileCache$
implements Serializable {
    public static final FileCache$ MODULE$ = new FileCache$();

    /*
     * WARNING - void declaration
     */
    public final File localFile0(String url, File cache, Option<String> user, boolean localArtifactsShouldBeCached) {
        void var3_3;
        void var2_2;
        return CachePath.localFile(url, (File)var2_2, (String)var3_3.orNull($less$colon$less$.MODULE$.refl()), localArtifactsShouldBeCached);
    }

    /*
     * WARNING - void declaration
     */
    private String auxiliaryFilePrefix(File file) {
        void var1_1;
        return new StringBuilder(3).append(".").append(var1_1.getName()).append("__").toString();
    }

    /*
     * WARNING - void declaration
     */
    public final void clearAuxiliaryFiles(File file) {
        void var2_2;
        void var1_1;
        String prefix = this.auxiliaryFilePrefix(file);
        FilenameFilter filter = new FilenameFilter(prefix){
            private final String prefix$1;

            public final boolean accept(File dir, String name) {
                return name.startsWith(this.prefix$1);
            }
            {
                void var1_1;
                this.prefix$1 = var1_1;
            }
        };
        ArrayOps$.MODULE$.foreach$extension(Predef$.MODULE$.refArrayOps(var1_1.getParentFile().listFiles((FilenameFilter)var2_2)), (Function1<File, Object> & Serializable)f -> BoxesRunTime.boxToBoolean(f.delete()));
    }

    /*
     * WARNING - void declaration
     */
    public final File auxiliaryFile(File file, String key) {
        void var2_2;
        void var1_1;
        String key0 = StringOps$.MODULE$.filter$extension(Predef$.MODULE$.augmentString(key.toLowerCase(Locale.ROOT)), (Function1<Object, Object> & Serializable)x$21 -> BoxesRunTime.boxToBoolean(FileCache$.$anonfun$auxiliaryFile$1(BoxesRunTime.unboxToChar(x$21))));
        return new File(file.getParentFile(), new StringBuilder(0).append(this.auxiliaryFilePrefix((File)var1_1)).append((String)var2_2).toString());
    }

    /*
     * WARNING - void declaration
     */
    public final <F> FileCache<F> apply(Sync<F> S) {
        void var1_1;
        return this.apply(CacheDefaults$.MODULE$.location(), (Sync<F>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public final BigInteger coursier$cache$FileCache$$persistedDigest(File location, String sumType, File localFile, Retry retry) {
        void var1_3;
        byte[] byArray;
        String location12 = new StringBuilder(0).append(StringOps$.MODULE$.stripSuffix$extension(Predef$.MODULE$.augmentString(location.getCanonicalPath()), File.separator)).append(File.separator).toString();
        boolean location12 = localFile.getCanonicalPath().startsWith(location12);
        if (!location12) {
            byArray = this.computeDigest(sumType, localFile, retry);
        } else {
            File cacheFile = this.auxiliaryFile(localFile, new StringBuilder(9).append(sumType).append(".computed").toString());
            Path cacheFilePath = cacheFile.toPath();
            try {
                byArray = (byte[])retry.retry((Function0<byte[]> & Serializable)() -> Files.readAllBytes(cacheFilePath), (PartialFunction<Throwable, BoxedUnit>)((Object)new Serializable(){

                    /*
                     * WARNING - void declaration
                     */
                    public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                        void var1_1;
                        void var2_2;
                        A1 A1 = x1;
                        if (A1 instanceof AccessDeniedException && Properties$.MODULE$.isWin()) {
                            return (B1)BoxedUnit.UNIT;
                        }
                        return (B1)var2_2.apply(var1_1);
                    }

                    public final boolean isDefinedAt(Throwable x1) {
                        Throwable throwable = x1;
                        return throwable instanceof AccessDeniedException && Properties$.MODULE$.isWin();
                    }
                }));
            }
            catch (NoSuchFileException noSuchFileException) {
                void var2_4;
                void var3_6;
                byte[] bytes = this.computeDigest(sumType, (File)var3_6, retry);
                Path tmpFile = File.createTempFile(cacheFile.getName(), ".tmp", cacheFile.getParentFile()).toPath();
                try {
                    Files.write(tmpFile, bytes, new OpenOption[0]);
                    retry.retry((Function0<Object> & Serializable)() -> {
                        try {
                            void var1_1;
                            return Files.move(tmpFile, (Path)var1_1, StandardCopyOption.ATOMIC_MOVE);
                        }
                        catch (FileAlreadyExistsException fileAlreadyExistsException) {
                            return BoxedUnit.UNIT;
                        }
                    }, (PartialFunction<Throwable, BoxedUnit>)((Object)new Serializable(){

                        /*
                         * WARNING - void declaration
                         */
                        public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x2, Function1<A1, B1> function1) {
                            void var1_1;
                            void var2_2;
                            A1 A1 = x2;
                            if (A1 instanceof AccessDeniedException && Properties$.MODULE$.isWin()) {
                                return (B1)BoxedUnit.UNIT;
                            }
                            return (B1)var2_2.apply(var1_1);
                        }

                        public final boolean isDefinedAt(Throwable x2) {
                            Throwable throwable = x2;
                            return throwable instanceof AccessDeniedException && Properties$.MODULE$.isWin();
                        }
                    }));
                }
                finally {
                    Files.deleteIfExists(tmpFile);
                }
                byArray = var2_4;
            }
        }
        byte[] digested = byArray;
        return new BigInteger(1, (byte[])var1_3);
    }

    /*
     * WARNING - void declaration
     */
    private byte[] computeDigest(String sumType, File localFile, Retry retry) {
        void var1_1;
        MessageDigest md = MessageDigest.getInstance(sumType);
        ObjectRef<Object> is = ObjectRef.create(null);
        try {
            void var2_3;
            void var3_4;
            var3_4.retry(() -> FileCache$.$anonfun$computeDigest$1(is, (File)var2_3), (PartialFunction<Throwable, BoxedUnit>)((Object)new Serializable(){

                /*
                 * WARNING - void declaration
                 */
                public final <A1 extends Throwable, B1> B1 applyOrElse(A1 x1, Function1<A1, B1> function1) {
                    void var1_1;
                    void var2_2;
                    A1 A1 = x1;
                    if (A1 instanceof FileNotFoundException && Properties$.MODULE$.isWin()) {
                        return (B1)BoxedUnit.UNIT;
                    }
                    return (B1)var2_2.apply(var1_1);
                }

                public final boolean isDefinedAt(Throwable x1) {
                    Throwable throwable = x1;
                    return throwable instanceof FileNotFoundException && Properties$.MODULE$.isWin();
                }
            }));
            FileUtil$.MODULE$.withContent((InputStream)is.elem, new FileUtil.UpdateDigest(md), FileUtil$.MODULE$.withContent$default$3());
        }
        finally {
            if ((InputStream)is.elem != null) {
                ((InputStream)is.elem).close();
            }
        }
        return var1_1.digest();
    }

    /*
     * WARNING - void declaration
     */
    public final <F> FileCache<F> apply(File location, Sync<F> sync) {
        void var2_2;
        void var1_1;
        None$ none$ = None$.MODULE$;
        return new FileCache((File)var1_1, CacheDefaults$.MODULE$.cachePolicies(), CacheDefaults$.MODULE$.checksums(), CacheDefaults$.MODULE$.credentials(), CacheLogger$.MODULE$.nop(), CacheDefaults$.MODULE$.pool(), CacheDefaults$.MODULE$.ttl(), false, true, false, CacheDefaults$.MODULE$.maxRedirections(), CacheDefaults$.MODULE$.retryCount(), none$, none$, CacheDefaults$.MODULE$.retryCount(), CacheDefaults$.MODULE$.bufferSize(), Nil$.MODULE$, Clock.systemDefaultZone(), CacheDefaults$.MODULE$.retryBackoffInitialDelay(), CacheDefaults$.MODULE$.retryBackoffMultiplier(), var2_2);
    }

    public final <F> Sync<Task> apply$default$1() {
        return Task$.MODULE$.sync();
    }

    public static final /* synthetic */ boolean $anonfun$auxiliaryFile$1(char x$21) {
        return x$21 != '-';
    }

    /*
     * WARNING - void declaration
     */
    public static final /* synthetic */ void $anonfun$computeDigest$1(ObjectRef is$1, File localFile$1) {
        void var1_1;
        is$1.elem = Files.newInputStream(var1_1.toPath(), new OpenOption[0]);
    }

    private FileCache$() {
    }
}

