/*
 * Decompiled with CFR 0.152.
 */
package xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.stream.Stream;
import org.jspecify.annotations.Nullable;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.SerializationException;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.helper.Validate;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.internal.StringUtil;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.Attributes;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.Document;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.NodeUtils;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.nodes.TextNode;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.select.NodeTraversor;
import xsbt.boot.internal.shaded.coursier.util.shaded.org.jsoup.select.NodeVisitor;

public abstract class Node
implements Cloneable {
    static final List<Node> EmptyNodes = Collections.emptyList();
    @Nullable Node parentNode;
    int siblingIndex;

    protected Node() {
    }

    public abstract String nodeName();

    public String normalName() {
        return this.nodeName();
    }

    /*
     * WARNING - void declaration
     */
    public boolean nameIs(String normalName) {
        void var1_1;
        return this.normalName().equals(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean parentNameIs(String normalName) {
        void var1_1;
        return this.parentNode != null && this.parentNode.normalName().equals(var1_1);
    }

    protected abstract boolean hasAttributes();

    public boolean hasParent() {
        return this.parentNode != null;
    }

    /*
     * WARNING - void declaration
     */
    public String attr(String attributeKey) {
        Validate.notNull(attributeKey);
        if (!this.hasAttributes()) {
            return "";
        }
        String val = this.attributes().getIgnoreCase(attributeKey);
        if (val.length() > 0) {
            void var2_2;
            return var2_2;
        }
        if (attributeKey.startsWith("abs:")) {
            void var1_1;
            return this.absUrl(var1_1.substring(4));
        }
        return "";
    }

    public abstract Attributes attributes();

    /*
     * WARNING - void declaration
     */
    public Node attr(String attributeKey, String attributeValue) {
        void var2_2;
        void var1_1;
        attributeKey = NodeUtils.parser(this).settings().normalizeAttribute(attributeKey);
        this.attributes().putIgnoreCase((String)var1_1, (String)var2_2);
        return this;
    }

    /*
     * WARNING - void declaration
     */
    public boolean hasAttr(String attributeKey) {
        void var1_1;
        Validate.notNull(attributeKey);
        if (!this.hasAttributes()) {
            return false;
        }
        if (attributeKey.startsWith("abs:")) {
            void var2_2;
            String key = attributeKey.substring(4);
            if (this.attributes().hasKeyIgnoreCase(key) && !this.absUrl((String)var2_2).isEmpty()) {
                return true;
            }
        }
        return this.attributes().hasKeyIgnoreCase((String)var1_1);
    }

    public abstract String baseUri();

    protected abstract void doSetBaseUri(String var1);

    /*
     * WARNING - void declaration
     */
    public void setBaseUri(String baseUri) {
        void var1_1;
        Validate.notNull(baseUri);
        this.doSetBaseUri((String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public String absUrl(String attributeKey) {
        void var1_1;
        Validate.notEmpty(attributeKey);
        if (!this.hasAttributes() || !this.attributes().hasKeyIgnoreCase(attributeKey)) {
            return "";
        }
        return StringUtil.resolve(this.baseUri(), this.attributes().getIgnoreCase((String)var1_1));
    }

    protected abstract List<Node> ensureChildNodes();

    /*
     * WARNING - void declaration
     */
    public Node childNode(int index) {
        void var1_1;
        return this.ensureChildNodes().get((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public List<Node> childNodes() {
        void var2_2;
        void var1_1;
        if (this.childNodeSize() == 0) {
            return EmptyNodes;
        }
        List<Node> children = this.ensureChildNodes();
        ArrayList rewrap = new ArrayList(children.size());
        rewrap.addAll(var1_1);
        return Collections.unmodifiableList(var2_2);
    }

    public abstract int childNodeSize();

    public abstract Node empty();

    public @Nullable Node parent() {
        return this.parentNode;
    }

    public final @Nullable Node parentNode() {
        return this.parentNode;
    }

    /*
     * WARNING - void declaration
     */
    public Node root() {
        void var1_1;
        Node node = this;
        while (node.parentNode != null) {
            node = node.parentNode;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public @Nullable Document ownerDocument() {
        Node root = this.root();
        if (root instanceof Document) {
            void var1_1;
            return (Document)var1_1;
        }
        return null;
    }

    public void remove() {
        if (this.parentNode != null) {
            this.parentNode.removeChild(this);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Node before(Node node) {
        void var1_1;
        Validate.notNull(node);
        Validate.notNull(this.parentNode);
        if (node.parentNode == this.parentNode) {
            node.remove();
        }
        this.parentNode.addChildren(this.siblingIndex, new Node[]{var1_1});
        return this;
    }

    void nodelistChanged() {
    }

    /*
     * WARNING - void declaration
     */
    public void replaceWith(Node in) {
        void var1_1;
        Validate.notNull(in);
        Validate.notNull(this.parentNode);
        this.parentNode.replaceChild(this, (Node)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void setParentNode(Node parentNode) {
        void var1_1;
        Validate.notNull(parentNode);
        if (this.parentNode != null) {
            this.parentNode.removeChild(this);
        }
        this.parentNode = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected void replaceChild(Node out, Node in) {
        void var3_3;
        void var2_2;
        Validate.isTrue(out.parentNode == this);
        Validate.notNull(in);
        if (out == in) {
            return;
        }
        if (in.parentNode != null) {
            in.parentNode.removeChild(in);
        }
        int index = out.siblingIndex;
        this.ensureChildNodes().set(index, in);
        in.parentNode = this;
        var2_2.setSiblingIndex((int)var3_3);
        var1_1.parentNode = null;
    }

    /*
     * WARNING - void declaration
     */
    protected void removeChild(Node out) {
        void var2_2;
        Validate.isTrue(out.parentNode == this);
        int index = out.siblingIndex;
        this.ensureChildNodes().remove(index);
        this.reindexChildren((int)var2_2);
        var1_1.parentNode = null;
    }

    /*
     * WARNING - void declaration
     */
    protected void addChildren(int index, Node ... children) {
        void var1_1;
        void var2_2;
        void var3_3;
        Validate.notNull(children);
        if (children.length == 0) {
            return;
        }
        List<Node> nodes = this.ensureChildNodes();
        Node firstParent = children[0].parent();
        if (firstParent != null && firstParent.childNodeSize() == children.length) {
            boolean sameList = true;
            List<Node> firstParentNodes = firstParent.ensureChildNodes();
            int i = children.length;
            while (i-- > 0) {
                if (children[i] == firstParentNodes.get(i)) continue;
                sameList = false;
                break;
            }
            if (sameList) {
                boolean wasEmpty = this.childNodeSize() == 0;
                firstParent.empty();
                nodes.addAll(index, Arrays.asList(children));
                i = children.length;
                while (i-- > 0) {
                    children[i].parentNode = this;
                }
                if (!wasEmpty || children[0].siblingIndex != 0) {
                    this.reindexChildren(index);
                }
                return;
            }
        }
        Validate.noNullElements(children);
        Node[] nodeArray = children;
        int n = children.length;
        for (int i = 0; i < n; ++i) {
            Node child = nodeArray[i];
            this.reparentChild(child);
        }
        var3_3.addAll(index, Arrays.asList(var2_2));
        this.reindexChildren((int)var1_1);
    }

    protected void reparentChild(Node child) {
        child.setParentNode(this);
    }

    /*
     * WARNING - void declaration
     */
    private void reindexChildren(int start) {
        void i;
        int size = this.childNodeSize();
        if (size == 0) {
            return;
        }
        List<Node> childNodes = this.ensureChildNodes();
        while (i < size) {
            childNodes.get((int)i).setSiblingIndex((int)i);
            ++i;
        }
    }

    /*
     * WARNING - void declaration
     */
    public List<Node> siblingNodes() {
        void var2_2;
        Iterator iterator;
        if (this.parentNode == null) {
            return Collections.emptyList();
        }
        List<Node> nodes = this.parentNode.ensureChildNodes();
        ArrayList<void> siblings = new ArrayList<void>(nodes.size() - 1);
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            void var3_3;
            Node node = (Node)iterator.next();
            if (node == this) continue;
            siblings.add(var3_3);
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public @Nullable Node nextSibling() {
        if (this.parentNode == null) {
            return null;
        }
        List<Node> siblings = this.parentNode.ensureChildNodes();
        int index = this.siblingIndex + 1;
        if (siblings.size() > index) {
            void var2_2;
            void var1_1;
            return (Node)var1_1.get((int)var2_2);
        }
        return null;
    }

    public @Nullable Node previousSibling() {
        if (this.parentNode == null) {
            return null;
        }
        if (this.siblingIndex > 0) {
            return this.parentNode.ensureChildNodes().get(this.siblingIndex - 1);
        }
        return null;
    }

    public int siblingIndex() {
        return this.siblingIndex;
    }

    /*
     * WARNING - void declaration
     */
    protected void setSiblingIndex(int siblingIndex) {
        void var1_1;
        this.siblingIndex = var1_1;
    }

    public @Nullable Node firstChild() {
        if (this.childNodeSize() == 0) {
            return null;
        }
        return this.ensureChildNodes().get(0);
    }

    /*
     * WARNING - void declaration
     */
    public @Nullable Node lastChild() {
        void var1_1;
        int size = this.childNodeSize();
        if (size == 0) {
            return null;
        }
        List<Node> list = this.ensureChildNodes();
        return list.get((int)(var1_1 - true));
    }

    /*
     * WARNING - void declaration
     */
    public Node traverse(NodeVisitor nodeVisitor) {
        void var1_1;
        Validate.notNull(nodeVisitor);
        NodeTraversor.traverse((NodeVisitor)var1_1, this);
        return this;
    }

    public Stream<Node> nodeStream() {
        return NodeUtils.stream(this, Node.class);
    }

    /*
     * WARNING - void declaration
     */
    public String outerHtml() {
        void var1_1;
        StringBuilder accum2 = StringUtil.borrowBuilder();
        this.outerHtml(accum2);
        return StringUtil.releaseBuilder((StringBuilder)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected void outerHtml(Appendable accum2) {
        void var1_1;
        NodeTraversor.traverse(new OuterHtmlVisitor((Appendable)var1_1, NodeUtils.outputSettings(this)), this);
    }

    abstract void outerHtmlHead(Appendable var1, int var2, Document.OutputSettings var3) throws IOException;

    abstract void outerHtmlTail(Appendable var1, int var2, Document.OutputSettings var3) throws IOException;

    /*
     * WARNING - void declaration
     */
    public <T extends Appendable> T html(T appendable) {
        void var1_1;
        this.outerHtml(appendable);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    final boolean isEffectivelyFirst() {
        if (this.siblingIndex == 0) {
            return true;
        }
        if (this.siblingIndex == 1) {
            void var1_1;
            Node prev = this.previousSibling();
            return prev instanceof TextNode && ((TextNode)var1_1).isBlank();
        }
        return false;
    }

    public String toString() {
        return this.outerHtml();
    }

    /*
     * WARNING - void declaration
     */
    protected void indent(Appendable accum2, int depth, Document.OutputSettings out) throws IOException {
        void var3_3;
        void var2_2;
        accum2.append('\n').append(StringUtil.padding((int)(var2_2 * out.indentAmount()), var3_3.maxPaddingWidth()));
    }

    /*
     * WARNING - void declaration
     */
    public boolean equals(@Nullable Object o) {
        void var1_1;
        return this == var1_1;
    }

    public int hashCode() {
        return super.hashCode();
    }

    /*
     * WARNING - void declaration
     */
    public Node clone() {
        void var1_1;
        Node thisClone = this.doClone(null);
        LinkedList<Node> nodesToProcess = new LinkedList<Node>();
        nodesToProcess.add(thisClone);
        while (!nodesToProcess.isEmpty()) {
            Node currParent = (Node)nodesToProcess.remove();
            int size = currParent.childNodeSize();
            for (int i = 0; i < size; ++i) {
                List<Node> childNodes = currParent.ensureChildNodes();
                Node childClone = childNodes.get(i).doClone(currParent);
                childNodes.set(i, childClone);
                nodesToProcess.add(childClone);
            }
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected Node doClone(@Nullable Node parent) {
        void var2_3;
        Document doc;
        Node clone;
        try {
            clone = (Node)super.clone();
        }
        catch (CloneNotSupportedException e) {
            throw new RuntimeException(e);
        }
        clone.parentNode = e;
        int n = clone.siblingIndex = e == null ? 0 : this.siblingIndex;
        if (e == null && !(this instanceof Document) && (doc = this.ownerDocument()) != null) {
            void var1_1;
            Document docClone = doc.shallowClone();
            clone.parentNode = docClone;
            var1_1.ensureChildNodes().add(clone);
        }
        return var2_3;
    }

    private static class OuterHtmlVisitor
    implements NodeVisitor {
        private final Appendable accum;
        private final Document.OutputSettings out;

        /*
         * WARNING - void declaration
         */
        OuterHtmlVisitor(Appendable accum2, Document.OutputSettings out) {
            void var2_2;
            void var1_1;
            this.accum = var1_1;
            this.out = out;
            var2_2.prepareEncoder();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void head(Node node, int depth) {
            try {
                void var2_3;
                node.outerHtmlHead(this.accum, (int)var2_3, this.out);
                return;
            }
            catch (IOException exception) {
                void var1_2;
                throw new SerializationException((Throwable)var1_2);
            }
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public void tail(Node node, int depth) {
            if (!node.nodeName().equals("#text")) {
                try {
                    void var2_3;
                    node.outerHtmlTail(this.accum, (int)var2_3, this.out);
                    return;
                }
                catch (IOException exception) {
                    void var1_2;
                    throw new SerializationException((Throwable)var1_2);
                }
            }
        }
    }
}

