/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkLaplacianSharpeningImageFilter_h
#define sitkLaplacianSharpeningImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class LaplacianSharpeningImageFilter
\brief This filter sharpens an image using a Laplacian. LaplacianSharpening highlights regions of rapid intensity change and therefore highlights or enhances the edges. The result is an image that appears more in focus.

\par The LaplacianSharpening at each pixel location is computed by
convolution with the itk::LaplacianOperator .


\par Inputs and Outputs
The input to this filter is a scalar-valued itk::Image of arbitrary dimension. The output is a scalar-valued itk::Image . 


\see Image 


\see Neighborhood 


\see NeighborhoodOperator 


\see NeighborhoodIterator 


\see LaplacianOperator
\sa itk::simple::LaplacianSharpening for the procedural interface
\sa itk::LaplacianSharpeningImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT LaplacianSharpeningImageFilter : public ImageFilter {
    public:
      using Self = LaplacianSharpeningImageFilter;

      /** Destructor */
      virtual ~LaplacianSharpeningImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      LaplacianSharpeningImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = BasicPixelIDTypeList;
\

      /**
       * Set/Get whether or not the filter will use the spacing information of the input image in its calculations. Use this option if derivatives are required in physical space.
       */
      SITK_RETURN_SELF_TYPE_HEADER SetUseImageSpacing ( bool UseImageSpacing ) { this->m_UseImageSpacing = UseImageSpacing; return *this; }

      /** Set the value of UseImageSpacing to true or false respectfully. */
      SITK_RETURN_SELF_TYPE_HEADER UseImageSpacingOn() { return this->SetUseImageSpacing(true); }
      SITK_RETURN_SELF_TYPE_HEADER UseImageSpacingOff() { return this->SetUseImageSpacing(false); }

      /**
       * Set/Get whether or not the filter will use the spacing information of the input image in its calculations. Use this option if derivatives are required in physical space.
       */
      bool GetUseImageSpacing() const { return this->m_UseImageSpacing; }

      /** Name of this class */
      std::string GetName() const { return std::string ("LaplacianSharpeningImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );
      /** Dispatched methods which calls ExecuteInternal on each component */
      template <class TImageType> Image ExecuteInternalVectorImage ( const Image& image );

      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;
      friend struct detail::ExecuteInternalVectorImageAddressor<MemberFunctionType>;
      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;


      bool  m_UseImageSpacing{true};


    };

    /**\
     * \brief This filter sharpens an image using a Laplacian. LaplacianSharpening highlights regions of rapid intensity change and therefore highlights or enhances the edges. The result is an image that appears more in focus.
     *
     * This function directly calls the execute method of LaplacianSharpeningImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::LaplacianSharpeningImageFilter for the object oriented interface
     * @{
     */

     SITKBasicFilters_EXPORT Image LaplacianSharpening ( const Image& image1, bool useImageSpacing = true );

     /** @} */
}
#endif
