/*=========================================================================
*
*  Copyright NumFOCUS
*
*  Licensed under the Apache License, Version 2.0 (the "License");
*  you may not use this file except in compliance with the License.
*  You may obtain a copy of the License at
*
*         http://www.apache.org/licenses/LICENSE-2.0.txt
*
*  Unless required by applicable law or agreed to in writing, software
*  distributed under the License is distributed on an "AS IS" BASIS,
*  WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
*  See the License for the specific language governing permissions and
*  limitations under the License.
*
*=========================================================================*/
#ifndef sitkSobelEdgeDetectionImageFilter_h
#define sitkSobelEdgeDetectionImageFilter_h

/*
 * WARNING: DO NOT EDIT THIS FILE!
 * THIS FILE IS AUTOMATICALLY GENERATED BY THE SIMPLEITK BUILD PROCESS.
 * Please look at sitkImageFilterTemplate.h.in to make changes.
 */

#include <memory>

#include "sitkBasicFilters.h"
#include "sitkImageFilter.h"

namespace itk::simple {

    /**\class SobelEdgeDetectionImageFilter
\brief A 2D or 3D edge detection using the Sobel operator.

This filter uses the Sobel operator to calculate the image gradient and then finds the magnitude of this gradient vector. The Sobel gradient magnitude (square-root sum of squares) is an indication of edge strength.

\see ImageToImageFilter 


\see SobelOperator 


\see Neighborhood 


\see NeighborhoodOperator 


\see NeighborhoodIterator
\sa itk::simple::SobelEdgeDetection for the procedural interface
\sa itk::SobelEdgeDetectionImageFilter for the Doxygen on the original ITK class.
     */
    class SITKBasicFilters_EXPORT SobelEdgeDetectionImageFilter : public ImageFilter {
    public:
      using Self = SobelEdgeDetectionImageFilter;

      /** Destructor */
      virtual ~SobelEdgeDetectionImageFilter();

      /** Default Constructor that takes no arguments and initializes
       * default parameters */
      SobelEdgeDetectionImageFilter();

      /** Define the pixels types supported by this filter */
      using PixelIDTypeList = RealPixelIDTypeList;


      /** Name of this class */
      std::string GetName() const { return std::string ("SobelEdgeDetectionImageFilter"); }

      /** Print ourselves out */
      std::string ToString() const;


      /** Execute the filter on the input image */

      Image Execute ( const Image& image1 );

    private:

      /** Setup for member function dispatching */

      using MemberFunctionType = Image (Self::*)( const Image& image1 );
      template <class TImageType> Image ExecuteInternal ( const Image& image1 );


      friend struct detail::MemberFunctionAddressor<MemberFunctionType>;

      std::unique_ptr<detail::MemberFunctionFactory<MemberFunctionType> > m_MemberFactory;



    };

    /**\
     * \brief A 2D or 3D edge detection using the Sobel operator.
     *
     * This function directly calls the execute method of SobelEdgeDetectionImageFilter
     * in order to support a procedural API
     *
     * \sa itk::simple::SobelEdgeDetectionImageFilter for the object oriented interface
     * @{
     */

     SITKBasicFilters_EXPORT Image SobelEdgeDetection ( const Image& image1 );

     /** @} */
}
#endif
