/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.bibgls.bib2gls;

import com.dickimawbooks.bibgls.bib2gls.Bib2Gls;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsEntry;
import com.dickimawbooks.bibgls.bib2gls.Bib2GlsEntryLetterComparator;
import com.dickimawbooks.bibgls.bib2gls.SortSettings;
import java.util.Vector;
import java.util.regex.Matcher;

public class Bib2GlsEntryLetterNumberComparator
extends Bib2GlsEntryLetterComparator {
    public static final int NUMBER_BEFORE_LETTER = 0;
    public static final int NUMBER_AFTER_LETTER = 1;
    public static final int NUMBER_BETWEEN = 2;
    public static final int NUMBER_FIRST = 3;
    public static final int NUMBER_LAST = 4;
    public static final int PUNCTUATION_SPACE_FIRST = 0;
    public static final int PUNCTUATION_SPACE_LAST = 1;
    public static final int SPACE_PUNCTUATION_FIRST = 2;
    public static final int SPACE_PUNCTUATION_LAST = 3;
    public static final int SPACE_FIRST_PUNCTUATION_LAST = 4;
    public static final int PUNCTUATION_FIRST_SPACE_LAST = 5;
    public static final int PUNCTUATION_FIRST_SPACE_ZERO = 6;
    public static final int PUNCTUATION_LAST_SPACE_ZERO = 7;
    public static final int PUNCTUATION_FIRST_SPACE_ZERO_MATCH_NEXT = 8;
    public static final int PUNCTUATION_LAST_SPACE_ZERO_MATCH_NEXT = 9;
    private final SortComponent NULL_COMPONENT = new ComponentLetter(0);
    private final SortComponent MIN_COMPONENT = new ComponentNumber(Integer.MIN_VALUE);
    private final SortComponent MAX_COMPONENT = new ComponentNumber(Integer.MAX_VALUE);
    private int numberPosition;
    private int puncPosition;

    public Bib2GlsEntryLetterNumberComparator(Bib2Gls bib2Gls, Vector<Bib2GlsEntry> vector, SortSettings sortSettings, String string, String string2, String string3, boolean bl) {
        super(bib2Gls, vector, sortSettings, string, string2, string3, bl);
        this.numberPosition = sortSettings.getLetterNumberRule();
        switch (this.numberPosition) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid number option: " + this.numberPosition);
            }
        }
        this.puncPosition = sortSettings.getLetterNumberPuncRule();
        switch (this.puncPosition) {
            case 0: 
            case 1: 
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid punctuation option: " + this.puncPosition);
            }
        }
    }

    @Override
    protected String adjustSort(Bib2GlsEntry bib2GlsEntry, String string) {
        if (this.puncPosition == 6 || this.puncPosition == 7 || this.puncPosition == 8 || this.puncPosition == 9) {
            int n = string.length();
            if (n == 0) {
                return string;
            }
            boolean bl = this.puncPosition == 8 || this.puncPosition == 9;
            StringBuilder stringBuilder = new StringBuilder(n);
            int n2 = 0;
            while (n2 < n) {
                int n3 = string.codePointAt(n2);
                n2 += Character.charCount(n3);
                if (Character.isWhitespace(n3)) {
                    int n4 = n2 < n ? string.codePointAt(n2) : 0;
                    n3 = 48;
                    if (n4 > 127 && bl) {
                        if (Character.isDigit(n4)) {
                            try {
                                String string2 = new String(Character.toChars(n4));
                                int n5 = n4 - Integer.valueOf(string2);
                                string2 = new String(Character.toChars(n5));
                                if (Integer.valueOf(string2) == 0) {
                                    n3 = n5;
                                }
                            }
                            catch (NumberFormatException numberFormatException) {
                                this.bib2gls.debug(numberFormatException);
                            }
                        } else if (Bib2Gls.isSubscriptDigit(n4)) {
                            n3 = 8320;
                        } else if (Bib2Gls.isSuperscriptDigit(n4)) {
                            n3 = 8304;
                        }
                    }
                }
                stringBuilder.appendCodePoint(n3);
            }
            string = stringBuilder.toString();
        }
        if (!string.isEmpty()) {
            bib2GlsEntry.setSortObject(this.getSortList(string));
        }
        return super.adjustSort(bib2GlsEntry, string);
    }

    protected int compareElements(ComponentList componentList, ComponentList componentList2) {
        int n = componentList.size();
        int n2 = componentList2.size();
        int n3 = 0;
        for (int i = 0; n3 < n && i < n2; ++n3, ++i) {
            int n4;
            SortComponent sortComponent = (SortComponent)componentList.get(n3);
            SortComponent sortComponent2 = (SortComponent)componentList2.get(i);
            if ((this.caseStyle == 2 || this.caseStyle == 3) && this.numberPosition == 2) {
                int n5;
                SortComponent sortComponent3;
                boolean bl = sortComponent instanceof ComponentNumber;
                boolean bl2 = sortComponent2 instanceof ComponentNumber;
                if (bl && bl2) {
                    SortComponent sortComponent4;
                    sortComponent3 = n3 < n - 1 ? (SortComponent)componentList.get(n3 + 1) : this.NULL_COMPONENT;
                    SortComponent sortComponent5 = sortComponent4 = i < n2 - 1 ? (SortComponent)componentList2.get(i + 1) : this.NULL_COMPONENT;
                    n4 = sortComponent3 instanceof ComponentLetter && sortComponent4 instanceof ComponentLetter && sortComponent3.getValue() == sortComponent4.getValue() ? sortComponent.compareTo(sortComponent2) : 0;
                } else if (bl && !bl2) {
                    SortComponent sortComponent6 = sortComponent3 = n3 < n - 1 ? (SortComponent)componentList.get(n3 + 1) : this.NULL_COMPONENT;
                    if (sortComponent3 instanceof ComponentLetter) {
                        int n6 = sortComponent3.getValue();
                        if (n6 == (n5 = sortComponent2.getValue())) {
                            n4 = sortComponent.compareTo(sortComponent2);
                        } else if (Character.toLowerCase(n6) == Character.toLowerCase(n5)) {
                            n4 = sortComponent3.compareTo(sortComponent2);
                            if (n4 == 0) {
                                n4 = sortComponent.compareTo(sortComponent2);
                            }
                        } else {
                            n4 = sortComponent3.compareTo(sortComponent2);
                            ++n3;
                        }
                    } else {
                        n4 = sortComponent.compareTo(sortComponent2);
                    }
                } else if (!bl && bl2) {
                    SortComponent sortComponent7 = sortComponent3 = i < n2 - 1 ? (SortComponent)componentList2.get(i + 1) : this.NULL_COMPONENT;
                    if (sortComponent3 instanceof ComponentLetter) {
                        int n7 = sortComponent.getValue();
                        if (n7 == (n5 = sortComponent3.getValue())) {
                            n4 = sortComponent.compareTo(sortComponent2);
                        } else if (Character.toLowerCase(n7) == Character.toLowerCase(n5)) {
                            n4 = sortComponent.compareTo(sortComponent3);
                            if (n4 == 0) {
                                n4 = sortComponent.compareTo(sortComponent2);
                            }
                        } else {
                            n4 = sortComponent.compareTo(sortComponent3);
                            ++i;
                        }
                    } else {
                        n4 = sortComponent.compareTo(sortComponent2);
                    }
                } else {
                    n4 = sortComponent.compareTo(sortComponent2);
                }
            } else {
                n4 = sortComponent.compareTo(sortComponent2);
            }
            if (n4 == 0) continue;
            return n4;
        }
        if (n == n2) {
            return 0;
        }
        return n < n2 ? -1 : 1;
    }

    @Override
    protected int compareElements(Bib2GlsEntry bib2GlsEntry, Bib2GlsEntry bib2GlsEntry2) {
        String string;
        Object object = bib2GlsEntry.getSortObject();
        Object object2 = bib2GlsEntry2.getSortObject();
        ComponentList componentList = null;
        ComponentList componentList2 = null;
        if (object instanceof ComponentList) {
            componentList = (ComponentList)object;
        }
        if (object2 instanceof ComponentList) {
            componentList2 = (ComponentList)object2;
        }
        if (componentList == null) {
            string = bib2GlsEntry.getFieldValue(this.sortStorageField);
            if (string == null || string.isEmpty()) {
                if (componentList2 != null) {
                    return -1;
                }
                String string2 = bib2GlsEntry2.getFieldValue(this.sortStorageField);
                if (string2 == null || string2.isEmpty()) {
                    return 0;
                }
                return -1;
            }
            componentList = this.getSortList(string);
            bib2GlsEntry.setSortObject(componentList);
        }
        if (componentList2 == null) {
            string = bib2GlsEntry.getFieldValue(this.sortStorageField);
            if (string == null || string.isEmpty()) {
                if (componentList != null) {
                    return 1;
                }
                String string3 = bib2GlsEntry.getFieldValue(this.sortStorageField);
                if (string3 == null || string3.isEmpty()) {
                    return 0;
                }
                return 1;
            }
            componentList2 = this.getSortList(string);
            bib2GlsEntry2.setSortObject(componentList2);
        }
        return this.compareElements(componentList, componentList2);
    }

    public ComponentList getSortList(String string) {
        ComponentList componentList = new ComponentList(string.length());
        int n = 0;
        while (n < string.length()) {
            int n2 = string.codePointAt(n);
            Matcher matcher = Bib2Gls.INT_PATTERN.matcher(string.substring(n));
            Integer n3 = null;
            if (matcher.matches()) {
                try {
                    n3 = Bib2Gls.parseInt(matcher.group(1));
                    n += matcher.end(1);
                }
                catch (NumberFormatException numberFormatException) {
                    n += Character.charCount(n2);
                }
            } else {
                n += Character.charCount(n2);
            }
            if (n3 == null) {
                if (Character.isLetter(n2)) {
                    SortComponent sortComponent;
                    SortComponent sortComponent2 = sortComponent = componentList.isEmpty() ? null : (SortComponent)componentList.lastElement();
                    if (!(this.caseStyle != 2 && this.caseStyle != 3 || this.numberPosition != 2 || sortComponent instanceof ComponentNumber)) {
                        boolean bl;
                        boolean bl2 = bl = Character.isUpperCase(n2) || Character.isTitleCase(n2);
                        if (this.caseStyle == 2) {
                            componentList.add(bl ? this.MIN_COMPONENT : this.MAX_COMPONENT);
                        } else {
                            componentList.add(bl ? this.MAX_COMPONENT : this.MIN_COMPONENT);
                        }
                    } else if (this.caseStyle == 1) {
                        n2 = Character.toLowerCase(n2);
                    }
                    componentList.add(new ComponentLetter(n2));
                    continue;
                }
                if (Character.isWhitespace(n2)) {
                    componentList.add(new ComponentSpace(n2));
                    continue;
                }
                componentList.add(new ComponentOther(n2));
                continue;
            }
            componentList.add(new ComponentNumber(n3));
        }
        return componentList;
    }

    class SortComponent {
        private int value;

        public SortComponent(int n) {
            this.value = n;
        }

        public int getValue() {
            return this.value;
        }

        public String toString() {
            if (this.value == 0 || this.value == Integer.MIN_VALUE || this.value == Integer.MAX_VALUE) {
                if (Bib2GlsEntryLetterNumberComparator.this.bib2gls.isDebuggingOn()) {
                    return this.value == 0 ? "" : (this.value < 0 ? "\u2199" : "\u2197");
                }
                return "";
            }
            if (this.value <= 65535) {
                return String.format("%c", Character.valueOf((char)this.value));
            }
            return new String(Character.toChars(this.getValue()));
        }

        public int compareTo(SortComponent sortComponent) {
            if (this.value == sortComponent.value) {
                return 0;
            }
            if (this.value < sortComponent.value) {
                return -1;
            }
            return 1;
        }
    }

    class ComponentLetter
    extends SortComponent {
        public ComponentLetter(int n) {
            super(n);
        }

        @Override
        public int compareTo(SortComponent sortComponent) {
            if (sortComponent instanceof ComponentLetter) {
                return Bib2GlsEntryLetterNumberComparator.this.compare(this.getValue(), sortComponent.getValue());
            }
            if (sortComponent instanceof ComponentNumber) {
                switch (Bib2GlsEntryLetterNumberComparator.this.numberPosition) {
                    case 0: 
                    case 3: {
                        return 1;
                    }
                    case 1: 
                    case 4: {
                        return -1;
                    }
                    case 2: {
                        boolean bl = Character.isUpperCase(this.getValue()) || Character.isTitleCase(this.getValue());
                        boolean bl2 = Character.isLowerCase(this.getValue());
                        switch (Bib2GlsEntryLetterNumberComparator.this.caseStyle) {
                            case 0: 
                            case 2: {
                                return bl ? -1 : 1;
                            }
                            case 1: {
                                return 1;
                            }
                            case 3: {
                                return bl2 ? -1 : 1;
                            }
                        }
                        throw new IllegalArgumentException("Invalid case setting: " + Bib2GlsEntryLetterNumberComparator.this.caseStyle);
                    }
                }
                throw new IllegalArgumentException("Invalid case setting: " + Bib2GlsEntryLetterNumberComparator.this.caseStyle);
            }
            if (sortComponent instanceof ComponentSpace || sortComponent instanceof ComponentOther) {
                switch (Bib2GlsEntryLetterNumberComparator.this.puncPosition) {
                    case 0: 
                    case 2: {
                        return 1;
                    }
                    case 1: 
                    case 3: {
                        return -1;
                    }
                    case 5: {
                        if (sortComponent instanceof ComponentOther) {
                            return 1;
                        }
                        return -1;
                    }
                    case 6: 
                    case 8: {
                        return 1;
                    }
                    case 4: {
                        if (sortComponent instanceof ComponentSpace) {
                            return 1;
                        }
                        return -1;
                    }
                    case 7: 
                    case 9: {
                        return -1;
                    }
                }
                throw new IllegalArgumentException("Invalid letter-number-punc setting: " + Bib2GlsEntryLetterNumberComparator.this.puncPosition);
            }
            return super.compareTo(sortComponent);
        }
    }

    class ComponentNumber
    extends SortComponent {
        public ComponentNumber(int n) {
            super(n);
        }

        public ComponentNumber(Number number) {
            this(number.intValue());
        }

        @Override
        public String toString() {
            if (this.getValue() == Integer.MAX_VALUE || this.getValue() == Integer.MIN_VALUE) {
                return super.toString();
            }
            return "" + this.getValue();
        }

        @Override
        public int compareTo(SortComponent sortComponent) {
            if (sortComponent instanceof ComponentNumber) {
                if (this == sortComponent) {
                    return 0;
                }
                if (this == Bib2GlsEntryLetterNumberComparator.this.MIN_COMPONENT || this == Bib2GlsEntryLetterNumberComparator.this.MAX_COMPONENT) {
                    return sortComponent.getValue() <= 0 ? 1 : -1;
                }
                if (sortComponent == Bib2GlsEntryLetterNumberComparator.this.MIN_COMPONENT || sortComponent == Bib2GlsEntryLetterNumberComparator.this.MAX_COMPONENT) {
                    return this.getValue() >= 0 ? 1 : -1;
                }
                return super.compareTo(sortComponent);
            }
            if (sortComponent instanceof ComponentLetter) {
                switch (Bib2GlsEntryLetterNumberComparator.this.numberPosition) {
                    case 0: 
                    case 3: {
                        return -1;
                    }
                    case 1: 
                    case 4: {
                        return 1;
                    }
                    case 2: {
                        boolean bl = Character.isUpperCase(sortComponent.getValue()) || Character.isTitleCase(sortComponent.getValue());
                        boolean bl2 = Character.isLowerCase(sortComponent.getValue());
                        switch (Bib2GlsEntryLetterNumberComparator.this.caseStyle) {
                            case 0: 
                            case 2: {
                                return bl ? 1 : -1;
                            }
                            case 1: {
                                return -1;
                            }
                            case 3: {
                                return bl2 ? 1 : -1;
                            }
                        }
                        throw new IllegalArgumentException("Invalid case setting: " + Bib2GlsEntryLetterNumberComparator.this.caseStyle);
                    }
                }
                throw new IllegalArgumentException("Invalid case setting: " + Bib2GlsEntryLetterNumberComparator.this.caseStyle);
            }
            if (sortComponent instanceof ComponentSpace) {
                switch (Bib2GlsEntryLetterNumberComparator.this.numberPosition) {
                    case 3: {
                        return -1;
                    }
                    case 4: {
                        return 1;
                    }
                }
                switch (Bib2GlsEntryLetterNumberComparator.this.puncPosition) {
                    case 0: 
                    case 2: 
                    case 4: 
                    case 6: 
                    case 8: {
                        return 1;
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 9: {
                        return -1;
                    }
                }
                throw new IllegalArgumentException("Invalid letter-number-punc setting: " + Bib2GlsEntryLetterNumberComparator.this.puncPosition);
            }
            if (sortComponent instanceof ComponentOther) {
                switch (Bib2GlsEntryLetterNumberComparator.this.numberPosition) {
                    case 3: {
                        return -1;
                    }
                    case 4: {
                        return 1;
                    }
                }
                switch (Bib2GlsEntryLetterNumberComparator.this.puncPosition) {
                    case 0: 
                    case 2: 
                    case 5: 
                    case 6: 
                    case 8: {
                        return 1;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 7: 
                    case 9: {
                        return -1;
                    }
                }
                throw new IllegalArgumentException("Invalid letter-number-punc setting: " + Bib2GlsEntryLetterNumberComparator.this.puncPosition);
            }
            return super.compareTo(sortComponent);
        }
    }

    class ComponentList
    extends Vector<SortComponent> {
        public ComponentList() {
        }

        public ComponentList(int n) {
            super(n);
        }

        @Override
        public String toString() {
            StringBuilder stringBuilder = new StringBuilder(this.capacity());
            for (SortComponent sortComponent : this) {
                stringBuilder.append(sortComponent.toString());
            }
            return stringBuilder.toString();
        }
    }

    class ComponentSpace
    extends SortComponent {
        public ComponentSpace(int n) {
            super(n);
        }

        @Override
        public int compareTo(SortComponent sortComponent) {
            if (sortComponent instanceof ComponentSpace) {
                return super.compareTo(sortComponent);
            }
            if (sortComponent instanceof ComponentLetter) {
                switch (Bib2GlsEntryLetterNumberComparator.this.puncPosition) {
                    case 0: 
                    case 2: 
                    case 4: 
                    case 6: 
                    case 8: {
                        return -1;
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 9: {
                        return 1;
                    }
                }
                throw new IllegalArgumentException("Invalid letter-number-punc setting: " + Bib2GlsEntryLetterNumberComparator.this.puncPosition);
            }
            if (sortComponent instanceof ComponentOther) {
                switch (Bib2GlsEntryLetterNumberComparator.this.puncPosition) {
                    case 0: 
                    case 1: 
                    case 5: 
                    case 6: 
                    case 8: {
                        return 1;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 7: 
                    case 9: {
                        return -1;
                    }
                }
                throw new IllegalArgumentException("Invalid letter-number-punc setting: " + Bib2GlsEntryLetterNumberComparator.this.puncPosition);
            }
            if (sortComponent instanceof ComponentNumber) {
                switch (Bib2GlsEntryLetterNumberComparator.this.numberPosition) {
                    case 3: {
                        return 1;
                    }
                    case 4: {
                        return -1;
                    }
                }
                switch (Bib2GlsEntryLetterNumberComparator.this.puncPosition) {
                    case 0: 
                    case 2: 
                    case 4: 
                    case 6: 
                    case 8: {
                        return -1;
                    }
                    case 1: 
                    case 3: 
                    case 5: 
                    case 7: 
                    case 9: {
                        return 1;
                    }
                }
                throw new IllegalArgumentException("Invalid letter-number-punc setting: " + Bib2GlsEntryLetterNumberComparator.this.puncPosition);
            }
            return super.compareTo(sortComponent);
        }
    }

    class ComponentOther
    extends SortComponent {
        public ComponentOther(int n) {
            super(n);
        }

        @Override
        public int compareTo(SortComponent sortComponent) {
            if (sortComponent instanceof ComponentOther) {
                return super.compareTo(sortComponent);
            }
            if (sortComponent instanceof ComponentLetter) {
                switch (Bib2GlsEntryLetterNumberComparator.this.puncPosition) {
                    case 0: 
                    case 2: 
                    case 5: 
                    case 6: 
                    case 8: {
                        return -1;
                    }
                    case 1: 
                    case 3: 
                    case 4: {
                        return 1;
                    }
                }
                throw new IllegalArgumentException("Invalid letter-number-punc setting: " + Bib2GlsEntryLetterNumberComparator.this.puncPosition);
            }
            if (sortComponent instanceof ComponentSpace) {
                switch (Bib2GlsEntryLetterNumberComparator.this.puncPosition) {
                    case 0: 
                    case 1: 
                    case 5: 
                    case 6: 
                    case 8: {
                        return -1;
                    }
                    case 2: 
                    case 3: 
                    case 4: 
                    case 7: 
                    case 9: {
                        return 1;
                    }
                }
                throw new IllegalArgumentException("Invalid letter-number-punc setting: " + Bib2GlsEntryLetterNumberComparator.this.puncPosition);
            }
            if (sortComponent instanceof ComponentNumber) {
                switch (Bib2GlsEntryLetterNumberComparator.this.numberPosition) {
                    case 3: {
                        return 1;
                    }
                    case 4: {
                        return -1;
                    }
                }
                switch (Bib2GlsEntryLetterNumberComparator.this.puncPosition) {
                    case 0: 
                    case 2: 
                    case 5: 
                    case 6: 
                    case 8: {
                        return -1;
                    }
                    case 1: 
                    case 3: 
                    case 4: 
                    case 7: 
                    case 9: {
                        return 1;
                    }
                }
                throw new IllegalArgumentException("Invalid letter-number-punc setting: " + Bib2GlsEntryLetterNumberComparator.this.puncPosition);
            }
            return super.compareTo(sortComponent);
        }
    }
}

