/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.NumericRegister;
import com.dickimawbooks.texparserlib.Numerical;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;

public class CountRegister
extends NumericRegister
implements TeXNumber {
    private int value = 0;

    public CountRegister(String string) {
        this(string, 0);
    }

    public CountRegister(String string, int n) {
        super(string);
        this.setValue(n);
    }

    public void setValue(int n) {
        this.value = n;
    }

    @Override
    public void setValue(TeXParser teXParser, Numerical numerical) throws TeXSyntaxException {
        this.setValue(numerical.number(teXParser));
    }

    @Override
    public void setContents(TeXParser teXParser, int n) throws TeXSyntaxException {
        this.setValue(n);
    }

    @Override
    public int getValue() {
        return this.value;
    }

    @Override
    public long longValue() {
        return this.value;
    }

    @Override
    public double doubleValue() {
        return this.value;
    }

    @Override
    public int number(TeXParser teXParser) throws TeXSyntaxException {
        return this.value;
    }

    @Override
    public TeXObject getContents(TeXParser teXParser) {
        return teXParser.string("" + this.value);
    }

    public void advance() {
        ++this.value;
    }

    @Override
    public void advance(TeXParser teXParser, Numerical numerical) throws TeXSyntaxException {
        this.value += numerical.number(teXParser);
    }

    @Override
    public void divide(int n) {
        this.value /= n;
    }

    @Override
    public void multiply(int n) {
        this.value *= n;
    }

    @Override
    public Object clone() {
        CountRegister countRegister = new CountRegister(this.getName(), this.value);
        countRegister.allocation = this.allocation;
        return countRegister;
    }

    @Override
    public String toString() {
        return String.format("%s[name=%s,value=%d]", this.getClass().getSimpleName(), this.getName(), this.value);
    }

    @Override
    public String format() {
        return "" + this.value;
    }
}

