/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.WhiteSpace;
import java.io.IOException;

public class Space
extends WhiteSpace {
    private int charCode;
    public static final int SPACE = 32;
    public static final int NO_BREAK_SPACE = 160;
    public static final int OGHAM_SPACE_MARK = 5760;
    public static final int MONGOLIAN_VOWEL_SEPARATOR = 6158;
    public static final int EN_QUAD = 8192;
    public static final int EM_QUAD = 8193;
    public static final int EN_SPACE = 8194;
    public static final int EM_SPACE = 8195;
    public static final int THREE_PER_EM_SPACE = 8196;
    public static final int FOUR_PER_EM_SPACE = 8197;
    public static final int SIX_PER_EM_SPACE = 8198;
    public static final int FIGURE_SPACE = 8199;
    public static final int PUNCTUATION_SPACE = 8200;
    public static final int THIN_SPACE = 8201;
    public static final int HAIR_SPACE = 8202;
    public static final int ZERO_WIDTH_SPACE = 8203;
    public static final int NARROW_NO_BREAK_SPACE = 8239;
    public static final int MEDIUM_MATHEMATICAL_SPACE = 8287;
    public static final int IDEOGRAPHIC_SPACE = 12288;
    public static final int ZERO_WIDTH_NO_BREAK_SPACE = 65279;

    public Space() {
        this(' ');
    }

    public Space(char c) {
        this((int)c);
    }

    public Space(int n) {
        this.setSpace(n);
    }

    public void setSpace(int n) {
        this.charCode = n;
    }

    public int getSpace() {
        return this.charCode;
    }

    @Override
    public String toString(TeXParser teXParser) {
        return this.format();
    }

    @Override
    public TeXObjectList string(TeXParser teXParser) throws IOException {
        return teXParser.string(" ");
    }

    @Override
    public String format() {
        return new String(Character.toChars(this.charCode));
    }

    @Override
    public String toString() {
        return String.format("%s%s", this.getClass().getSimpleName(), this.format());
    }

    @Override
    public Object clone() {
        return new Space(this.charCode);
    }

    public boolean isEol() {
        return this.charCode == 10 || this.charCode == 13;
    }
}

