/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib;

import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXFontFamily;
import com.dickimawbooks.texparserlib.TeXFontShape;
import com.dickimawbooks.texparserlib.TeXFontSize;
import com.dickimawbooks.texparserlib.TeXFontWeight;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXSettings;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.TeXUnit;
import com.dickimawbooks.texparserlib.html.L2HConverter;
import java.awt.Font;

public class TeXFontText {
    private String name;
    private TeXFontFamily family = TeXFontFamily.INHERIT;
    private TeXFontShape shape = TeXFontShape.INHERIT;
    private TeXFontWeight weight = TeXFontWeight.INHERIT;
    private TeXFontSize size = TeXFontSize.INHERIT;
    private TeXDimension userSize = null;
    private static final double PT_TO_BP = 0.9962640099626402;

    public TeXFontText() {
    }

    public TeXFontText(TeXFontFamily teXFontFamily) {
        this.setFamily(teXFontFamily);
    }

    public TeXFontText(TeXFontShape teXFontShape) {
        this.setShape(teXFontShape);
    }

    public TeXFontText(TeXFontFamily teXFontFamily, TeXFontSize teXFontSize) {
        this.setFamily(teXFontFamily);
        this.setSize(teXFontSize);
    }

    public TeXFontText(TeXFontSize teXFontSize) {
        this.setSize(teXFontSize);
    }

    public TeXFontText(TeXFontWeight teXFontWeight) {
        this.setWeight(teXFontWeight);
    }

    public void setName(String string) {
        this.name = string;
    }

    public void setFamily(TeXFontFamily teXFontFamily) {
        this.family = teXFontFamily;
    }

    public void setShape(TeXFontShape teXFontShape) {
        this.shape = teXFontShape;
    }

    public void setWeight(TeXFontWeight teXFontWeight) {
        this.weight = teXFontWeight;
    }

    public void setSize(TeXFontSize teXFontSize) {
        this.size = teXFontSize;
    }

    public String getName() {
        return this.name;
    }

    public TeXFontFamily getFamily() {
        return this.family;
    }

    public TeXFontShape getShape() {
        return this.shape;
    }

    public TeXFontWeight getWeight() {
        return this.weight;
    }

    public TeXFontSize getSize() {
        return this.size;
    }

    public int deriveSize(TeXParser teXParser) throws TeXSyntaxException {
        int n = teXParser.getListener().getNormalFontSize();
        TeXSettings teXSettings = teXParser.getSettings();
        if (this.size == TeXFontSize.SMALLER || this.size == TeXFontSize.LARGER) {
            double d;
            TeXFontSize teXFontSize = teXSettings.getFontSize();
            boolean bl = this.size == TeXFontSize.SMALLER;
            switch (teXFontSize) {
                case USER: {
                    if (this.userSize != null) {
                        TeXUnit teXUnit = this.userSize.getUnit();
                        d = teXUnit.toUnit(teXParser, this.userSize.getValue(), TeXUnit.BP);
                    }
                }
                case NORMAL: {
                    TeXFontSize teXFontSize2 = bl ? TeXFontSize.SMALL : TeXFontSize.LARGE;
                    d = teXFontSize2.deriveSize(n);
                    break;
                }
                case LARGE: {
                    TeXFontSize teXFontSize3 = bl ? TeXFontSize.NORMAL : TeXFontSize.XLARGE;
                    d = teXFontSize3.deriveSize(n);
                    break;
                }
                case XLARGE: {
                    TeXFontSize teXFontSize4 = bl ? TeXFontSize.LARGE : TeXFontSize.XXLARGE;
                    d = teXFontSize4.deriveSize(n);
                    break;
                }
                case XXLARGE: {
                    TeXFontSize teXFontSize5 = bl ? TeXFontSize.XLARGE : TeXFontSize.HUGE;
                    d = teXFontSize5.deriveSize(n);
                    break;
                }
                case SMALL: {
                    TeXFontSize teXFontSize6 = bl ? TeXFontSize.FOOTNOTE : TeXFontSize.NORMAL;
                    d = teXFontSize6.deriveSize(n);
                    break;
                }
                case FOOTNOTE: {
                    TeXFontSize teXFontSize7 = bl ? TeXFontSize.SCRIPT : TeXFontSize.SMALL;
                    d = teXFontSize7.deriveSize(n);
                    break;
                }
                case SCRIPT: {
                    TeXFontSize teXFontSize8 = bl ? TeXFontSize.TINY : TeXFontSize.FOOTNOTE;
                    d = teXFontSize8.deriveSize(n);
                    break;
                }
                case TINY: {
                    TeXFontSize teXFontSize9 = bl ? TeXFontSize.TINY : TeXFontSize.SCRIPT;
                    d = teXFontSize9.deriveSize(n);
                    break;
                }
                case HUGE: {
                    if (bl) {
                        TeXFontSize teXFontSize10 = TeXFontSize.XXLARGE;
                        d = teXFontSize10.deriveSize(n);
                    }
                }
                default: {
                    d = teXFontSize.deriveSize(n) * 0.9962640099626402;
                }
            }
            d = bl ? (d *= 0.8) : (d *= 1.2);
            return (int)Math.round(d);
        }
        TeXFontSize teXFontSize = this.size;
        if (this.size == TeXFontSize.INHERIT) {
            teXFontSize = teXSettings.getFontSize();
        }
        if (teXFontSize == TeXFontSize.USER) {
            if (this.userSize == null) {
                return n;
            }
            TeXUnit teXUnit = this.userSize.getUnit();
            return Math.round(teXUnit.toUnit(teXParser, this.userSize.getValue(), TeXUnit.BP));
        }
        return (int)Math.round(teXFontSize.deriveSize(n) * 0.9962640099626402);
    }

    public Font getFont(TeXParser teXParser) throws TeXSyntaxException {
        TeXSettings teXSettings = teXParser.getSettings();
        TeXFontFamily teXFontFamily = this.family;
        if (this.family == TeXFontFamily.INHERIT) {
            teXFontFamily = teXSettings.getFontFamily();
        }
        TeXFontShape teXFontShape = this.shape;
        if (this.shape == TeXFontShape.INHERIT) {
            teXFontShape = teXSettings.getFontShape();
        }
        TeXFontWeight teXFontWeight = this.weight;
        if (this.weight == TeXFontWeight.INHERIT) {
            teXFontWeight = teXSettings.getFontWeight();
        }
        int n = this.deriveSize(teXParser);
        String string = this.name;
        if (this.name == null) {
            switch (teXFontFamily) {
                case SF: {
                    string = "SansSerif";
                    break;
                }
                case TT: 
                case VERB: {
                    string = "Monospace";
                    break;
                }
                default: {
                    string = "Serif";
                }
            }
        }
        int n2 = 0;
        if (teXFontShape == TeXFontShape.IT || teXFontShape == TeXFontShape.SL) {
            n2 = teXFontWeight.isBold() ? 3 : 2;
        } else if (teXFontWeight.isBold()) {
            n2 = 1;
        }
        return new Font(this.name, n2, n);
    }

    protected String getSerifCssFontNames(TeXParserListener teXParserListener) {
        if (teXParserListener instanceof L2HConverter) {
            return ((L2HConverter)teXParserListener).getSerifCssFontNames();
        }
        return "serif";
    }

    protected String getSansSerifCssFontNames(TeXParserListener teXParserListener) {
        if (teXParserListener instanceof L2HConverter) {
            return ((L2HConverter)teXParserListener).getSansSerifCssFontNames();
        }
        return "sans-serif";
    }

    protected String getMonospaceCssFontNames(TeXParserListener teXParserListener) {
        if (teXParserListener instanceof L2HConverter) {
            return ((L2HConverter)teXParserListener).getMonospaceCssFontNames();
        }
        return "monospace";
    }

    protected String getCursiveCssFontNames(TeXParserListener teXParserListener) {
        if (teXParserListener instanceof L2HConverter) {
            return ((L2HConverter)teXParserListener).getCursiveCssFontNames();
        }
        return "cursive";
    }

    public String getCss(TeXParser teXParser) throws TeXSyntaxException {
        TeXSettings teXSettings = teXParser.getSettings();
        StringBuilder stringBuilder = new StringBuilder();
        if (this.family != TeXFontFamily.INHERIT) {
            stringBuilder.append("font-family:");
            boolean bl = false;
            if (this.name != null) {
                if (this.name.matches("[^\\p{IsAlphabetic}]")) {
                    stringBuilder.append(" '" + this.name + "'");
                } else {
                    stringBuilder.append(this.name);
                }
                bl = true;
            }
            switch (this.family) {
                case RM: {
                    if (bl) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(' ');
                    stringBuilder.append(this.getSerifCssFontNames(teXParser.getListener()));
                    break;
                }
                case SF: {
                    if (bl) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(' ');
                    stringBuilder.append(this.getSansSerifCssFontNames(teXParser.getListener()));
                    break;
                }
                case TT: 
                case VERB: {
                    if (bl) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(' ');
                    stringBuilder.append(this.getMonospaceCssFontNames(teXParser.getListener()));
                    break;
                }
                case CAL: {
                    if (bl) {
                        stringBuilder.append(',');
                    }
                    stringBuilder.append(' ');
                    stringBuilder.append(this.getCursiveCssFontNames(teXParser.getListener()));
                }
            }
            stringBuilder.append("; ");
        }
        switch (this.shape) {
            case UP: {
                stringBuilder.append("font-style: normal; font-variant: normal; ");
                break;
            }
            case IT: {
                stringBuilder.append("font-style: italic; font-variant: normal; ");
                break;
            }
            case SL: {
                stringBuilder.append("font-style: oblique; font-variant: normal; ");
                break;
            }
            case EM: {
                TeXFontFamily teXFontFamily = teXSettings.getFontFamily();
                TeXFontShape teXFontShape = teXSettings.getFontShape();
                if (teXFontShape == TeXFontShape.IT || teXFontShape == TeXFontShape.SL) {
                    stringBuilder.append("font-style: normal; font-variant: normal; ");
                    break;
                }
                if (teXFontFamily == TeXFontFamily.SF) {
                    stringBuilder.append("font-style: oblique; font-variant: normal; ");
                    break;
                }
                stringBuilder.append("font-style: italic; font-variant: normal; ");
                break;
            }
            case SC: {
                stringBuilder.append("font-style: normal; font-variant: small-caps; ");
            }
        }
        if (this.weight != TeXFontWeight.INHERIT) {
            if (this.weight.isBold()) {
                stringBuilder.append("font-weight: bold; ");
            } else {
                stringBuilder.append("font-weight: normal; ");
            }
        }
        switch (this.size) {
            case INHERIT: {
                break;
            }
            case USER: {
                if (this.userSize == null) break;
                TeXUnit teXUnit = this.userSize.getUnit();
                stringBuilder.append(String.format("font-size: %fpt; ", Float.valueOf(teXUnit.toUnit(teXParser, this.userSize.getValue(), TeXUnit.BP))));
                break;
            }
            case NORMAL: {
                stringBuilder.append("font-size: medium; ");
                break;
            }
            case SMALL: {
                stringBuilder.append("font-size: small; ");
                break;
            }
            case FOOTNOTE: {
                stringBuilder.append("font-size: x-small; ");
                break;
            }
            case SCRIPT: {
                stringBuilder.append("font-size: xx-small; ");
                break;
            }
            case LARGE: {
                stringBuilder.append("font-size: large; ");
                break;
            }
            case XLARGE: {
                stringBuilder.append("font-size: x-large; ");
                break;
            }
            case XXLARGE: {
                stringBuilder.append("font-size: xx-large; ");
                break;
            }
            case SMALLER: {
                stringBuilder.append("font-size: smaller; ");
                break;
            }
            case LARGER: {
                stringBuilder.append("font-size: larger; ");
                break;
            }
            default: {
                stringBuilder.append(String.format("font-size: %fpt; ", this.deriveSize(teXParser)));
            }
        }
        return stringBuilder.toString();
    }
}

