/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.auxfile;

import com.dickimawbooks.texparserlib.Group;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.auxfile.AuxData;
import com.dickimawbooks.texparserlib.auxfile.CrossRefInfo;
import com.dickimawbooks.texparserlib.auxfile.DivisionInfo;

public class LabelInfo
implements CrossRefInfo {
    protected String label;
    protected String target;
    protected TeXObject title;
    protected TeXObject reference;
    protected TeXObject page;
    protected DivisionInfo divisionData;

    protected LabelInfo(String string) {
        this.label = string;
    }

    public LabelInfo(String string, String string2, TeXObject teXObject, TeXObject teXObject2, TeXObject teXObject3) {
        if (teXObject == null || teXObject2 == null || teXObject3 == null) {
            throw new NullPointerException();
        }
        this.label = string;
        this.target = string2;
        this.reference = teXObject;
        this.title = teXObject2;
        this.page = teXObject3;
    }

    public static LabelInfo createLabel(AuxData auxData, TeXParser teXParser) {
        String string = auxData.getArg(0).toString(teXParser);
        LabelInfo labelInfo = new LabelInfo(string);
        TeXObject teXObject = auxData.getArg(1);
        if (teXParser.isStack(teXObject)) {
            TeXObjectList teXObjectList = (TeXObjectList)teXObject;
            if (teXObjectList.size() > 0) {
                labelInfo.reference = (TeXObject)teXObjectList.get(0);
                if (labelInfo.reference instanceof Group) {
                    labelInfo.reference = TeXParserUtils.removeGroup((TeXObjectList)labelInfo.reference);
                }
            }
            if (teXObjectList.size() > 1) {
                labelInfo.page = (TeXObject)teXObjectList.get(1);
                if (labelInfo.page instanceof Group) {
                    labelInfo.page = TeXParserUtils.removeGroup((TeXObjectList)labelInfo.page);
                }
            }
            if (teXObjectList.size() > 2) {
                labelInfo.title = (TeXObject)teXObjectList.get(2);
                if (labelInfo.title instanceof Group) {
                    labelInfo.title = TeXParserUtils.removeGroup((TeXObjectList)labelInfo.title);
                }
            }
            if (teXObjectList.size() > 3) {
                TeXObject teXObject2 = (TeXObject)teXObjectList.get(3);
                if (teXObject2 instanceof Group) {
                    teXObject2 = TeXParserUtils.removeGroup((TeXObjectList)teXObject2);
                }
                labelInfo.target = teXObject2.toString(teXParser);
            }
        }
        return labelInfo;
    }

    @Override
    public String getLabel() {
        return this.label;
    }

    @Override
    public String getTarget() {
        return this.target;
    }

    public TeXObject getTitle() {
        return this.title;
    }

    @Override
    public TeXObject getReference() {
        return this.reference;
    }

    public TeXObject getPage() {
        return this.page;
    }

    @Override
    public void setDivisionInfo(DivisionInfo divisionInfo) {
        this.divisionData = divisionInfo;
    }

    @Override
    public DivisionInfo getDivisionInfo() {
        return this.divisionData;
    }

    public String toString() {
        return this.label;
    }
}

