/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.html.DocumentBlockType;
import com.dickimawbooks.texparserlib.html.HtmlTag;
import com.dickimawbooks.texparserlib.html.L2HConverter;
import java.io.IOException;
import java.util.HashMap;

public class StartElement
extends HtmlTag {
    private String name;
    private boolean insertCR = false;
    private boolean isBlock = false;
    private HashMap<String, String> attributes;

    public StartElement(String string) {
        this(string, false);
    }

    public StartElement(String string, boolean bl) {
        this(string, bl, string.equals("div"));
    }

    public StartElement(String string, boolean bl, boolean bl2) {
        super(String.format("<%s>", string));
        if (string.contains("[^a-zA-Z]")) {
            throw new IllegalArgumentException(String.format("Invalid element name '%s'", string));
        }
        this.name = string;
        this.insertCR = bl;
        this.isBlock = bl2;
    }

    @Override
    public Object clone() {
        StartElement startElement = new StartElement(this.getName(), this.insertCR, this.isBlock);
        if (this.attributes != null) {
            startElement.attributes = new HashMap();
            startElement.attributes.putAll(this.attributes);
        }
        return startElement;
    }

    @Override
    public String toString(TeXParser teXParser) {
        return this.toString();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.insertCR) {
            stringBuilder.append(String.format("%n", new Object[0]));
        }
        stringBuilder.append(String.format("<%s", this.name));
        if (this.attributes != null) {
            for (String string : this.attributes.keySet()) {
                String string2 = this.attributes.get(string);
                stringBuilder.append(String.format(" %s=\"%s\"", string, string2));
            }
        }
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        Object object;
        L2HConverter l2HConverter = (L2HConverter)teXParser.getListener();
        if (this.isBlock) {
            l2HConverter.endParagraph();
            l2HConverter.setCurrentBlockType(DocumentBlockType.BLOCK);
        }
        if (this.insertCR) {
            l2HConverter.writeln();
        }
        String string = null;
        if (l2HConverter.isNameAnchorRequired(this.name, this.isBlock) && this.attributes != null && (object = this.attributes.get("id")) != null) {
            if (this.name.equals("a")) {
                this.attributes.put("name", (String)object);
            } else {
                String string2 = String.format("<a name=\"%s\"></a>", object);
                if (this.name.equals("div")) {
                    string = string2;
                } else {
                    l2HConverter.writeliteral(string2);
                }
            }
            this.attributes.remove("id");
        }
        if (this.attributes == null || this.attributes.isEmpty()) {
            l2HConverter.writeliteral(this.getTag());
        } else {
            l2HConverter.writeliteral("<" + this.name);
            for (String string2 : this.attributes.keySet()) {
                String string3 = this.attributes.get(string2);
                l2HConverter.writeliteral(String.format(" %s=\"%s\"", string2, string3));
            }
            l2HConverter.writeliteral(">");
        }
        if (string != null) {
            l2HConverter.writeliteral(string);
        }
    }

    public String getName() {
        return this.name;
    }

    public String removeAttribute(String string) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.remove(string);
    }

    public String getAttribute(String string) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(string);
    }

    public boolean hasAttribute(String string) {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.containsKey(string);
    }

    public void putAttribute(String string, String string2) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(string, string2);
    }

    public void putStyle(L2HConverter l2HConverter, HashMap<String, String> hashMap) {
        String string = l2HConverter.getCssClass(hashMap);
        if (string == null) {
            this.putAttribute("style", l2HConverter.cssAttributesToString(hashMap));
        } else {
            this.putAttribute("class", string);
        }
    }
}

