/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.html;

import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.Writeable;
import com.dickimawbooks.texparserlib.html.HtmlTag;
import com.dickimawbooks.texparserlib.html.L2HConverter;
import java.io.IOException;
import java.util.HashMap;

public class VoidElement
extends HtmlTag {
    private String name;
    private boolean insertCR = false;
    private boolean isXml = false;
    private HashMap<String, String> attributes;

    public VoidElement(String string) {
        this(string, false, false);
    }

    public VoidElement(String string, boolean bl, boolean bl2) {
        super(bl2 ? String.format("<%s/>", string) : String.format("<%s>", string));
        if (string.contains("[^a-zA-Z]")) {
            throw new IllegalArgumentException(String.format("Invalid element name '%s'", string));
        }
        this.name = string;
        this.insertCR = bl;
        this.isXml = bl2;
    }

    @Override
    public Object clone() {
        VoidElement voidElement = new VoidElement(this.getName(), this.insertCR, this.isXml);
        if (this.attributes != null) {
            voidElement.attributes = new HashMap();
            voidElement.attributes.putAll(this.attributes);
        }
        return voidElement;
    }

    @Override
    public String toString(TeXParser teXParser) {
        return this.toString();
    }

    @Override
    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        if (this.insertCR) {
            stringBuilder.append(String.format("%n", new Object[0]));
        }
        stringBuilder.append(String.format("<%s", this.name));
        if (this.attributes != null) {
            for (String string : this.attributes.keySet()) {
                String string2 = this.attributes.get(string);
                stringBuilder.append(String.format(" %s=\"%s\"", string, string2));
            }
        }
        if (this.isXml) {
            stringBuilder.append("/");
        }
        stringBuilder.append(">");
        return stringBuilder.toString();
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        Writeable writeable = teXParser.getListener().getWriteable();
        if (this.insertCR) {
            writeable.writeliteralln("");
        }
        if (this.attributes == null || this.attributes.isEmpty()) {
            writeable.writeliteral(this.getTag());
        } else {
            writeable.writeliteral("<" + this.name);
            for (String string : this.attributes.keySet()) {
                String string2 = this.attributes.get(string);
                writeable.writeliteral(String.format(" %s=\"%s\"", string, string2));
            }
            if (this.isXml) {
                writeable.writeliteral("/");
            }
            writeable.writeliteral(">");
        }
    }

    public String getName() {
        return this.name;
    }

    public String removeAttribute(String string) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.remove(string);
    }

    public String getAttribute(String string) {
        if (this.attributes == null) {
            return null;
        }
        return this.attributes.get(string);
    }

    public boolean hasAttribute(String string) {
        if (this.attributes == null) {
            return false;
        }
        return this.attributes.containsKey(string);
    }

    public void putAttribute(String string, String string2) {
        if (this.attributes == null) {
            this.attributes = new HashMap();
        }
        this.attributes.put(string, string2);
    }

    public void putStyle(L2HConverter l2HConverter, HashMap<String, String> hashMap) {
        String string = l2HConverter.getCssClass(hashMap);
        if (string == null) {
            this.putAttribute("style", l2HConverter.cssAttributesToString(hashMap));
        } else {
            this.putAttribute("class", string);
        }
    }
}

