/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.GenericCommand;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserUtils;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import java.io.IOException;

public class Begin
extends ControlSequence {
    public Begin() {
        this("begin");
    }

    public Begin(String string) {
        super(string);
    }

    @Override
    public Object clone() {
        return new Begin(this.getName());
    }

    protected void beginHook(String string, TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
    }

    protected void doBegin(TeXParser teXParser, TeXObjectList teXObjectList, String string) throws IOException {
        ControlSequence controlSequence = teXParser.getListener().getControlSequence(string);
        TeXParserUtils.process(controlSequence, teXParser, teXObjectList);
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        LaTeXParserListener laTeXParserListener = (LaTeXParserListener)teXParser.getListener();
        String string = this.popLabelString(teXParser, teXObjectList);
        if (teXParser.isDebugMode(4)) {
            teXParser.logMessage("BEGIN ENV: " + string);
        }
        this.beginHook(string, teXParser, teXObjectList);
        if (string.equals("document")) {
            laTeXParserListener.beginDocument(teXObjectList);
            return;
        }
        if (laTeXParserListener.isVerbEnv(string)) {
            ControlSequence controlSequence = laTeXParserListener.getControlSequence(string);
            TeXObjectList teXObjectList2 = new TeXObjectList();
            while (true) {
                TeXObject teXObject;
                if ((teXObject = teXObjectList.pop()) == null) {
                    teXParser.debugMessage(1, "End of stack found while peeking in " + string);
                }
                if (teXObject instanceof ControlSequence && ((ControlSequence)teXObject).getName().equals("end")) {
                    ControlSequence controlSequence2 = (ControlSequence)teXObject;
                    teXObject = teXObjectList.peekStack();
                    if (teXParser.isBeginGroup(teXObject) != null) {
                        TeXObject teXObject2 = this.popArg(teXParser, teXObjectList);
                        if (!string.equals(teXObject2.toString(teXParser))) continue;
                        break;
                    }
                    teXObjectList2.add(controlSequence2);
                    continue;
                }
                teXObjectList2.add(teXObject);
            }
            controlSequence.process(teXParser, teXObjectList2);
            return;
        }
        teXParser.startGroup();
        teXParser.putControlSequence(true, new GenericCommand(true, "@currenvir", null, teXParser.getListener().createString(string)));
        if (teXObjectList == null) {
            this.doBegin(teXParser, teXParser, string);
        } else {
            this.doBegin(teXParser, teXObjectList, string);
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }
}

