/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.Command;
import com.dickimawbooks.texparserlib.Expandable;
import com.dickimawbooks.texparserlib.TeXNumber;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.LaTeXParserListener;
import com.dickimawbooks.texparserlib.latex.Overwrite;
import java.io.IOException;

public class NewEnvironment
extends Command {
    private Overwrite overwrite = Overwrite.FORBID;

    public NewEnvironment() {
        this("newenvironment", Overwrite.FORBID);
    }

    public NewEnvironment(String string, Overwrite overwrite) {
        super(string);
        this.overwrite = overwrite;
    }

    @Override
    public Object clone() {
        return new NewEnvironment(this.getName(), this.getOverwrite());
    }

    @Override
    public boolean canExpand() {
        return false;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public TeXObjectList expandfully(TeXParser teXParser) throws IOException {
        return null;
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXObject teXObject;
        String string = this.popLabelString(teXParser, teXObjectList);
        TeXObject teXObject2 = this.popOptArg(teXParser, teXObjectList);
        int n = 0;
        TeXObject teXObject3 = null;
        if (teXObject2 != null) {
            if (teXObject2 instanceof TeXNumber) {
                n = ((TeXNumber)teXObject2).getValue();
            } else {
                teXObject = null;
                if (teXObject2 instanceof Expandable) {
                    teXObject = ((Expandable)((Object)teXObject2)).expandfully(teXParser, teXObjectList);
                }
                try {
                    n = teXObject == null ? Integer.parseInt(teXObject2.toString(teXParser)) : Integer.parseInt(((TeXObjectList)teXObject).toString(teXParser));
                }
                catch (NumberFormatException numberFormatException) {
                    throw new TeXSyntaxException(teXParser, "tex.error.number_expected", teXObject2.toString(teXParser));
                }
            }
            teXObject3 = this.popOptArg(teXParser, teXObjectList);
        }
        teXObject = this.popArg(teXParser, teXObjectList);
        TeXObject teXObject4 = this.popArg(teXParser, teXObjectList);
        ((LaTeXParserListener)teXParser.getListener()).newenvironment(this.overwrite, this.name, string, n, teXObject3, teXObject, teXObject4);
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }

    public Overwrite getOverwrite() {
        return this.overwrite;
    }
}

