/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex;

import com.dickimawbooks.texparserlib.TeXDimension;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.latex.AlignHStyle;
import com.dickimawbooks.texparserlib.latex.AlignVStyle;
import com.dickimawbooks.texparserlib.latex.BorderStyle;
import com.dickimawbooks.texparserlib.latex.FrameBox;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import java.io.IOException;

public class ParBox
extends FrameBox {
    public ParBox() {
        this("parbox");
    }

    public ParBox(String string) {
        this(string, BorderStyle.NONE, null, null);
    }

    public ParBox(String string, BorderStyle borderStyle, TeXDimension teXDimension, TeXDimension teXDimension2) {
        super(string, borderStyle, AlignHStyle.DEFAULT, AlignVStyle.DEFAULT, true, true, teXDimension, teXDimension2);
    }

    @Override
    public FrameBox createBox() {
        return new ParBox(this.getName());
    }

    @Override
    public TeXDimension getBorderWidth(TeXParser teXParser) throws IOException {
        return this.currentBorderWidth;
    }

    @Override
    public TeXDimension getInnerMargin(TeXParser teXParser) throws IOException {
        return this.currentInnerMargin;
    }

    protected AlignVStyle getAlignVStyle(TeXParser teXParser, String string) throws LaTeXSyntaxException {
        if (string.equals("c")) {
            return AlignVStyle.MIDDLE;
        }
        if (string.equals("t")) {
            return AlignVStyle.TOP;
        }
        if (string.equals("b")) {
            return AlignVStyle.BOTTOM;
        }
        throw new LaTeXSyntaxException(teXParser, "latex.illegal.argtype", string);
    }

    @Override
    protected void popSettings(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        String string = this.popOptLabelString(teXParser, teXObjectList);
        if (string != null) {
            this.valign = this.getAlignVStyle(teXParser, string);
            TeXDimension teXDimension = this.popOptDimensionArg(teXParser, teXObjectList);
            if (teXDimension != null) {
                this.currentHeight = teXDimension;
            }
        }
        this.currentWidth = this.popDimensionArg(teXParser, teXObjectList);
    }
}

