/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.glossaries;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.TeXObject;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.latex.LaTeXSyntaxException;
import com.dickimawbooks.texparserlib.latex.Overwrite;
import com.dickimawbooks.texparserlib.latex.glossaries.AbstractGlsCommand;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossariesSty;
import com.dickimawbooks.texparserlib.latex.glossaries.GlsEntryField;
import java.io.IOException;

public class GlsAddStorageKey
extends AbstractGlsCommand {
    protected Overwrite overwrite;

    public GlsAddStorageKey(GlossariesSty glossariesSty) {
        this("glsaddstoragekey", glossariesSty);
    }

    public GlsAddStorageKey(String string, GlossariesSty glossariesSty) {
        this(string, Overwrite.FORBID, glossariesSty);
    }

    public GlsAddStorageKey(String string, Overwrite overwrite, GlossariesSty glossariesSty) {
        super(string, glossariesSty);
        this.overwrite = overwrite;
    }

    @Override
    public Object clone() {
        return new GlsAddStorageKey(this.getName(), this.getOverwrite(), this.getSty());
    }

    public Overwrite getOverwrite() {
        return this.overwrite;
    }

    @Override
    public boolean canExpand() {
        return false;
    }

    @Override
    public TeXObjectList expandonce(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        return null;
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        boolean bl = this.popModifier(teXParser, teXObjectList, 42) == 42;
        String string = this.popLabelString(teXParser, teXObjectList);
        TeXObject teXObject = this.popArg(teXParser, teXObjectList);
        TeXObject teXObject2 = this.popArg(teXParser, teXObjectList);
        ControlSequence controlSequence = null;
        if (teXParser.isStack(teXObject2) && !teXObject2.isEmpty()) {
            controlSequence = this.popControlSequence(teXParser, (TeXObjectList)teXObject2);
        }
        if (controlSequence != null) {
            String string2 = controlSequence.getName();
            switch (this.overwrite) {
                case FORBID: {
                    if (teXParser.getControlSequence(string2) == null) break;
                    throw new LaTeXSyntaxException(teXParser, "latex.error.defined", string2);
                }
                case SKIP: {
                    if (teXParser.getControlSequence(string2) == null) break;
                    return;
                }
            }
            teXParser.putControlSequence(new GlsEntryField(string2, string, this.getSty()));
        }
        this.sty.addField(string, teXObject);
        if (bl) {
            this.sty.setFieldExpansionOn(string, true);
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }
}

