/*
 * Decompiled with CFR 0.152.
 */
package com.dickimawbooks.texparserlib.latex.glossaries;

import com.dickimawbooks.texparserlib.ControlSequence;
import com.dickimawbooks.texparserlib.TeXObjectList;
import com.dickimawbooks.texparserlib.TeXParser;
import com.dickimawbooks.texparserlib.TeXParserListener;
import com.dickimawbooks.texparserlib.TeXPath;
import com.dickimawbooks.texparserlib.latex.KeyValList;
import com.dickimawbooks.texparserlib.latex.glossaries.GlossariesSty;
import com.dickimawbooks.texparserlib.latex.glossaries.Glossary;
import java.io.IOException;

public class PrintGlossary
extends ControlSequence {
    private String ext = "gls";
    private GlossariesSty sty;

    public PrintGlossary(GlossariesSty glossariesSty) {
        this("printglossary", glossariesSty);
    }

    public PrintGlossary(String string, GlossariesSty glossariesSty) {
        super(string);
        this.sty = glossariesSty;
    }

    @Override
    public Object clone() {
        return new PrintGlossary(this.getName(), this.sty);
    }

    protected void initOptions(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        KeyValList keyValList = this.sty.popOptKeyValList(teXObjectList);
        Glossary glossary = this.sty.initPrintGloss(keyValList, teXObjectList);
        this.ext = glossary.getGls();
        if (this.ext == null) {
            throw new NullPointerException();
        }
    }

    @Override
    public void process(TeXParser teXParser, TeXObjectList teXObjectList) throws IOException {
        TeXParserListener teXParserListener = teXParser.getListener();
        teXParser.startGroup();
        this.initOptions(teXParser, teXObjectList);
        ControlSequence controlSequence = teXParserListener.getControlSequence("jobname");
        String string = teXParser.expandToString(controlSequence, teXObjectList);
        TeXPath teXPath = new TeXPath(teXParser, string, this.ext, false);
        teXObjectList.push(teXParserListener.getControlSequence("endgroup"));
        if (teXPath.exists()) {
            teXParserListener.addFileReference(teXPath);
            teXParserListener.input(teXPath, teXObjectList);
        }
    }

    @Override
    public void process(TeXParser teXParser) throws IOException {
        this.process(teXParser, teXParser);
    }
}

