/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.colormath.model;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.colormath.ColorComponentInfo;
import com.github.ajalt.colormath.ColorSpace;
import com.github.ajalt.colormath.HueColor;
import com.github.ajalt.colormath.internal.ColorSpaceUtilsKt;
import com.github.ajalt.colormath.model.Ansi16;
import com.github.ajalt.colormath.model.Ansi256;
import com.github.ajalt.colormath.model.CMYK;
import com.github.ajalt.colormath.model.HPLuv;
import com.github.ajalt.colormath.model.HSL;
import com.github.ajalt.colormath.model.HSV;
import com.github.ajalt.colormath.model.HUSLColorConverter;
import com.github.ajalt.colormath.model.HWB;
import com.github.ajalt.colormath.model.ICtCp;
import com.github.ajalt.colormath.model.JzAzBz;
import com.github.ajalt.colormath.model.JzCzHz;
import com.github.ajalt.colormath.model.LAB;
import com.github.ajalt.colormath.model.LCHab;
import com.github.ajalt.colormath.model.LCHuv;
import com.github.ajalt.colormath.model.LUV;
import com.github.ajalt.colormath.model.Oklab;
import com.github.ajalt.colormath.model.Oklch;
import com.github.ajalt.colormath.model.RGB;
import com.github.ajalt.colormath.model.XYZ;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.ArraysKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.SourceDebugExtension;
import kotlin.ranges.RangesKt;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000\\\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0004\n\u0002\b\u0004\n\u0002\u0010\u0007\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\t\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\u0000\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0010\u0014\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000e\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\b\u0018\u0000 ,2\u00020\u0001:\u0001,B)\b\u0016\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0003\u0012\u0006\u0010\u0005\u001a\u00020\u0003\u0012\b\b\u0002\u0010\u0006\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0007B'\u0012\u0006\u0010\u0002\u001a\u00020\b\u0012\u0006\u0010\u0004\u001a\u00020\b\u0012\u0006\u0010\u0005\u001a\u00020\b\u0012\b\b\u0002\u0010\u0006\u001a\u00020\b\u00a2\u0006\u0002\u0010\tJ\b\u0010\u0013\u001a\u00020\u0000H\u0016J\t\u0010\u0014\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0015\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0016\u001a\u00020\bH\u00c6\u0003J\t\u0010\u0017\u001a\u00020\bH\u00c6\u0003J1\u0010\u0018\u001a\u00020\u00002\b\b\u0002\u0010\u0002\u001a\u00020\b2\b\b\u0002\u0010\u0004\u001a\u00020\b2\b\b\u0002\u0010\u0005\u001a\u00020\b2\b\b\u0002\u0010\u0006\u001a\u00020\bH\u00c6\u0001J\u0013\u0010\u0019\u001a\u00020\u001a2\b\u0010\u001b\u001a\u0004\u0018\u00010\u001cH\u00d6\u0003J\t\u0010\u001d\u001a\u00020\u001eH\u00d6\u0001J\b\u0010\u001f\u001a\u00020 H\u0016J\b\u0010!\u001a\u00020\u0000H\u0016J\b\u0010\"\u001a\u00020#H\u0016J\b\u0010$\u001a\u00020%H\u0016J\b\u0010&\u001a\u00020'H\u0016J\t\u0010(\u001a\u00020)H\u00d6\u0001J\b\u0010*\u001a\u00020+H\u0016R\u0014\u0010\u0006\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\n\u0010\u000bR\u0014\u0010\u0002\u001a\u00020\bX\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\f\u0010\u000bR\u0011\u0010\u0005\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\r\u0010\u000bR\u0011\u0010\u0004\u001a\u00020\b\u00a2\u0006\b\n\u0000\u001a\u0004\b\u000e\u0010\u000bR\u001a\u0010\u000f\u001a\b\u0012\u0004\u0012\u00020\u00000\u00108VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u0011\u0010\u0012\u00a8\u0006-"}, d2={"Lcom/github/ajalt/colormath/model/HSLuv;", "Lcom/github/ajalt/colormath/HueColor;", "h", "", "s", "l", "alpha", "(Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;Ljava/lang/Number;)V", "", "(FFFF)V", "getAlpha", "()F", "getH", "getL", "getS", "space", "Lcom/github/ajalt/colormath/ColorSpace;", "getSpace", "()Lcom/github/ajalt/colormath/ColorSpace;", "clamp", "component1", "component2", "component3", "component4", "copy", "equals", "", "other", "", "hashCode", "", "toArray", "", "toHSLuv", "toLCHuv", "Lcom/github/ajalt/colormath/model/LCHuv;", "toLUV", "Lcom/github/ajalt/colormath/model/LUV;", "toSRGB", "Lcom/github/ajalt/colormath/model/RGB;", "toString", "", "toXYZ", "Lcom/github/ajalt/colormath/model/XYZ;", "Companion", "colormath"})
@SourceDebugExtension(value={"SMAP\nHSLuv.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HSLuv.kt\ncom/github/ajalt/colormath/model/HSLuv\n+ 2 ColorSpaceUtils.kt\ncom/github/ajalt/colormath/internal/ColorSpaceUtilsKt\n*L\n1#1,104:1\n112#2,12:105\n*S KotlinDebug\n*F\n+ 1 HSLuv.kt\ncom/github/ajalt/colormath/model/HSLuv\n*L\n55#1:105,12\n*E\n"})
public final class HSLuv
implements HueColor {
    @NotNull
    public static final Companion Companion = new Companion(null);
    private final float h;
    private final float s;
    private final float l;
    private final float alpha;
    @NotNull
    private static final List<ColorComponentInfo> components = ColorSpaceUtilsKt.polarComponentInfo("HSL", 0.0f, 100.0f);

    public HSLuv(float h, float s, float l, float alpha) {
        this.h = h;
        this.s = s;
        this.l = l;
        this.alpha = alpha;
    }

    public /* synthetic */ HSLuv(float f, float f2, float f3, float f4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            f4 = 1.0f;
        }
        this(f, f2, f3, f4);
    }

    @Override
    public float getH() {
        return this.h;
    }

    public final float getS() {
        return this.s;
    }

    public final float getL() {
        return this.l;
    }

    @Override
    public float getAlpha() {
        return this.alpha;
    }

    public HSLuv(@NotNull Number h, @NotNull Number s, @NotNull Number l, @NotNull Number alpha) {
        Intrinsics.checkNotNullParameter(h, "h");
        Intrinsics.checkNotNullParameter(s, "s");
        Intrinsics.checkNotNullParameter(l, "l");
        Intrinsics.checkNotNullParameter(alpha, "alpha");
        this(h.floatValue(), s.floatValue(), l.floatValue(), alpha.floatValue());
    }

    public /* synthetic */ HSLuv(Number number, Number number2, Number number3, Number number4, int n, DefaultConstructorMarker defaultConstructorMarker) {
        if ((n & 8) != 0) {
            number4 = Float.valueOf(1.0f);
        }
        this(number, number2, number3, number4);
    }

    @NotNull
    public ColorSpace<HSLuv> getSpace() {
        return Companion;
    }

    @Override
    @NotNull
    public LCHuv toLCHuv() {
        if ((double)this.l > 99.9999) {
            return LCHuv.Companion.invoke(100.0f, 0.0f, this.getH(), this.getAlpha());
        }
        if ((double)this.l < 1.0E-5) {
            return LCHuv.Companion.invoke(0.0f, 0.0f, this.getH(), this.getAlpha());
        }
        double max2 = HUSLColorConverter.INSTANCE.maxChromaForLH(this.l, this.getH());
        double c = max2 / (double)100 * (double)this.s;
        return LCHuv.Companion.invoke(this.l, (float)c, this.getH(), this.getAlpha());
    }

    @Override
    @NotNull
    public RGB toSRGB() {
        return this.toXYZ().toSRGB();
    }

    @Override
    @NotNull
    public LUV toLUV() {
        return this.toLCHuv().toLUV();
    }

    @Override
    @NotNull
    public XYZ toXYZ() {
        return this.toLCHuv().toXYZ();
    }

    @Override
    @NotNull
    public HSLuv toHSLuv() {
        return this;
    }

    @Override
    @NotNull
    public float[] toArray() {
        float[] fArray = new float[]{this.getH(), this.s, this.l, this.getAlpha()};
        return fArray;
    }

    /*
     * WARNING - void declaration
     * Enabled aggressive block sorting
     */
    @Override
    @NotNull
    public HSLuv clamp() {
        void p3;
        void p2;
        void p1;
        Color color;
        void v3$iv;
        void v2$iv;
        void v1$iv;
        void $this$clampLeadingHue$iv;
        Color color2 = this;
        float f = this.getH();
        float f2 = this.s;
        float f3 = this.l;
        float alpha$iv = this.getAlpha();
        boolean $i$f$clampLeadingHue = false;
        List<ColorComponentInfo> list = $this$clampLeadingHue$iv.getSpace().getComponents();
        ColorComponentInfo c1$iv = list.get(0);
        ColorComponentInfo c2$iv = list.get(1);
        ColorComponentInfo c3$iv = list.get(2);
        float f4 = c1$iv.getMin();
        boolean bl = v1$iv <= c1$iv.getMax() ? f4 <= v1$iv : false;
        if (bl) {
            f4 = c2$iv.getMin();
            boolean bl2 = v2$iv <= c2$iv.getMax() ? f4 <= v2$iv : false;
            if (bl2) {
                f4 = c3$iv.getMin();
                boolean bl3 = v3$iv <= c3$iv.getMax() ? f4 <= v3$iv : false;
                if (bl3) {
                    boolean bl4 = 0.0f <= alpha$iv ? alpha$iv <= 1.0f : false;
                    if (bl4) {
                        color = $this$clampLeadingHue$iv;
                        return (HSLuv)color;
                    }
                }
            }
        }
        float f5 = RangesKt.coerceIn(alpha$iv, 0.0f, 1.0f);
        float f6 = RangesKt.coerceIn((float)v3$iv, c3$iv.getMin(), c3$iv.getMax());
        float f7 = RangesKt.coerceIn((float)v2$iv, c2$iv.getMin(), c2$iv.getMax());
        void p0 = v1$iv % (float)360;
        boolean bl5 = false;
        color = this.copy((float)p0, (float)p1, (float)p2, (float)p3);
        return (HSLuv)color;
    }

    @Override
    @NotNull
    public HSL toHSL() {
        return HueColor.DefaultImpls.toHSL(this);
    }

    @Override
    @NotNull
    public HSV toHSV() {
        return HueColor.DefaultImpls.toHSV(this);
    }

    @Override
    @NotNull
    public Ansi16 toAnsi16() {
        return HueColor.DefaultImpls.toAnsi16(this);
    }

    @Override
    @NotNull
    public Ansi256 toAnsi256() {
        return HueColor.DefaultImpls.toAnsi256(this);
    }

    @Override
    @NotNull
    public CMYK toCMYK() {
        return HueColor.DefaultImpls.toCMYK(this);
    }

    @Override
    @NotNull
    public LAB toLAB() {
        return HueColor.DefaultImpls.toLAB(this);
    }

    @Override
    @NotNull
    public LCHab toLCHab() {
        return HueColor.DefaultImpls.toLCHab(this);
    }

    @Override
    @NotNull
    public HWB toHWB() {
        return HueColor.DefaultImpls.toHWB(this);
    }

    @Override
    @NotNull
    public Oklab toOklab() {
        return HueColor.DefaultImpls.toOklab(this);
    }

    @Override
    @NotNull
    public Oklch toOklch() {
        return HueColor.DefaultImpls.toOklch(this);
    }

    @Override
    @NotNull
    public JzAzBz toJzAzBz() {
        return HueColor.DefaultImpls.toJzAzBz(this);
    }

    @Override
    @NotNull
    public JzCzHz toJzCzHz() {
        return HueColor.DefaultImpls.toJzCzHz(this);
    }

    @Override
    @NotNull
    public ICtCp toICtCp() {
        return HueColor.DefaultImpls.toICtCp(this);
    }

    @Override
    @NotNull
    public HPLuv toHPLuv() {
        return HueColor.DefaultImpls.toHPLuv(this);
    }

    public final float component1() {
        return this.h;
    }

    public final float component2() {
        return this.s;
    }

    public final float component3() {
        return this.l;
    }

    public final float component4() {
        return this.alpha;
    }

    @NotNull
    public final HSLuv copy(float h, float s, float l, float alpha) {
        return new HSLuv(h, s, l, alpha);
    }

    public static /* synthetic */ HSLuv copy$default(HSLuv hSLuv, float f, float f2, float f3, float f4, int n, Object object) {
        if ((n & 1) != 0) {
            f = hSLuv.h;
        }
        if ((n & 2) != 0) {
            f2 = hSLuv.s;
        }
        if ((n & 4) != 0) {
            f3 = hSLuv.l;
        }
        if ((n & 8) != 0) {
            f4 = hSLuv.alpha;
        }
        return hSLuv.copy(f, f2, f3, f4);
    }

    @NotNull
    public String toString() {
        return "HSLuv(h=" + this.h + ", s=" + this.s + ", l=" + this.l + ", alpha=" + this.alpha + ')';
    }

    public int hashCode() {
        int result2 = Float.hashCode(this.h);
        result2 = result2 * 31 + Float.hashCode(this.s);
        result2 = result2 * 31 + Float.hashCode(this.l);
        result2 = result2 * 31 + Float.hashCode(this.alpha);
        return result2;
    }

    public boolean equals(@Nullable Object other) {
        if (this == other) {
            return true;
        }
        if (!(other instanceof HSLuv)) {
            return false;
        }
        HSLuv hSLuv = (HSLuv)other;
        if (Float.compare(this.h, hSLuv.h) != 0) {
            return false;
        }
        if (Float.compare(this.s, hSLuv.s) != 0) {
            return false;
        }
        if (Float.compare(this.l, hSLuv.l) != 0) {
            return false;
        }
        return Float.compare(this.alpha, hSLuv.alpha) == 0;
    }

    @Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u00000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u000e\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u0014\n\u0000\b\u0086\u0003\u0018\u00002\b\u0012\u0004\u0012\u00020\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0003J\u0010\u0010\r\u001a\u00020\u00022\u0006\u0010\u000e\u001a\u00020\u000fH\u0016J\u0010\u0010\u0010\u001a\u00020\u00022\u0006\u0010\u0004\u001a\u00020\u0011H\u0016R\u001a\u0010\u0004\u001a\b\u0012\u0004\u0012\u00020\u00060\u0005X\u0096\u0004\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0007\u0010\bR\u0014\u0010\t\u001a\u00020\n8VX\u0096\u0004\u00a2\u0006\u0006\u001a\u0004\b\u000b\u0010\f\u00a8\u0006\u0012"}, d2={"Lcom/github/ajalt/colormath/model/HSLuv$Companion;", "Lcom/github/ajalt/colormath/ColorSpace;", "Lcom/github/ajalt/colormath/model/HSLuv;", "()V", "components", "", "Lcom/github/ajalt/colormath/ColorComponentInfo;", "getComponents", "()Ljava/util/List;", "name", "", "getName", "()Ljava/lang/String;", "convert", "color", "Lcom/github/ajalt/colormath/Color;", "create", "", "colormath"})
    @SourceDebugExtension(value={"SMAP\nHSLuv.kt\nKotlin\n*S Kotlin\n*F\n+ 1 HSLuv.kt\ncom/github/ajalt/colormath/model/HSLuv$Companion\n+ 2 ColorSpaceUtils.kt\ncom/github/ajalt/colormath/internal/ColorSpaceUtilsKt\n+ 3 fake.kt\nkotlin/jvm/internal/FakeKt\n*L\n1#1,104:1\n26#2:105\n15#2,13:106\n1#3:119\n*S KotlinDebug\n*F\n+ 1 HSLuv.kt\ncom/github/ajalt/colormath/model/HSLuv$Companion\n*L\n34#1:105\n34#1:106,13\n34#1:119\n*E\n"})
    public static final class Companion
    implements ColorSpace<HSLuv> {
        private Companion() {
        }

        @Override
        @NotNull
        public String getName() {
            return "HSLuv";
        }

        @Override
        @NotNull
        public List<ColorComponentInfo> getComponents() {
            return components;
        }

        @Override
        @NotNull
        public HSLuv convert(@NotNull Color color) {
            Intrinsics.checkNotNullParameter(color, "color");
            return color.toHSLuv();
        }

        /*
         * WARNING - void declaration
         */
        @Override
        @NotNull
        public HSLuv create(@NotNull float[] components) {
            void p3;
            void p2;
            void p1;
            float f;
            Intrinsics.checkNotNullParameter(components, "components");
            ColorSpace $this$doCreate$iv = this;
            boolean $i$f$doCreate = false;
            ColorSpace $this$withValidComps$iv$iv = $this$doCreate$iv;
            boolean $i$f$withValidComps = false;
            int size$iv$iv = $this$withValidComps$iv$iv.getComponents().size();
            int n = size$iv$iv - 1;
            int n2 = components.length;
            if (!(n <= n2 ? n2 <= size$iv$iv : false)) {
                boolean bl = false;
                String string = "Invalid component array length: " + components.length + ", expected " + (size$iv$iv - 1) + " or " + size$iv$iv;
                throw new IllegalArgumentException(string.toString());
            }
            float[] it$iv = components;
            boolean bl = false;
            float f2 = components[0];
            float f3 = components[1];
            float f4 = components[2];
            int n3 = 3;
            float[] fArray = components;
            if (n3 <= ArraysKt.getLastIndex(fArray)) {
                f = fArray[n3];
            } else {
                int n4 = n3;
                float f5 = f4;
                float f6 = f3;
                float f7 = f2;
                boolean bl2 = false;
                float f8 = 1.0f;
                f2 = f7;
                f3 = f6;
                f4 = f5;
                f = f8;
            }
            float f9 = f;
            float f10 = f4;
            float f11 = f3;
            float p0 = f2;
            boolean bl3 = false;
            return (HSLuv)((Color)new HSLuv(p0, (float)p1, (float)p2, (float)p3));
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

