/*
 * Decompiled with CFR 0.152.
 */
package com.github.ajalt.mordant.terminal;

import com.github.ajalt.colormath.Color;
import com.github.ajalt.mordant.internal.AnsiRenderKt;
import com.github.ajalt.mordant.internal.ConstantsKt;
import com.github.ajalt.mordant.rendering.AnsiLevel;
import com.github.ajalt.mordant.rendering.TextColors;
import com.github.ajalt.mordant.rendering.TextStyle;
import com.github.ajalt.mordant.rendering.TextStyles;
import com.github.ajalt.mordant.rendering.Theme;
import com.github.ajalt.mordant.terminal.TerminalInfo;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 9, 0}, k=1, xi=48, d1={"\u0000H\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b%\n\u0002\u0018\u0002\n\u0002\b\u0018\n\u0002\u0010\b\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\u0004\n\u0002\b\r\n\u0002\u0010\u000e\n\u0002\b\u0004\u0018\u00002\u00020\u0001B\u0017\b\u0000\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u0012\u0006\u0010\u0004\u001a\u00020\u0005\u00a2\u0006\u0002\u0010\u0006J&\u0010E\u001a\u00020\b2\u0006\u0010F\u001a\u00020G2\u0006\u0010H\u001a\u00020G2\u0006\u0010I\u001a\u00020G2\u0006\u0010J\u001a\u00020GJ\u000e\u0010K\u001a\u00020\b2\u0006\u0010K\u001a\u00020LJ\u0010\u0010M\u001a\u00020\b2\u0006\u0010N\u001a\u00020\bH\u0002J\u000e\u0010#\u001a\u00020\b2\u0006\u0010O\u001a\u00020PJ\u001e\u0010Q\u001a\u00020\b2\u0006\u0010R\u001a\u00020P2\u0006\u0010S\u001a\u00020P2\u0006\u0010T\u001a\u00020PJ\u001e\u0010U\u001a\u00020\b2\u0006\u0010R\u001a\u00020P2\u0006\u0010S\u001a\u00020P2\u0006\u0010V\u001a\u00020PJ\u001e\u0010W\u001a\u00020\b2\u0006\u0010T\u001a\u00020P2\u0006\u0010X\u001a\u00020P2\u0006\u0010Y\u001a\u00020PJ\u001e\u0010Z\u001a\u00020\b2\u0006\u0010[\u001a\u00020P2\u0006\u0010\\\u001a\u00020P2\u0006\u0010Y\u001a\u00020PJ\u000e\u0010Z\u001a\u00020\b2\u0006\u0010]\u001a\u00020^J\u001e\u0010_\u001a\u00020\b2\u0006\u0010`\u001a\u00020P2\u0006\u0010I\u001a\u00020P2\u0006\u0010a\u001a\u00020PR\u0011\u0010\u0007\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\t\u0010\nR\u0011\u0010\u000b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\f\u0010\nR\u0011\u0010\r\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u000e\u0010\nR\u0011\u0010\u000f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0010\u0010\nR\u0011\u0010\u0011\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0012\u0010\nR\u0011\u0010\u0013\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0014\u0010\nR\u0011\u0010\u0015\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0016\u0010\nR\u0011\u0010\u0017\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u0018\u0010\nR\u0011\u0010\u0019\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001a\u0010\nR\u0011\u0010\u001b\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001c\u0010\nR\u0011\u0010\u001d\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\u001e\u0010\nR\u0011\u0010\u001f\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b \u0010\nR\u0011\u0010!\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b\"\u0010\nR\u0011\u0010#\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b$\u0010\nR\u0011\u0010%\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b&\u0010\nR\u0011\u0010'\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b(\u0010\nR\u0011\u0010)\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b*\u0010\nR\u0011\u0010+\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b,\u0010\nR\u0014\u0010-\u001a\u00020.8BX\u0082\u0004\u00a2\u0006\u0006\u001a\u0004\b/\u00100R\u0011\u00101\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b2\u0010\nR\u0011\u00103\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b4\u0010\nR\u0011\u00105\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b6\u0010\nR\u0011\u00107\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b8\u0010\nR\u0011\u00109\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b:\u0010\nR\u0011\u0010;\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b<\u0010\nR\u000e\u0010\u0002\u001a\u00020\u0003X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0004\u001a\u00020\u0005X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u0011\u0010=\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b>\u0010\nR\u0011\u0010?\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\b@\u0010\nR\u0011\u0010A\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\bB\u0010\nR\u0011\u0010C\u001a\u00020\b8F\u00a2\u0006\u0006\u001a\u0004\bD\u0010\n\u00a8\u0006b"}, d2={"Lcom/github/ajalt/mordant/terminal/TerminalColors;", "", "terminalInfo", "Lcom/github/ajalt/mordant/terminal/TerminalInfo;", "theme", "Lcom/github/ajalt/mordant/rendering/Theme;", "(Lcom/github/ajalt/mordant/terminal/TerminalInfo;Lcom/github/ajalt/mordant/rendering/Theme;)V", "black", "Lcom/github/ajalt/mordant/rendering/TextStyle;", "getBlack", "()Lcom/github/ajalt/mordant/rendering/TextStyle;", "blue", "getBlue", "bold", "getBold", "brightBlue", "getBrightBlue", "brightCyan", "getBrightCyan", "brightGreen", "getBrightGreen", "brightMagenta", "getBrightMagenta", "brightRed", "getBrightRed", "brightWhite", "getBrightWhite", "brightYellow", "getBrightYellow", "cyan", "getCyan", "danger", "getDanger", "dim", "getDim", "gray", "getGray", "green", "getGreen", "info", "getInfo", "inverse", "getInverse", "italic", "getItalic", "level", "Lcom/github/ajalt/mordant/rendering/AnsiLevel;", "getLevel", "()Lcom/github/ajalt/mordant/rendering/AnsiLevel;", "magenta", "getMagenta", "muted", "getMuted", "plain", "getPlain", "red", "getRed", "strikethrough", "getStrikethrough", "success", "getSuccess", "underline", "getUnderline", "warning", "getWarning", "white", "getWhite", "yellow", "getYellow", "cmyk", "c", "", "m", "y", "k", "color", "Lcom/github/ajalt/colormath/Color;", "downsample", "style", "fraction", "", "hsl", "h", "s", "l", "hsv", "v", "lab", "a", "b", "rgb", "r", "g", "hex", "", "xyz", "x", "z", "mordant"})
public final class TerminalColors {
    @NotNull
    private final TerminalInfo terminalInfo;
    @NotNull
    private final Theme theme;

    public TerminalColors(@NotNull TerminalInfo terminalInfo, @NotNull Theme theme) {
        Intrinsics.checkNotNullParameter(terminalInfo, "terminalInfo");
        Intrinsics.checkNotNullParameter(theme, "theme");
        this.terminalInfo = terminalInfo;
        this.theme = theme;
    }

    @NotNull
    public final TextStyle getBlack() {
        return this.downsample(TextColors.black);
    }

    @NotNull
    public final TextStyle getRed() {
        return this.downsample(TextColors.red);
    }

    @NotNull
    public final TextStyle getGreen() {
        return this.downsample(TextColors.green);
    }

    @NotNull
    public final TextStyle getYellow() {
        return this.downsample(TextColors.yellow);
    }

    @NotNull
    public final TextStyle getBlue() {
        return this.downsample(TextColors.blue);
    }

    @NotNull
    public final TextStyle getMagenta() {
        return this.downsample(TextColors.magenta);
    }

    @NotNull
    public final TextStyle getCyan() {
        return this.downsample(TextColors.cyan);
    }

    @NotNull
    public final TextStyle getWhite() {
        return this.downsample(TextColors.white);
    }

    @NotNull
    public final TextStyle getGray() {
        return this.downsample(TextColors.gray);
    }

    @NotNull
    public final TextStyle getBrightRed() {
        return this.downsample(TextColors.brightRed);
    }

    @NotNull
    public final TextStyle getBrightGreen() {
        return this.downsample(TextColors.brightGreen);
    }

    @NotNull
    public final TextStyle getBrightYellow() {
        return this.downsample(TextColors.brightYellow);
    }

    @NotNull
    public final TextStyle getBrightBlue() {
        return this.downsample(TextColors.brightBlue);
    }

    @NotNull
    public final TextStyle getBrightMagenta() {
        return this.downsample(TextColors.brightMagenta);
    }

    @NotNull
    public final TextStyle getBrightCyan() {
        return this.downsample(TextColors.brightCyan);
    }

    @NotNull
    public final TextStyle getBrightWhite() {
        return this.downsample(TextColors.brightWhite);
    }

    @NotNull
    public final TextStyle getSuccess() {
        return this.downsample(this.theme.getSuccess());
    }

    @NotNull
    public final TextStyle getDanger() {
        return this.downsample(this.theme.getDanger());
    }

    @NotNull
    public final TextStyle getWarning() {
        return this.downsample(this.theme.getWarning());
    }

    @NotNull
    public final TextStyle getInfo() {
        return this.downsample(this.theme.getInfo());
    }

    @NotNull
    public final TextStyle getMuted() {
        return this.downsample(this.theme.getMuted());
    }

    @NotNull
    public final TextStyle getBold() {
        return this.downsample(TextStyles.bold.getStyle());
    }

    @NotNull
    public final TextStyle getDim() {
        return this.downsample(TextStyles.dim.getStyle());
    }

    @NotNull
    public final TextStyle getItalic() {
        return this.downsample(TextStyles.italic.getStyle());
    }

    @NotNull
    public final TextStyle getUnderline() {
        return this.downsample(TextStyles.underline.getStyle());
    }

    @NotNull
    public final TextStyle getInverse() {
        return this.downsample(TextStyles.inverse.getStyle());
    }

    @NotNull
    public final TextStyle getStrikethrough() {
        return this.downsample(TextStyles.strikethrough.getStyle());
    }

    @NotNull
    public final TextStyle getPlain() {
        return ConstantsKt.getDEFAULT_STYLE();
    }

    @NotNull
    public final TextStyle rgb(@NotNull String hex) {
        Intrinsics.checkNotNullParameter(hex, "hex");
        return TextColors.Companion.rgb(hex, this.getLevel());
    }

    @NotNull
    public final TextStyle rgb(@NotNull Number r, @NotNull Number g, @NotNull Number b) {
        Intrinsics.checkNotNullParameter(r, "r");
        Intrinsics.checkNotNullParameter(g, "g");
        Intrinsics.checkNotNullParameter(b, "b");
        return TextColors.Companion.rgb(r, g, b, this.getLevel());
    }

    @NotNull
    public final TextStyle hsl(@NotNull Number h, @NotNull Number s, @NotNull Number l) {
        Intrinsics.checkNotNullParameter(h, "h");
        Intrinsics.checkNotNullParameter(s, "s");
        Intrinsics.checkNotNullParameter(l, "l");
        return TextColors.Companion.hsl(h, s, l, this.getLevel());
    }

    @NotNull
    public final TextStyle hsv(@NotNull Number h, @NotNull Number s, @NotNull Number v) {
        Intrinsics.checkNotNullParameter(h, "h");
        Intrinsics.checkNotNullParameter(s, "s");
        Intrinsics.checkNotNullParameter(v, "v");
        return TextColors.Companion.hsv(h, s, v, this.getLevel());
    }

    @NotNull
    public final TextStyle cmyk(int c, int m, int y, int k) {
        return TextColors.Companion.cmyk(c, m, y, k, this.getLevel());
    }

    @NotNull
    public final TextStyle gray(@NotNull Number fraction) {
        Intrinsics.checkNotNullParameter(fraction, "fraction");
        return TextColors.Companion.gray(fraction, this.getLevel());
    }

    @NotNull
    public final TextStyle xyz(@NotNull Number x, @NotNull Number y, @NotNull Number z) {
        Intrinsics.checkNotNullParameter(x, "x");
        Intrinsics.checkNotNullParameter(y, "y");
        Intrinsics.checkNotNullParameter(z, "z");
        return TextColors.Companion.xyz(x, y, z, this.getLevel());
    }

    @NotNull
    public final TextStyle lab(@NotNull Number l, @NotNull Number a, @NotNull Number b) {
        Intrinsics.checkNotNullParameter(l, "l");
        Intrinsics.checkNotNullParameter(a, "a");
        Intrinsics.checkNotNullParameter(b, "b");
        return TextColors.Companion.lab(l, a, b, this.getLevel());
    }

    @NotNull
    public final TextStyle color(@NotNull Color color) {
        Intrinsics.checkNotNullParameter(color, "color");
        return TextColors.Companion.color(color, this.getLevel());
    }

    private final TextStyle downsample(TextStyle style) {
        return AnsiRenderKt.downsample(style, this.getLevel(), this.terminalInfo.getAnsiHyperLinks());
    }

    private final AnsiLevel getLevel() {
        return this.terminalInfo.getAnsiLevel();
    }
}

