/*
 * Decompiled with CFR 0.152.
 */
package org.intellij.markdown.flavours.gfm.table;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.ranges.IntRange;
import kotlin.ranges.RangesKt;
import kotlin.text.StringsKt;
import org.intellij.markdown.IElementType;
import org.intellij.markdown.flavours.gfm.GFMElementTypes;
import org.intellij.markdown.flavours.gfm.GFMTokenTypes;
import org.intellij.markdown.parser.LookaheadText;
import org.intellij.markdown.parser.ProductionHolder;
import org.intellij.markdown.parser.constraints.MarkdownConstraints;
import org.intellij.markdown.parser.constraints.MarkdownConstraintsKt;
import org.intellij.markdown.parser.markerblocks.MarkerBlock;
import org.intellij.markdown.parser.markerblocks.MarkerBlockImpl;
import org.intellij.markdown.parser.sequentialparsers.SequentialParser;
import org.jetbrains.annotations.NotNull;

@Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000X\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\b\n\u0002\b\u0007\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0010\r\n\u0002\b\u0002\u0018\u0000 \"2\u00020\u0001:\u0001\"B)\u0012\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004\u0012\u0006\u0010\u0005\u001a\u00020\u0006\u0012\u0006\u0010\u0007\u001a\u00020\b\u0012\u0006\u0010\t\u001a\u00020\n\u00a2\u0006\u0002\u0010\u000bJ\b\u0010\u0011\u001a\u00020\u0012H\u0016J\u0014\u0010\u0013\u001a\u00020\n2\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004H\u0014J\u001c\u0010\u0014\u001a\u00020\u00152\n\u0010\u0002\u001a\u00060\u0003R\u00020\u00042\u0006\u0010\u0016\u001a\u00020\u0006H\u0014J\u001a\u0010\u0017\u001a\b\u0012\u0004\u0012\u00020\u00190\u00182\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004H\u0002J\b\u0010\u001a\u001a\u00020\u001bH\u0014J\b\u0010\u001c\u001a\u00020\u001dH\u0016J\u0014\u0010\u001e\u001a\u00020\u00122\n\u0010\u0002\u001a\u00060\u0003R\u00020\u0004H\u0016J\u0010\u0010\u001f\u001a\u00020\u00122\u0006\u0010 \u001a\u00020!H\u0002R\u001a\u0010\f\u001a\u00020\nX\u0086\u000e\u00a2\u0006\u000e\n\u0000\u001a\u0004\b\r\u0010\u000e\"\u0004\b\u000f\u0010\u0010R\u000e\u0010\u0007\u001a\u00020\bX\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\t\u001a\u00020\nX\u0082\u0004\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lorg/intellij/markdown/flavours/gfm/table/GitHubTableMarkerBlock;", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlockImpl;", "pos", "Lorg/intellij/markdown/parser/LookaheadText$Position;", "Lorg/intellij/markdown/parser/LookaheadText;", "constraints", "Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;", "productionHolder", "Lorg/intellij/markdown/parser/ProductionHolder;", "tableColumnsNumber", "", "(Lorg/intellij/markdown/parser/LookaheadText$Position;Lorg/intellij/markdown/parser/constraints/MarkdownConstraints;Lorg/intellij/markdown/parser/ProductionHolder;I)V", "currentLine", "getCurrentLine", "()I", "setCurrentLine", "(I)V", "allowsSubBlocks", "", "calcNextInterestingOffset", "doProcessToken", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ProcessingResult;", "currentConstraints", "fillCells", "", "Lorg/intellij/markdown/parser/sequentialparsers/SequentialParser$Node;", "getDefaultAction", "Lorg/intellij/markdown/parser/markerblocks/MarkerBlock$ClosingAction;", "getDefaultNodeType", "Lorg/intellij/markdown/IElementType;", "isInterestingOffset", "isProbablyTableLine", "line", "", "Companion", "markdown"})
public final class GitHubTableMarkerBlock
extends MarkerBlockImpl {
    @NotNull
    public static final Companion Companion = new Companion(null);
    @NotNull
    private final ProductionHolder productionHolder;
    private final int tableColumnsNumber;
    private int currentLine;

    public GitHubTableMarkerBlock(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints constraints, @NotNull ProductionHolder productionHolder, int tableColumnsNumber) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(constraints, "constraints");
        Intrinsics.checkNotNullParameter(productionHolder, "productionHolder");
        super(constraints, productionHolder.mark());
        this.productionHolder = productionHolder;
        this.tableColumnsNumber = tableColumnsNumber;
        this.productionHolder.addProduction((Collection<SequentialParser.Node>)CollectionsKt.listOf(new SequentialParser.Node(new IntRange(pos.getOffset(), pos.getNextLineOrEofOffset()), GFMElementTypes.HEADER)));
        this.productionHolder.addProduction((Collection<SequentialParser.Node>)this.fillCells(pos));
    }

    public final int getCurrentLine() {
        return this.currentLine;
    }

    public final void setCurrentLine(int n) {
        this.currentLine = n;
    }

    @Override
    @NotNull
    protected MarkerBlock.ProcessingResult doProcessToken(@NotNull LookaheadText.Position pos, @NotNull MarkdownConstraints currentConstraints) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        Intrinsics.checkNotNullParameter(currentConstraints, "currentConstraints");
        int n = this.currentLine;
        this.currentLine = n + 1;
        if (this.currentLine == 1) {
            this.productionHolder.addProduction((Collection<SequentialParser.Node>)CollectionsKt.listOf(new SequentialParser.Node(new IntRange(pos.getOffset() + 1, pos.getNextLineOrEofOffset()), GFMTokenTypes.TABLE_SEPARATOR)));
            return MarkerBlock.ProcessingResult.Companion.getCANCEL();
        }
        String line = pos.getCurrentLine();
        if (!this.isProbablyTableLine(line)) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        List<SequentialParser.Node> cellsAndSeps = this.fillCells(pos);
        if (cellsAndSeps.isEmpty()) {
            return MarkerBlock.ProcessingResult.Companion.getDEFAULT();
        }
        this.productionHolder.addProduction(CollectionsKt.plus((Collection)CollectionsKt.listOf(new SequentialParser.Node(new IntRange(CollectionsKt.first(cellsAndSeps).getRange().getFirst(), CollectionsKt.last(cellsAndSeps).getRange().getLast()), GFMElementTypes.ROW)), (Iterable)cellsAndSeps));
        return MarkerBlock.ProcessingResult.Companion.getCANCEL();
    }

    @Override
    @NotNull
    protected MarkerBlock.ClosingAction getDefaultAction() {
        return MarkerBlock.ClosingAction.DONE;
    }

    @Override
    protected int calcNextInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        return pos.getNextLineOrEofOffset();
    }

    @Override
    @NotNull
    public IElementType getDefaultNodeType() {
        return GFMElementTypes.TABLE;
    }

    @Override
    public boolean isInterestingOffset(@NotNull LookaheadText.Position pos) {
        Intrinsics.checkNotNullParameter(pos, "pos");
        return pos.getOffsetInCurrentLine() == -1;
    }

    @Override
    public boolean allowsSubBlocks() {
        return false;
    }

    private final List<SequentialParser.Node> fillCells(LookaheadText.Position pos) {
        ArrayList<SequentialParser.Node> result2 = new ArrayList<SequentialParser.Node>();
        int offset = pos.getOffset();
        if (pos.getOffsetInCurrentLine() == -1) {
            offset += 1 + MarkdownConstraintsKt.getCharsEaten(this.getConstraints(), pos.getCurrentLine());
        }
        CharSequence line = MarkdownConstraintsKt.eatItselfFromString(this.getConstraints(), pos.getCurrentLine());
        List<String> cells2 = Companion.splitByPipes(line);
        int cellNodesAdded = 0;
        int n = cells2.size();
        for (int i = 0; i < n; ++i) {
            String cell2;
            block7: {
                block6: {
                    cell2 = cells2.get(i);
                    if (!StringsKt.isBlank(cell2)) break block6;
                    boolean bl = 1 <= i ? i <= CollectionsKt.getLastIndex(cells2) - 1 : false;
                    if (!bl) break block7;
                }
                result2.add(new SequentialParser.Node(new IntRange(offset, offset + cell2.length()), GFMTokenTypes.CELL));
                ++cellNodesAdded;
            }
            offset += cell2.length();
            if (i < CollectionsKt.getLastIndex(cells2)) {
                result2.add(new SequentialParser.Node(new IntRange(offset, offset + 1), GFMTokenTypes.TABLE_SEPARATOR));
            }
            ++offset;
            if (cellNodesAdded < this.tableColumnsNumber) continue;
            if (offset >= pos.getNextLineOrEofOffset()) break;
            result2.add(new SequentialParser.Node(new IntRange(offset, pos.getNextLineOrEofOffset()), GFMTokenTypes.TABLE_SEPARATOR));
            break;
        }
        return result2;
    }

    private final boolean isProbablyTableLine(CharSequence line) {
        return StringsKt.contains$default(line, '|', false, 2, null);
    }

    @Metadata(mv={1, 7, 0}, k=1, xi=48, d1={"\u0000\u001c\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010 \n\u0002\u0010\u000e\n\u0000\n\u0002\u0010\r\n\u0000\b\u0086\u0003\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u0014\u0010\u0003\u001a\b\u0012\u0004\u0012\u00020\u00050\u00042\u0006\u0010\u0006\u001a\u00020\u0007\u00a8\u0006\b"}, d2={"Lorg/intellij/markdown/flavours/gfm/table/GitHubTableMarkerBlock$Companion;", "", "()V", "splitByPipes", "", "", "text", "", "markdown"})
    public static final class Companion {
        private Companion() {
        }

        @NotNull
        public final List<String> splitByPipes(@NotNull CharSequence text2) {
            Intrinsics.checkNotNullParameter(text2, "text");
            ArrayList<String> result2 = new ArrayList<String>();
            int startIndex = 0;
            int n = text2.length();
            for (int index = 0; index < n; ++index) {
                char charBefore;
                char c = text2.charAt(index);
                if (c != '|' || (charBefore = text2.charAt(RangesKt.coerceAtLeast(index - 1, 0))) == '\\') continue;
                String substring = ((Object)text2.subSequence(startIndex, index)).toString();
                result2.add(substring);
                startIndex = index + 1;
            }
            CharSequence charSequence = text2;
            n = charSequence.length();
            result2.add(((Object)charSequence.subSequence(startIndex, n)).toString());
            return result2;
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

